<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResumeAddPaymentToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResumeAddPaymentToBasket-Request
 * @subpackage Structs
 */
class ResumeAddPaymentToBasket_Request extends ExtensibleDataContract
{
    /**
     * The Accept
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Accept;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for ResumeAddPaymentToBasket-Request
     * @uses ResumeAddPaymentToBasket_Request::setAccept()
     * @uses ResumeAddPaymentToBasket_Request::setItemId()
     * @uses ResumeAddPaymentToBasket_Request::setTransactionGuid()
     * @uses ResumeAddPaymentToBasket_Request::setTransactionSnapshotType()
     * @param string $accept
     * @param int $itemId
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($accept = null, $itemId = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setAccept($accept)
            ->setItemId($itemId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get Accept value
     * @return string|null
     */
    public function getAccept()
    {
        return $this->Accept;
    }
    /**
     * Set Accept value
     * @uses \patest\EnumType\ResumeAction::valueIsValid()
     * @uses \patest\EnumType\ResumeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accept
     * @return \patest\StructType\ResumeAddPaymentToBasket_Request
     */
    public function setAccept($accept = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResumeAction::valueIsValid($accept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResumeAction', is_array($accept) ? implode(', ', $accept) : var_export($accept, true), implode(', ', \patest\EnumType\ResumeAction::getValidValues())), __LINE__);
        }
        $this->Accept = $accept;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\ResumeAddPaymentToBasket_Request
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\ResumeAddPaymentToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\ResumeAddPaymentToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
