<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultPartMetadata StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultPartMetadata
 * @subpackage Structs
 */
class ResultPartMetadata extends AbstractStructBase
{
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Columns;
    /**
     * The IsAllowMissingPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowMissingPoints;
    /**
     * The IsSplitByTimePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSplitByTimePeriod;
    /**
     * The SplitByInstanceNameParts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $SplitByInstanceNameParts;
    /**
     * Constructor method for ResultPartMetadata
     * @uses ResultPartMetadata::setColumns()
     * @uses ResultPartMetadata::setIsAllowMissingPoints()
     * @uses ResultPartMetadata::setIsSplitByTimePeriod()
     * @uses ResultPartMetadata::setSplitByInstanceNameParts()
     * @param \patest\ArrayType\ArrayOfstring $columns
     * @param bool $isAllowMissingPoints
     * @param bool $isSplitByTimePeriod
     * @param string[] $splitByInstanceNameParts
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $columns = null, $isAllowMissingPoints = null, $isSplitByTimePeriod = null, array $splitByInstanceNameParts = array())
    {
        $this
            ->setColumns($columns)
            ->setIsAllowMissingPoints($isAllowMissingPoints)
            ->setIsSplitByTimePeriod($isSplitByTimePeriod)
            ->setSplitByInstanceNameParts($splitByInstanceNameParts);
    }
    /**
     * Get Columns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getColumns()
    {
        return isset($this->Columns) ? $this->Columns : null;
    }
    /**
     * Set Columns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $columns
     * @return \patest\StructType\ResultPartMetadata
     */
    public function setColumns(\patest\ArrayType\ArrayOfstring $columns = null)
    {
        if (is_null($columns) || (is_array($columns) && empty($columns))) {
            unset($this->Columns);
        } else {
            $this->Columns = $columns;
        }
        return $this;
    }
    /**
     * Get IsAllowMissingPoints value
     * @return bool|null
     */
    public function getIsAllowMissingPoints()
    {
        return $this->IsAllowMissingPoints;
    }
    /**
     * Set IsAllowMissingPoints value
     * @param bool $isAllowMissingPoints
     * @return \patest\StructType\ResultPartMetadata
     */
    public function setIsAllowMissingPoints($isAllowMissingPoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowMissingPoints) && !is_bool($isAllowMissingPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowMissingPoints, true), gettype($isAllowMissingPoints)), __LINE__);
        }
        $this->IsAllowMissingPoints = $isAllowMissingPoints;
        return $this;
    }
    /**
     * Get IsSplitByTimePeriod value
     * @return bool|null
     */
    public function getIsSplitByTimePeriod()
    {
        return $this->IsSplitByTimePeriod;
    }
    /**
     * Set IsSplitByTimePeriod value
     * @param bool $isSplitByTimePeriod
     * @return \patest\StructType\ResultPartMetadata
     */
    public function setIsSplitByTimePeriod($isSplitByTimePeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSplitByTimePeriod) && !is_bool($isSplitByTimePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSplitByTimePeriod, true), gettype($isSplitByTimePeriod)), __LINE__);
        }
        $this->IsSplitByTimePeriod = $isSplitByTimePeriod;
        return $this;
    }
    /**
     * Get SplitByInstanceNameParts value
     * @return string[]|null
     */
    public function getSplitByInstanceNameParts()
    {
        return $this->SplitByInstanceNameParts;
    }
    /**
     * This method is responsible for validating the values passed to the setSplitByInstanceNameParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSplitByInstanceNameParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSplitByInstanceNamePartsForArrayConstraintsFromSetSplitByInstanceNameParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultPartMetadataSplitByInstanceNamePartsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\InstanceNamePart::valueIsValid($resultPartMetadataSplitByInstanceNamePartsItem)) {
                $invalidValues[] = is_object($resultPartMetadataSplitByInstanceNamePartsItem) ? get_class($resultPartMetadataSplitByInstanceNamePartsItem) : sprintf('%s(%s)', gettype($resultPartMetadataSplitByInstanceNamePartsItem), var_export($resultPartMetadataSplitByInstanceNamePartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstanceNamePart', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\InstanceNamePart::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SplitByInstanceNameParts value
     * @uses \patest\EnumType\InstanceNamePart::valueIsValid()
     * @uses \patest\EnumType\InstanceNamePart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $splitByInstanceNameParts
     * @return \patest\StructType\ResultPartMetadata
     */
    public function setSplitByInstanceNameParts(array $splitByInstanceNameParts = array())
    {
        // validation for constraint: list
        if ('' !== ($splitByInstanceNamePartsArrayErrorMessage = self::validateSplitByInstanceNamePartsForArrayConstraintsFromSetSplitByInstanceNameParts($splitByInstanceNameParts))) {
            throw new \InvalidArgumentException($splitByInstanceNamePartsArrayErrorMessage, __LINE__);
        }
        $this->SplitByInstanceNameParts = is_array($splitByInstanceNameParts) ? implode(' ', $splitByInstanceNameParts) : null;
        return $this;
    }
}
