<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelocationSeatDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RelocationSeatDetails
 * @subpackage Structs
 */
class RelocationSeatDetails extends AbstractStructBase
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The UseBestAvailableMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseBestAvailableMode;
    /**
     * Constructor method for RelocationSeatDetails
     * @uses RelocationSeatDetails::setAreaId()
     * @uses RelocationSeatDetails::setPriceTypeId()
     * @uses RelocationSeatDetails::setSeatId()
     * @uses RelocationSeatDetails::setSeriesId()
     * @uses RelocationSeatDetails::setUseBestAvailableMode()
     * @param string $areaId
     * @param string $priceTypeId
     * @param int $seatId
     * @param string $seriesId
     * @param bool $useBestAvailableMode
     */
    public function __construct($areaId = null, $priceTypeId = null, $seatId = null, $seriesId = null, $useBestAvailableMode = null)
    {
        $this
            ->setAreaId($areaId)
            ->setPriceTypeId($priceTypeId)
            ->setSeatId($seatId)
            ->setSeriesId($seriesId)
            ->setUseBestAvailableMode($useBestAvailableMode);
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\RelocationSeatDetails
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
    /**
     * Get PriceTypeId value
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return $this->PriceTypeId;
    }
    /**
     * Set PriceTypeId value
     * @param string $priceTypeId
     * @return \patest\StructType\RelocationSeatDetails
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        $this->PriceTypeId = $priceTypeId;
        return $this;
    }
    /**
     * Get SeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatId()
    {
        return isset($this->SeatId) ? $this->SeatId : null;
    }
    /**
     * Set SeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatId
     * @return \patest\StructType\RelocationSeatDetails
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        if (is_null($seatId) || (is_array($seatId) && empty($seatId))) {
            unset($this->SeatId);
        } else {
            $this->SeatId = $seatId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * @return string|null
     */
    public function getSeriesId()
    {
        return $this->SeriesId;
    }
    /**
     * Set SeriesId value
     * @param string $seriesId
     * @return \patest\StructType\RelocationSeatDetails
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        $this->SeriesId = $seriesId;
        return $this;
    }
    /**
     * Get UseBestAvailableMode value
     * @return bool|null
     */
    public function getUseBestAvailableMode()
    {
        return $this->UseBestAvailableMode;
    }
    /**
     * Set UseBestAvailableMode value
     * @param bool $useBestAvailableMode
     * @return \patest\StructType\RelocationSeatDetails
     */
    public function setUseBestAvailableMode($useBestAvailableMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBestAvailableMode) && !is_bool($useBestAvailableMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBestAvailableMode, true), gettype($useBestAvailableMode)), __LINE__);
        }
        $this->UseBestAvailableMode = $useBestAvailableMode;
        return $this;
    }
}
