<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordSetOfHelpDesk.RequestNotificationDefinition
 * StructType
 * @subpackage Structs
 */
class RecordSetOfHelpDesk_RequestNotificationDefinition extends AbstractStructBase
{
    /**
     * The Record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HelpDesk_RequestNotificationDefinition[]
     */
    public $Record;
    /**
     * Constructor method for RecordSetOfHelpDesk.RequestNotificationDefinition
     * @uses RecordSetOfHelpDesk_RequestNotificationDefinition::setRecord()
     * @param \patest\StructType\HelpDesk_RequestNotificationDefinition[] $record
     */
    public function __construct(array $record = array())
    {
        $this
            ->setRecord($record);
    }
    /**
     * Get Record value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HelpDesk_RequestNotificationDefinition[]|null
     */
    public function getRecord()
    {
        return isset($this->Record) ? $this->Record : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem) {
            // validation for constraint: itemType
            if (!$recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem instanceof \patest\StructType\HelpDesk_RequestNotificationDefinition) {
                $invalidValues[] = is_object($recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem) ? get_class($recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem) : sprintf('%s(%s)', gettype($recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem), var_export($recordSetOfHelpDesk_RequestNotificationDefinitionRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Record property can only contain items of type \patest\StructType\HelpDesk_RequestNotificationDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Record value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\HelpDesk_RequestNotificationDefinition[] $record
     * @return \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        if (is_null($record) || (is_array($record) && empty($record))) {
            unset($this->Record);
        } else {
            $this->Record = $record;
        }
        return $this;
    }
    /**
     * Add item to Record value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\HelpDesk_RequestNotificationDefinition $item
     * @return \patest\StructType\RecordSetOfHelpDesk_RequestNotificationDefinition
     */
    public function addToRecord(\patest\StructType\HelpDesk_RequestNotificationDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\HelpDesk_RequestNotificationDefinition) {
            throw new \InvalidArgumentException(sprintf('The Record property can only contain items of type \patest\StructType\HelpDesk_RequestNotificationDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Record[] = $item;
        return $this;
    }
}
