<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReLockOrAllocateSubscriptions-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReLockOrAllocateSubscriptions-Request
 * @subpackage Structs
 */
class ReLockOrAllocateSubscriptions_Request extends ExtensibleDataContract
{
    /**
     * The NewRestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewRestrictionId;
    /**
     * The Subscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSubscriptionProductItem
     */
    public $Subscriptions;
    /**
     * Constructor method for ReLockOrAllocateSubscriptions-Request
     * @uses ReLockOrAllocateSubscriptions_Request::setNewRestrictionId()
     * @uses ReLockOrAllocateSubscriptions_Request::setSubscriptions()
     * @param string $newRestrictionId
     * @param \patest\ArrayType\ArrayOfSubscriptionProductItem $subscriptions
     */
    public function __construct($newRestrictionId = null, \patest\ArrayType\ArrayOfSubscriptionProductItem $subscriptions = null)
    {
        $this
            ->setNewRestrictionId($newRestrictionId)
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get NewRestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewRestrictionId()
    {
        return isset($this->NewRestrictionId) ? $this->NewRestrictionId : null;
    }
    /**
     * Set NewRestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newRestrictionId
     * @return \patest\StructType\ReLockOrAllocateSubscriptions_Request
     */
    public function setNewRestrictionId($newRestrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($newRestrictionId) && !is_string($newRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRestrictionId, true), gettype($newRestrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newRestrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newRestrictionId, true)), __LINE__);
        }
        if (is_null($newRestrictionId) || (is_array($newRestrictionId) && empty($newRestrictionId))) {
            unset($this->NewRestrictionId);
        } else {
            $this->NewRestrictionId = $newRestrictionId;
        }
        return $this;
    }
    /**
     * Get Subscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSubscriptionProductItem|null
     */
    public function getSubscriptions()
    {
        return isset($this->Subscriptions) ? $this->Subscriptions : null;
    }
    /**
     * Set Subscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSubscriptionProductItem $subscriptions
     * @return \patest\StructType\ReLockOrAllocateSubscriptions_Request
     */
    public function setSubscriptions(\patest\ArrayType\ArrayOfSubscriptionProductItem $subscriptions = null)
    {
        if (is_null($subscriptions) || (is_array($subscriptions) && empty($subscriptions))) {
            unset($this->Subscriptions);
        } else {
            $this->Subscriptions = $subscriptions;
        }
        return $this;
    }
}
