<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryTokenContext StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryTokenContext
 * @subpackage Structs
 */
class QueryTokenContext extends ExtensibleDataContract
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EsqlSelectStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EsqlSelectStatement;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * The StatementArguments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EsqlStatementArguments
     */
    public $StatementArguments;
    /**
     * The TempTableName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TempTableName;
    /**
     * The TotalMatchingRowsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalMatchingRowsCount;
    /**
     * The MaxNumberOfLocalIdsToPrefetch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfLocalIdsToPrefetch;
    /**
     * Constructor method for QueryTokenContext
     * @uses QueryTokenContext::setEntityName()
     * @uses QueryTokenContext::setEsqlSelectStatement()
     * @uses QueryTokenContext::setServiceName()
     * @uses QueryTokenContext::setStatementArguments()
     * @uses QueryTokenContext::setTempTableName()
     * @uses QueryTokenContext::setTotalMatchingRowsCount()
     * @uses QueryTokenContext::setMaxNumberOfLocalIdsToPrefetch()
     * @param string $entityName
     * @param string $esqlSelectStatement
     * @param string $serviceName
     * @param \patest\StructType\EsqlStatementArguments $statementArguments
     * @param string $tempTableName
     * @param int $totalMatchingRowsCount
     * @param int $maxNumberOfLocalIdsToPrefetch
     */
    public function __construct($entityName = null, $esqlSelectStatement = null, $serviceName = null, \patest\StructType\EsqlStatementArguments $statementArguments = null, $tempTableName = null, $totalMatchingRowsCount = null, $maxNumberOfLocalIdsToPrefetch = null)
    {
        $this
            ->setEntityName($entityName)
            ->setEsqlSelectStatement($esqlSelectStatement)
            ->setServiceName($serviceName)
            ->setStatementArguments($statementArguments)
            ->setTempTableName($tempTableName)
            ->setTotalMatchingRowsCount($totalMatchingRowsCount)
            ->setMaxNumberOfLocalIdsToPrefetch($maxNumberOfLocalIdsToPrefetch);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\QueryTokenContext
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EsqlSelectStatement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsqlSelectStatement()
    {
        return isset($this->EsqlSelectStatement) ? $this->EsqlSelectStatement : null;
    }
    /**
     * Set EsqlSelectStatement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esqlSelectStatement
     * @return \patest\StructType\QueryTokenContext
     */
    public function setEsqlSelectStatement($esqlSelectStatement = null)
    {
        // validation for constraint: string
        if (!is_null($esqlSelectStatement) && !is_string($esqlSelectStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esqlSelectStatement, true), gettype($esqlSelectStatement)), __LINE__);
        }
        if (is_null($esqlSelectStatement) || (is_array($esqlSelectStatement) && empty($esqlSelectStatement))) {
            unset($this->EsqlSelectStatement);
        } else {
            $this->EsqlSelectStatement = $esqlSelectStatement;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \patest\StructType\QueryTokenContext
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get StatementArguments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EsqlStatementArguments|null
     */
    public function getStatementArguments()
    {
        return isset($this->StatementArguments) ? $this->StatementArguments : null;
    }
    /**
     * Set StatementArguments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EsqlStatementArguments $statementArguments
     * @return \patest\StructType\QueryTokenContext
     */
    public function setStatementArguments(\patest\StructType\EsqlStatementArguments $statementArguments = null)
    {
        if (is_null($statementArguments) || (is_array($statementArguments) && empty($statementArguments))) {
            unset($this->StatementArguments);
        } else {
            $this->StatementArguments = $statementArguments;
        }
        return $this;
    }
    /**
     * Get TempTableName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTempTableName()
    {
        return isset($this->TempTableName) ? $this->TempTableName : null;
    }
    /**
     * Set TempTableName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tempTableName
     * @return \patest\StructType\QueryTokenContext
     */
    public function setTempTableName($tempTableName = null)
    {
        // validation for constraint: string
        if (!is_null($tempTableName) && !is_string($tempTableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tempTableName, true), gettype($tempTableName)), __LINE__);
        }
        if (is_null($tempTableName) || (is_array($tempTableName) && empty($tempTableName))) {
            unset($this->TempTableName);
        } else {
            $this->TempTableName = $tempTableName;
        }
        return $this;
    }
    /**
     * Get TotalMatchingRowsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalMatchingRowsCount()
    {
        return isset($this->TotalMatchingRowsCount) ? $this->TotalMatchingRowsCount : null;
    }
    /**
     * Set TotalMatchingRowsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalMatchingRowsCount
     * @return \patest\StructType\QueryTokenContext
     */
    public function setTotalMatchingRowsCount($totalMatchingRowsCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalMatchingRowsCount) && !(is_int($totalMatchingRowsCount) || ctype_digit($totalMatchingRowsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMatchingRowsCount, true), gettype($totalMatchingRowsCount)), __LINE__);
        }
        if (is_null($totalMatchingRowsCount) || (is_array($totalMatchingRowsCount) && empty($totalMatchingRowsCount))) {
            unset($this->TotalMatchingRowsCount);
        } else {
            $this->TotalMatchingRowsCount = $totalMatchingRowsCount;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfLocalIdsToPrefetch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfLocalIdsToPrefetch()
    {
        return isset($this->MaxNumberOfLocalIdsToPrefetch) ? $this->MaxNumberOfLocalIdsToPrefetch : null;
    }
    /**
     * Set MaxNumberOfLocalIdsToPrefetch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfLocalIdsToPrefetch
     * @return \patest\StructType\QueryTokenContext
     */
    public function setMaxNumberOfLocalIdsToPrefetch($maxNumberOfLocalIdsToPrefetch = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfLocalIdsToPrefetch) && !(is_int($maxNumberOfLocalIdsToPrefetch) || ctype_digit($maxNumberOfLocalIdsToPrefetch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfLocalIdsToPrefetch, true), gettype($maxNumberOfLocalIdsToPrefetch)), __LINE__);
        }
        if (is_null($maxNumberOfLocalIdsToPrefetch) || (is_array($maxNumberOfLocalIdsToPrefetch) && empty($maxNumberOfLocalIdsToPrefetch))) {
            unset($this->MaxNumberOfLocalIdsToPrefetch);
        } else {
            $this->MaxNumberOfLocalIdsToPrefetch = $maxNumberOfLocalIdsToPrefetch;
        }
        return $this;
    }
}
