<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryIdentityPlatformProperties-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryIdentityPlatformProperties-Response
 * @subpackage Structs
 */
class QueryIdentityPlatformProperties_Response extends ExtensibleDataContract
{
    /**
     * The AuthorizationUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationUrl;
    /**
     * The IsFallbackLoginEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFallbackLoginEnabled;
    /**
     * The IsLoginEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLoginEnabled;
    /**
     * The IsOperational
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOperational;
    /**
     * The LogoutUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoutUrl;
    /**
     * The Nonce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nonce;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for QueryIdentityPlatformProperties-Response
     * @uses QueryIdentityPlatformProperties_Response::setAuthorizationUrl()
     * @uses QueryIdentityPlatformProperties_Response::setIsFallbackLoginEnabled()
     * @uses QueryIdentityPlatformProperties_Response::setIsLoginEnabled()
     * @uses QueryIdentityPlatformProperties_Response::setIsOperational()
     * @uses QueryIdentityPlatformProperties_Response::setLogoutUrl()
     * @uses QueryIdentityPlatformProperties_Response::setNonce()
     * @uses QueryIdentityPlatformProperties_Response::setState()
     * @param string $authorizationUrl
     * @param bool $isFallbackLoginEnabled
     * @param bool $isLoginEnabled
     * @param bool $isOperational
     * @param string $logoutUrl
     * @param string $nonce
     * @param string $state
     */
    public function __construct($authorizationUrl = null, $isFallbackLoginEnabled = null, $isLoginEnabled = null, $isOperational = null, $logoutUrl = null, $nonce = null, $state = null)
    {
        $this
            ->setAuthorizationUrl($authorizationUrl)
            ->setIsFallbackLoginEnabled($isFallbackLoginEnabled)
            ->setIsLoginEnabled($isLoginEnabled)
            ->setIsOperational($isOperational)
            ->setLogoutUrl($logoutUrl)
            ->setNonce($nonce)
            ->setState($state);
    }
    /**
     * Get AuthorizationUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationUrl()
    {
        return isset($this->AuthorizationUrl) ? $this->AuthorizationUrl : null;
    }
    /**
     * Set AuthorizationUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationUrl
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setAuthorizationUrl($authorizationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationUrl) && !is_string($authorizationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationUrl, true), gettype($authorizationUrl)), __LINE__);
        }
        if (is_null($authorizationUrl) || (is_array($authorizationUrl) && empty($authorizationUrl))) {
            unset($this->AuthorizationUrl);
        } else {
            $this->AuthorizationUrl = $authorizationUrl;
        }
        return $this;
    }
    /**
     * Get IsFallbackLoginEnabled value
     * @return bool|null
     */
    public function getIsFallbackLoginEnabled()
    {
        return $this->IsFallbackLoginEnabled;
    }
    /**
     * Set IsFallbackLoginEnabled value
     * @param bool $isFallbackLoginEnabled
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setIsFallbackLoginEnabled($isFallbackLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFallbackLoginEnabled) && !is_bool($isFallbackLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFallbackLoginEnabled, true), gettype($isFallbackLoginEnabled)), __LINE__);
        }
        $this->IsFallbackLoginEnabled = $isFallbackLoginEnabled;
        return $this;
    }
    /**
     * Get IsLoginEnabled value
     * @return bool|null
     */
    public function getIsLoginEnabled()
    {
        return $this->IsLoginEnabled;
    }
    /**
     * Set IsLoginEnabled value
     * @param bool $isLoginEnabled
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setIsLoginEnabled($isLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoginEnabled) && !is_bool($isLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoginEnabled, true), gettype($isLoginEnabled)), __LINE__);
        }
        $this->IsLoginEnabled = $isLoginEnabled;
        return $this;
    }
    /**
     * Get IsOperational value
     * @return bool|null
     */
    public function getIsOperational()
    {
        return $this->IsOperational;
    }
    /**
     * Set IsOperational value
     * @param bool $isOperational
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setIsOperational($isOperational = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOperational) && !is_bool($isOperational)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOperational, true), gettype($isOperational)), __LINE__);
        }
        $this->IsOperational = $isOperational;
        return $this;
    }
    /**
     * Get LogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoutUrl()
    {
        return isset($this->LogoutUrl) ? $this->LogoutUrl : null;
    }
    /**
     * Set LogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoutUrl
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setLogoutUrl($logoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoutUrl) && !is_string($logoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoutUrl, true), gettype($logoutUrl)), __LINE__);
        }
        if (is_null($logoutUrl) || (is_array($logoutUrl) && empty($logoutUrl))) {
            unset($this->LogoutUrl);
        } else {
            $this->LogoutUrl = $logoutUrl;
        }
        return $this;
    }
    /**
     * Get Nonce value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonce()
    {
        return isset($this->Nonce) ? $this->Nonce : null;
    }
    /**
     * Set Nonce value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonce
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setNonce($nonce = null)
    {
        // validation for constraint: string
        if (!is_null($nonce) && !is_string($nonce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonce, true), gettype($nonce)), __LINE__);
        }
        if (is_null($nonce) || (is_array($nonce) && empty($nonce))) {
            unset($this->Nonce);
        } else {
            $this->Nonce = $nonce;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
