<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryEntitiesFetchChunk-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryEntitiesFetchChunk-Response
 * @subpackage Structs
 */
class QueryEntitiesFetchChunk_Response extends AbstractStructBase
{
    /**
     * The Entities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAnyEntity
     */
    public $Entities;
    /**
     * The MoreChunksAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoreChunksAvailable;
    /**
     * The RowCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowCount;
    /**
     * Constructor method for QueryEntitiesFetchChunk-Response
     * @uses QueryEntitiesFetchChunk_Response::setEntities()
     * @uses QueryEntitiesFetchChunk_Response::setMoreChunksAvailable()
     * @uses QueryEntitiesFetchChunk_Response::setRowCount()
     * @param \patest\StructType\RecordSetOfAnyEntity $entities
     * @param bool $moreChunksAvailable
     * @param int $rowCount
     */
    public function __construct(\patest\StructType\RecordSetOfAnyEntity $entities = null, $moreChunksAvailable = null, $rowCount = null)
    {
        $this
            ->setEntities($entities)
            ->setMoreChunksAvailable($moreChunksAvailable)
            ->setRowCount($rowCount);
    }
    /**
     * Get Entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAnyEntity|null
     */
    public function getEntities()
    {
        return isset($this->Entities) ? $this->Entities : null;
    }
    /**
     * Set Entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAnyEntity $entities
     * @return \patest\StructType\QueryEntitiesFetchChunk_Response
     */
    public function setEntities(\patest\StructType\RecordSetOfAnyEntity $entities = null)
    {
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->Entities);
        } else {
            $this->Entities = $entities;
        }
        return $this;
    }
    /**
     * Get MoreChunksAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoreChunksAvailable()
    {
        return isset($this->MoreChunksAvailable) ? $this->MoreChunksAvailable : null;
    }
    /**
     * Set MoreChunksAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moreChunksAvailable
     * @return \patest\StructType\QueryEntitiesFetchChunk_Response
     */
    public function setMoreChunksAvailable($moreChunksAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreChunksAvailable) && !is_bool($moreChunksAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreChunksAvailable, true), gettype($moreChunksAvailable)), __LINE__);
        }
        if (is_null($moreChunksAvailable) || (is_array($moreChunksAvailable) && empty($moreChunksAvailable))) {
            unset($this->MoreChunksAvailable);
        } else {
            $this->MoreChunksAvailable = $moreChunksAvailable;
        }
        return $this;
    }
    /**
     * Get RowCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowCount()
    {
        return isset($this->RowCount) ? $this->RowCount : null;
    }
    /**
     * Set RowCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowCount
     * @return \patest\StructType\QueryEntitiesFetchChunk_Response
     */
    public function setRowCount($rowCount = null)
    {
        // validation for constraint: int
        if (!is_null($rowCount) && !(is_int($rowCount) || ctype_digit($rowCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowCount, true), gettype($rowCount)), __LINE__);
        }
        if (is_null($rowCount) || (is_array($rowCount) && empty($rowCount))) {
            unset($this->RowCount);
        } else {
            $this->RowCount = $rowCount;
        }
        return $this;
    }
}
