<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryEntitiesFetchChunk-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryEntitiesFetchChunk-Request
 * @subpackage Structs
 */
class QueryEntitiesFetchChunk_Request extends AbstractStructBase
{
    /**
     * The ChunkRecordCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChunkRecordCount;
    /**
     * The ChunkStartRowIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChunkStartRowIndex;
    /**
     * The QueryToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryToken;
    /**
     * Constructor method for QueryEntitiesFetchChunk-Request
     * @uses QueryEntitiesFetchChunk_Request::setChunkRecordCount()
     * @uses QueryEntitiesFetchChunk_Request::setChunkStartRowIndex()
     * @uses QueryEntitiesFetchChunk_Request::setQueryToken()
     * @param int $chunkRecordCount
     * @param int $chunkStartRowIndex
     * @param string $queryToken
     */
    public function __construct($chunkRecordCount = null, $chunkStartRowIndex = null, $queryToken = null)
    {
        $this
            ->setChunkRecordCount($chunkRecordCount)
            ->setChunkStartRowIndex($chunkStartRowIndex)
            ->setQueryToken($queryToken);
    }
    /**
     * Get ChunkRecordCount value
     * @return int|null
     */
    public function getChunkRecordCount()
    {
        return $this->ChunkRecordCount;
    }
    /**
     * Set ChunkRecordCount value
     * @param int $chunkRecordCount
     * @return \patest\StructType\QueryEntitiesFetchChunk_Request
     */
    public function setChunkRecordCount($chunkRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($chunkRecordCount) && !(is_int($chunkRecordCount) || ctype_digit($chunkRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chunkRecordCount, true), gettype($chunkRecordCount)), __LINE__);
        }
        $this->ChunkRecordCount = $chunkRecordCount;
        return $this;
    }
    /**
     * Get ChunkStartRowIndex value
     * @return int|null
     */
    public function getChunkStartRowIndex()
    {
        return $this->ChunkStartRowIndex;
    }
    /**
     * Set ChunkStartRowIndex value
     * @param int $chunkStartRowIndex
     * @return \patest\StructType\QueryEntitiesFetchChunk_Request
     */
    public function setChunkStartRowIndex($chunkStartRowIndex = null)
    {
        // validation for constraint: int
        if (!is_null($chunkStartRowIndex) && !(is_int($chunkStartRowIndex) || ctype_digit($chunkStartRowIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chunkStartRowIndex, true), gettype($chunkStartRowIndex)), __LINE__);
        }
        $this->ChunkStartRowIndex = $chunkStartRowIndex;
        return $this;
    }
    /**
     * Get QueryToken value
     * @return string|null
     */
    public function getQueryToken()
    {
        return $this->QueryToken;
    }
    /**
     * Set QueryToken value
     * @param string $queryToken
     * @return \patest\StructType\QueryEntitiesFetchChunk_Request
     */
    public function setQueryToken($queryToken = null)
    {
        // validation for constraint: string
        if (!is_null($queryToken) && !is_string($queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryToken, true), gettype($queryToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryToken, true)), __LINE__);
        }
        $this->QueryToken = $queryToken;
        return $this;
    }
}
