<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.QueryOutputProperty StructType
 * @subpackage Structs
 */
class QueryBuilder_QueryOutputProperty extends AnyEntity
{
    /**
     * The ColumnHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ColumnHeader;
    /**
     * The ColumnSortKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ColumnSortKind;
    /**
     * The ColumnWidthKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ColumnWidthKind;
    /**
     * The ContextPropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextPropertyName;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Format;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The IsPersonProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPersonProperty;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The RelatedCriteriaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedCriteriaId;
    /**
     * Constructor method for QueryBuilder.QueryOutputProperty
     * @uses QueryBuilder_QueryOutputProperty::setColumnHeader()
     * @uses QueryBuilder_QueryOutputProperty::setColumnSortKind()
     * @uses QueryBuilder_QueryOutputProperty::setColumnWidthKind()
     * @uses QueryBuilder_QueryOutputProperty::setContextPropertyName()
     * @uses QueryBuilder_QueryOutputProperty::setFormat()
     * @uses QueryBuilder_QueryOutputProperty::setHolderCompanyId()
     * @uses QueryBuilder_QueryOutputProperty::setIsPersonProperty()
     * @uses QueryBuilder_QueryOutputProperty::setOrdinal()
     * @uses QueryBuilder_QueryOutputProperty::setRelatedCriteriaId()
     * @param \patest\StructType\GlobalString $columnHeader
     * @param string $columnSortKind
     * @param string $columnWidthKind
     * @param string $contextPropertyName
     * @param string $format
     * @param int $holderCompanyId
     * @param bool $isPersonProperty
     * @param int $ordinal
     * @param string $relatedCriteriaId
     */
    public function __construct(\patest\StructType\GlobalString $columnHeader = null, $columnSortKind = null, $columnWidthKind = null, $contextPropertyName = null, $format = null, $holderCompanyId = null, $isPersonProperty = null, $ordinal = null, $relatedCriteriaId = null)
    {
        $this
            ->setColumnHeader($columnHeader)
            ->setColumnSortKind($columnSortKind)
            ->setColumnWidthKind($columnWidthKind)
            ->setContextPropertyName($contextPropertyName)
            ->setFormat($format)
            ->setHolderCompanyId($holderCompanyId)
            ->setIsPersonProperty($isPersonProperty)
            ->setOrdinal($ordinal)
            ->setRelatedCriteriaId($relatedCriteriaId);
    }
    /**
     * Get ColumnHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getColumnHeader()
    {
        return isset($this->ColumnHeader) ? $this->ColumnHeader : null;
    }
    /**
     * Set ColumnHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $columnHeader
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setColumnHeader(\patest\StructType\GlobalString $columnHeader = null)
    {
        if (is_null($columnHeader) || (is_array($columnHeader) && empty($columnHeader))) {
            unset($this->ColumnHeader);
        } else {
            $this->ColumnHeader = $columnHeader;
        }
        return $this;
    }
    /**
     * Get ColumnSortKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColumnSortKind()
    {
        return isset($this->ColumnSortKind) ? $this->ColumnSortKind : null;
    }
    /**
     * Set ColumnSortKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ColumnSortKind::valueIsValid()
     * @uses \patest\EnumType\ColumnSortKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $columnSortKind
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setColumnSortKind($columnSortKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ColumnSortKind::valueIsValid($columnSortKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ColumnSortKind', is_array($columnSortKind) ? implode(', ', $columnSortKind) : var_export($columnSortKind, true), implode(', ', \patest\EnumType\ColumnSortKind::getValidValues())), __LINE__);
        }
        if (is_null($columnSortKind) || (is_array($columnSortKind) && empty($columnSortKind))) {
            unset($this->ColumnSortKind);
        } else {
            $this->ColumnSortKind = $columnSortKind;
        }
        return $this;
    }
    /**
     * Get ColumnWidthKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColumnWidthKind()
    {
        return isset($this->ColumnWidthKind) ? $this->ColumnWidthKind : null;
    }
    /**
     * Set ColumnWidthKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ColumnWidthKind::valueIsValid()
     * @uses \patest\EnumType\ColumnWidthKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $columnWidthKind
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setColumnWidthKind($columnWidthKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ColumnWidthKind::valueIsValid($columnWidthKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ColumnWidthKind', is_array($columnWidthKind) ? implode(', ', $columnWidthKind) : var_export($columnWidthKind, true), implode(', ', \patest\EnumType\ColumnWidthKind::getValidValues())), __LINE__);
        }
        if (is_null($columnWidthKind) || (is_array($columnWidthKind) && empty($columnWidthKind))) {
            unset($this->ColumnWidthKind);
        } else {
            $this->ColumnWidthKind = $columnWidthKind;
        }
        return $this;
    }
    /**
     * Get ContextPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextPropertyName()
    {
        return isset($this->ContextPropertyName) ? $this->ContextPropertyName : null;
    }
    /**
     * Set ContextPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextPropertyName
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setContextPropertyName($contextPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($contextPropertyName) && !is_string($contextPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextPropertyName, true), gettype($contextPropertyName)), __LINE__);
        }
        if (is_null($contextPropertyName) || (is_array($contextPropertyName) && empty($contextPropertyName))) {
            unset($this->ContextPropertyName);
        } else {
            $this->ContextPropertyName = $contextPropertyName;
        }
        return $this;
    }
    /**
     * Get Format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormat()
    {
        return isset($this->Format) ? $this->Format : null;
    }
    /**
     * Set Format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $format
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->Format);
        } else {
            $this->Format = $format;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get IsPersonProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPersonProperty()
    {
        return isset($this->IsPersonProperty) ? $this->IsPersonProperty : null;
    }
    /**
     * Set IsPersonProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPersonProperty
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setIsPersonProperty($isPersonProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPersonProperty) && !is_bool($isPersonProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPersonProperty, true), gettype($isPersonProperty)), __LINE__);
        }
        if (is_null($isPersonProperty) || (is_array($isPersonProperty) && empty($isPersonProperty))) {
            unset($this->IsPersonProperty);
        } else {
            $this->IsPersonProperty = $isPersonProperty;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get RelatedCriteriaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedCriteriaId()
    {
        return isset($this->RelatedCriteriaId) ? $this->RelatedCriteriaId : null;
    }
    /**
     * Set RelatedCriteriaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedCriteriaId
     * @return \patest\StructType\QueryBuilder_QueryOutputProperty
     */
    public function setRelatedCriteriaId($relatedCriteriaId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedCriteriaId) && !is_string($relatedCriteriaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedCriteriaId, true), gettype($relatedCriteriaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedCriteriaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedCriteriaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedCriteriaId, true)), __LINE__);
        }
        if (is_null($relatedCriteriaId) || (is_array($relatedCriteriaId) && empty($relatedCriteriaId))) {
            unset($this->RelatedCriteriaId);
        } else {
            $this->RelatedCriteriaId = $relatedCriteriaId;
        }
        return $this;
    }
}
