<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.OutputColumnToSave StructType
 * @subpackage Structs
 */
class QueryBuilder_OutputColumnToSave extends AnyEntity
{
    /**
     * The ColumnHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ColumnHeader;
    /**
     * The ColumnSortKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ColumnSortKind;
    /**
     * The ContextPropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextPropertyName;
    /**
     * The isPersonProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isPersonProperty;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * Constructor method for QueryBuilder.OutputColumnToSave
     * @uses QueryBuilder_OutputColumnToSave::setColumnHeader()
     * @uses QueryBuilder_OutputColumnToSave::setColumnSortKind()
     * @uses QueryBuilder_OutputColumnToSave::setContextPropertyName()
     * @uses QueryBuilder_OutputColumnToSave::setIsPersonProperty()
     * @uses QueryBuilder_OutputColumnToSave::setOrdinal()
     * @param \patest\StructType\GlobalString $columnHeader
     * @param string $columnSortKind
     * @param string $contextPropertyName
     * @param bool $isPersonProperty
     * @param int $ordinal
     */
    public function __construct(\patest\StructType\GlobalString $columnHeader = null, $columnSortKind = null, $contextPropertyName = null, $isPersonProperty = null, $ordinal = null)
    {
        $this
            ->setColumnHeader($columnHeader)
            ->setColumnSortKind($columnSortKind)
            ->setContextPropertyName($contextPropertyName)
            ->setIsPersonProperty($isPersonProperty)
            ->setOrdinal($ordinal);
    }
    /**
     * Get ColumnHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getColumnHeader()
    {
        return isset($this->ColumnHeader) ? $this->ColumnHeader : null;
    }
    /**
     * Set ColumnHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $columnHeader
     * @return \patest\StructType\QueryBuilder_OutputColumnToSave
     */
    public function setColumnHeader(\patest\StructType\GlobalString $columnHeader = null)
    {
        if (is_null($columnHeader) || (is_array($columnHeader) && empty($columnHeader))) {
            unset($this->ColumnHeader);
        } else {
            $this->ColumnHeader = $columnHeader;
        }
        return $this;
    }
    /**
     * Get ColumnSortKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColumnSortKind()
    {
        return isset($this->ColumnSortKind) ? $this->ColumnSortKind : null;
    }
    /**
     * Set ColumnSortKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ColumnSortKind::valueIsValid()
     * @uses \patest\EnumType\ColumnSortKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $columnSortKind
     * @return \patest\StructType\QueryBuilder_OutputColumnToSave
     */
    public function setColumnSortKind($columnSortKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ColumnSortKind::valueIsValid($columnSortKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ColumnSortKind', is_array($columnSortKind) ? implode(', ', $columnSortKind) : var_export($columnSortKind, true), implode(', ', \patest\EnumType\ColumnSortKind::getValidValues())), __LINE__);
        }
        if (is_null($columnSortKind) || (is_array($columnSortKind) && empty($columnSortKind))) {
            unset($this->ColumnSortKind);
        } else {
            $this->ColumnSortKind = $columnSortKind;
        }
        return $this;
    }
    /**
     * Get ContextPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextPropertyName()
    {
        return isset($this->ContextPropertyName) ? $this->ContextPropertyName : null;
    }
    /**
     * Set ContextPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextPropertyName
     * @return \patest\StructType\QueryBuilder_OutputColumnToSave
     */
    public function setContextPropertyName($contextPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($contextPropertyName) && !is_string($contextPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextPropertyName, true), gettype($contextPropertyName)), __LINE__);
        }
        if (is_null($contextPropertyName) || (is_array($contextPropertyName) && empty($contextPropertyName))) {
            unset($this->ContextPropertyName);
        } else {
            $this->ContextPropertyName = $contextPropertyName;
        }
        return $this;
    }
    /**
     * Get isPersonProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPersonProperty()
    {
        return isset($this->isPersonProperty) ? $this->isPersonProperty : null;
    }
    /**
     * Set isPersonProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPersonProperty
     * @return \patest\StructType\QueryBuilder_OutputColumnToSave
     */
    public function setIsPersonProperty($isPersonProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPersonProperty) && !is_bool($isPersonProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPersonProperty, true), gettype($isPersonProperty)), __LINE__);
        }
        if (is_null($isPersonProperty) || (is_array($isPersonProperty) && empty($isPersonProperty))) {
            unset($this->isPersonProperty);
        } else {
            $this->isPersonProperty = $isPersonProperty;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\QueryBuilder_OutputColumnToSave
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
}
