<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.SpoolPrintableItem StructType
 * @subpackage Structs
 */
class Printing_SpoolPrintableItem extends Printing_SpoolItem
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The GeneratedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocument;
    /**
     * The GeneratedDocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocumentType;
    /**
     * The IsGeneratedDocumentCompressed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGeneratedDocumentCompressed;
    /**
     * The PrintedVirtually
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintedVirtually;
    /**
     * The ReferenceEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceEntityName;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * The Retries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Retries;
    /**
     * The SentToPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SentToPrinterId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusChangeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusChangeDate;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The TargetPrinterTrayId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterTrayId;
    /**
     * Constructor method for Printing.SpoolPrintableItem
     * @uses Printing_SpoolPrintableItem::setDocumentId()
     * @uses Printing_SpoolPrintableItem::setDocumentTypeId()
     * @uses Printing_SpoolPrintableItem::setGeneratedDocument()
     * @uses Printing_SpoolPrintableItem::setGeneratedDocumentType()
     * @uses Printing_SpoolPrintableItem::setIsGeneratedDocumentCompressed()
     * @uses Printing_SpoolPrintableItem::setPrintedVirtually()
     * @uses Printing_SpoolPrintableItem::setReferenceEntityName()
     * @uses Printing_SpoolPrintableItem::setReferenceId()
     * @uses Printing_SpoolPrintableItem::setRetries()
     * @uses Printing_SpoolPrintableItem::setSentToPrinterId()
     * @uses Printing_SpoolPrintableItem::setStatus()
     * @uses Printing_SpoolPrintableItem::setStatusChangeDate()
     * @uses Printing_SpoolPrintableItem::setTargetPrinterId()
     * @uses Printing_SpoolPrintableItem::setTargetPrinterTrayId()
     * @param string $documentId
     * @param string $documentTypeId
     * @param string $generatedDocument
     * @param string $generatedDocumentType
     * @param bool $isGeneratedDocumentCompressed
     * @param bool $printedVirtually
     * @param string $referenceEntityName
     * @param string $referenceId
     * @param int $retries
     * @param string $sentToPrinterId
     * @param string $status
     * @param string $statusChangeDate
     * @param string $targetPrinterId
     * @param string $targetPrinterTrayId
     */
    public function __construct($documentId = null, $documentTypeId = null, $generatedDocument = null, $generatedDocumentType = null, $isGeneratedDocumentCompressed = null, $printedVirtually = null, $referenceEntityName = null, $referenceId = null, $retries = null, $sentToPrinterId = null, $status = null, $statusChangeDate = null, $targetPrinterId = null, $targetPrinterTrayId = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setDocumentTypeId($documentTypeId)
            ->setGeneratedDocument($generatedDocument)
            ->setGeneratedDocumentType($generatedDocumentType)
            ->setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed)
            ->setPrintedVirtually($printedVirtually)
            ->setReferenceEntityName($referenceEntityName)
            ->setReferenceId($referenceId)
            ->setRetries($retries)
            ->setSentToPrinterId($sentToPrinterId)
            ->setStatus($status)
            ->setStatusChangeDate($statusChangeDate)
            ->setTargetPrinterId($targetPrinterId)
            ->setTargetPrinterTrayId($targetPrinterTrayId);
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return isset($this->DocumentTypeId) ? $this->DocumentTypeId : null;
    }
    /**
     * Set DocumentTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        if (is_null($documentTypeId) || (is_array($documentTypeId) && empty($documentTypeId))) {
            unset($this->DocumentTypeId);
        } else {
            $this->DocumentTypeId = $documentTypeId;
        }
        return $this;
    }
    /**
     * Get GeneratedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocument()
    {
        return isset($this->GeneratedDocument) ? $this->GeneratedDocument : null;
    }
    /**
     * Set GeneratedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocument
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setGeneratedDocument($generatedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocument) && !is_string($generatedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocument, true), gettype($generatedDocument)), __LINE__);
        }
        if (is_null($generatedDocument) || (is_array($generatedDocument) && empty($generatedDocument))) {
            unset($this->GeneratedDocument);
        } else {
            $this->GeneratedDocument = $generatedDocument;
        }
        return $this;
    }
    /**
     * Get GeneratedDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocumentType()
    {
        return isset($this->GeneratedDocumentType) ? $this->GeneratedDocumentType : null;
    }
    /**
     * Set GeneratedDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocumentType
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setGeneratedDocumentType($generatedDocumentType = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocumentType) && !is_string($generatedDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocumentType, true), gettype($generatedDocumentType)), __LINE__);
        }
        if (is_null($generatedDocumentType) || (is_array($generatedDocumentType) && empty($generatedDocumentType))) {
            unset($this->GeneratedDocumentType);
        } else {
            $this->GeneratedDocumentType = $generatedDocumentType;
        }
        return $this;
    }
    /**
     * Get IsGeneratedDocumentCompressed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGeneratedDocumentCompressed()
    {
        return isset($this->IsGeneratedDocumentCompressed) ? $this->IsGeneratedDocumentCompressed : null;
    }
    /**
     * Set IsGeneratedDocumentCompressed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGeneratedDocumentCompressed
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGeneratedDocumentCompressed) && !is_bool($isGeneratedDocumentCompressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGeneratedDocumentCompressed, true), gettype($isGeneratedDocumentCompressed)), __LINE__);
        }
        if (is_null($isGeneratedDocumentCompressed) || (is_array($isGeneratedDocumentCompressed) && empty($isGeneratedDocumentCompressed))) {
            unset($this->IsGeneratedDocumentCompressed);
        } else {
            $this->IsGeneratedDocumentCompressed = $isGeneratedDocumentCompressed;
        }
        return $this;
    }
    /**
     * Get PrintedVirtually value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintedVirtually()
    {
        return isset($this->PrintedVirtually) ? $this->PrintedVirtually : null;
    }
    /**
     * Set PrintedVirtually value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printedVirtually
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setPrintedVirtually($printedVirtually = null)
    {
        // validation for constraint: boolean
        if (!is_null($printedVirtually) && !is_bool($printedVirtually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printedVirtually, true), gettype($printedVirtually)), __LINE__);
        }
        if (is_null($printedVirtually) || (is_array($printedVirtually) && empty($printedVirtually))) {
            unset($this->PrintedVirtually);
        } else {
            $this->PrintedVirtually = $printedVirtually;
        }
        return $this;
    }
    /**
     * Get ReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceEntityName()
    {
        return isset($this->ReferenceEntityName) ? $this->ReferenceEntityName : null;
    }
    /**
     * Set ReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceEntityName
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setReferenceEntityName($referenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceEntityName) && !is_string($referenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceEntityName, true), gettype($referenceEntityName)), __LINE__);
        }
        if (is_null($referenceEntityName) || (is_array($referenceEntityName) && empty($referenceEntityName))) {
            unset($this->ReferenceEntityName);
        } else {
            $this->ReferenceEntityName = $referenceEntityName;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get Retries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetries()
    {
        return isset($this->Retries) ? $this->Retries : null;
    }
    /**
     * Set Retries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retries
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setRetries($retries = null)
    {
        // validation for constraint: int
        if (!is_null($retries) && !(is_int($retries) || ctype_digit($retries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retries, true), gettype($retries)), __LINE__);
        }
        if (is_null($retries) || (is_array($retries) && empty($retries))) {
            unset($this->Retries);
        } else {
            $this->Retries = $retries;
        }
        return $this;
    }
    /**
     * Get SentToPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentToPrinterId()
    {
        return isset($this->SentToPrinterId) ? $this->SentToPrinterId : null;
    }
    /**
     * Set SentToPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentToPrinterId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setSentToPrinterId($sentToPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($sentToPrinterId) && !is_string($sentToPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentToPrinterId, true), gettype($sentToPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sentToPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sentToPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sentToPrinterId, true)), __LINE__);
        }
        if (is_null($sentToPrinterId) || (is_array($sentToPrinterId) && empty($sentToPrinterId))) {
            unset($this->SentToPrinterId);
        } else {
            $this->SentToPrinterId = $sentToPrinterId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SpoolItemStatus::valueIsValid()
     * @uses \patest\EnumType\SpoolItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SpoolItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SpoolItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\SpoolItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusChangeDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusChangeDate()
    {
        return isset($this->StatusChangeDate) ? $this->StatusChangeDate : null;
    }
    /**
     * Set StatusChangeDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusChangeDate
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setStatusChangeDate($statusChangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusChangeDate) && !is_string($statusChangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusChangeDate, true), gettype($statusChangeDate)), __LINE__);
        }
        if (is_null($statusChangeDate) || (is_array($statusChangeDate) && empty($statusChangeDate))) {
            unset($this->StatusChangeDate);
        } else {
            $this->StatusChangeDate = $statusChangeDate;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get TargetPrinterTrayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterTrayId()
    {
        return isset($this->TargetPrinterTrayId) ? $this->TargetPrinterTrayId : null;
    }
    /**
     * Set TargetPrinterTrayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterTrayId
     * @return \patest\StructType\Printing_SpoolPrintableItem
     */
    public function setTargetPrinterTrayId($targetPrinterTrayId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterTrayId) && !is_string($targetPrinterTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterTrayId, true), gettype($targetPrinterTrayId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterTrayId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterTrayId, true)), __LINE__);
        }
        if (is_null($targetPrinterTrayId) || (is_array($targetPrinterTrayId) && empty($targetPrinterTrayId))) {
            unset($this->TargetPrinterTrayId);
        } else {
            $this->TargetPrinterTrayId = $targetPrinterTrayId;
        }
        return $this;
    }
}
