<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.SpoolGroupArchived StructType
 * @subpackage Structs
 */
class Printing_SpoolGroupArchived extends PersistableEntity
{
    /**
     * The ArchiveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArchiveDateTime;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The AuxDataItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived
     */
    public $AuxDataItems;
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The BatchItemIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchItemIndex;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The IsReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReprint;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrintableItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived
     */
    public $PrintableItems;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ReferenceEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceEntityName;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Printing.SpoolGroupArchived
     * @uses Printing_SpoolGroupArchived::setArchiveDateTime()
     * @uses Printing_SpoolGroupArchived::setAuditId()
     * @uses Printing_SpoolGroupArchived::setAuxDataItems()
     * @uses Printing_SpoolGroupArchived::setBatchId()
     * @uses Printing_SpoolGroupArchived::setBatchItemIndex()
     * @uses Printing_SpoolGroupArchived::setCreationDate()
     * @uses Printing_SpoolGroupArchived::setCultureId()
     * @uses Printing_SpoolGroupArchived::setIsReprint()
     * @uses Printing_SpoolGroupArchived::setOrganizationUnitId()
     * @uses Printing_SpoolGroupArchived::setPrintableItems()
     * @uses Printing_SpoolGroupArchived::setPriority()
     * @uses Printing_SpoolGroupArchived::setReferenceEntityName()
     * @uses Printing_SpoolGroupArchived::setReferenceId()
     * @uses Printing_SpoolGroupArchived::setSalePointId()
     * @uses Printing_SpoolGroupArchived::setScenario()
     * @uses Printing_SpoolGroupArchived::setUserId()
     * @param string $archiveDateTime
     * @param int $auditId
     * @param \patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived $auxDataItems
     * @param string $batchId
     * @param int $batchItemIndex
     * @param string $creationDate
     * @param int $cultureId
     * @param bool $isReprint
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived $printableItems
     * @param int $priority
     * @param string $referenceEntityName
     * @param string $referenceId
     * @param string $salePointId
     * @param string $scenario
     * @param string $userId
     */
    public function __construct($archiveDateTime = null, $auditId = null, \patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived $auxDataItems = null, $batchId = null, $batchItemIndex = null, $creationDate = null, $cultureId = null, $isReprint = null, $organizationUnitId = null, \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived $printableItems = null, $priority = null, $referenceEntityName = null, $referenceId = null, $salePointId = null, $scenario = null, $userId = null)
    {
        $this
            ->setArchiveDateTime($archiveDateTime)
            ->setAuditId($auditId)
            ->setAuxDataItems($auxDataItems)
            ->setBatchId($batchId)
            ->setBatchItemIndex($batchItemIndex)
            ->setCreationDate($creationDate)
            ->setCultureId($cultureId)
            ->setIsReprint($isReprint)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrintableItems($printableItems)
            ->setPriority($priority)
            ->setReferenceEntityName($referenceEntityName)
            ->setReferenceId($referenceId)
            ->setSalePointId($salePointId)
            ->setScenario($scenario)
            ->setUserId($userId);
    }
    /**
     * Get ArchiveDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArchiveDateTime()
    {
        return isset($this->ArchiveDateTime) ? $this->ArchiveDateTime : null;
    }
    /**
     * Set ArchiveDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $archiveDateTime
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setArchiveDateTime($archiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($archiveDateTime) && !is_string($archiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveDateTime, true), gettype($archiveDateTime)), __LINE__);
        }
        if (is_null($archiveDateTime) || (is_array($archiveDateTime) && empty($archiveDateTime))) {
            unset($this->ArchiveDateTime);
        } else {
            $this->ArchiveDateTime = $archiveDateTime;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get AuxDataItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived|null
     */
    public function getAuxDataItems()
    {
        return isset($this->AuxDataItems) ? $this->AuxDataItems : null;
    }
    /**
     * Set AuxDataItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived $auxDataItems
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setAuxDataItems(\patest\StructType\RecordSetOfPrinting_SpoolAuxDataItemArchived $auxDataItems = null)
    {
        if (is_null($auxDataItems) || (is_array($auxDataItems) && empty($auxDataItems))) {
            unset($this->AuxDataItems);
        } else {
            $this->AuxDataItems = $auxDataItems;
        }
        return $this;
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get BatchItemIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchItemIndex()
    {
        return isset($this->BatchItemIndex) ? $this->BatchItemIndex : null;
    }
    /**
     * Set BatchItemIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchItemIndex
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setBatchItemIndex($batchItemIndex = null)
    {
        // validation for constraint: int
        if (!is_null($batchItemIndex) && !(is_int($batchItemIndex) || ctype_digit($batchItemIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchItemIndex, true), gettype($batchItemIndex)), __LINE__);
        }
        if (is_null($batchItemIndex) || (is_array($batchItemIndex) && empty($batchItemIndex))) {
            unset($this->BatchItemIndex);
        } else {
            $this->BatchItemIndex = $batchItemIndex;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get IsReprint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReprint()
    {
        return isset($this->IsReprint) ? $this->IsReprint : null;
    }
    /**
     * Set IsReprint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReprint
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setIsReprint($isReprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReprint) && !is_bool($isReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReprint, true), gettype($isReprint)), __LINE__);
        }
        if (is_null($isReprint) || (is_array($isReprint) && empty($isReprint))) {
            unset($this->IsReprint);
        } else {
            $this->IsReprint = $isReprint;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrintableItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived|null
     */
    public function getPrintableItems()
    {
        return isset($this->PrintableItems) ? $this->PrintableItems : null;
    }
    /**
     * Set PrintableItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived $printableItems
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setPrintableItems(\patest\StructType\RecordSetOfPrinting_SpoolPrintableItemArchived $printableItems = null)
    {
        if (is_null($printableItems) || (is_array($printableItems) && empty($printableItems))) {
            unset($this->PrintableItems);
        } else {
            $this->PrintableItems = $printableItems;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceEntityName()
    {
        return isset($this->ReferenceEntityName) ? $this->ReferenceEntityName : null;
    }
    /**
     * Set ReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceEntityName
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setReferenceEntityName($referenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceEntityName) && !is_string($referenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceEntityName, true), gettype($referenceEntityName)), __LINE__);
        }
        if (is_null($referenceEntityName) || (is_array($referenceEntityName) && empty($referenceEntityName))) {
            unset($this->ReferenceEntityName);
        } else {
            $this->ReferenceEntityName = $referenceEntityName;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_SpoolGroupArchived
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
