<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.SubscriptionInfo StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_SubscriptionInfo extends Printing_Item_ComplexProperty_Base
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The ExtraFieldsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_Sales_ExtraFieldsData
     */
    public $ExtraFieldsData;
    /**
     * The Season
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_SeriesSeason
     */
    public $Season;
    /**
     * The Series
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Series
     */
    public $Series;
    /**
     * The Subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Subscription
     */
    public $Subscription;
    /**
     * The SubscriptionInstance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_SubscriptionInstance
     */
    public $SubscriptionInstance;
    /**
     * Constructor method for Printing.PrintableItem.SubscriptionInfo
     * @uses Printing_PrintableItem_SubscriptionInfo::setCardNumber()
     * @uses Printing_PrintableItem_SubscriptionInfo::setExtraFieldsData()
     * @uses Printing_PrintableItem_SubscriptionInfo::setSeason()
     * @uses Printing_PrintableItem_SubscriptionInfo::setSeries()
     * @uses Printing_PrintableItem_SubscriptionInfo::setSubscription()
     * @uses Printing_PrintableItem_SubscriptionInfo::setSubscriptionInstance()
     * @param string $cardNumber
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @param \patest\StructType\Ticketing_Printing_SeriesSeason $season
     * @param \patest\StructType\Ticketing_Printing_Series $series
     * @param \patest\StructType\Ticketing_Printing_Subscription $subscription
     * @param \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance
     */
    public function __construct($cardNumber = null, \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null, \patest\StructType\Ticketing_Printing_SeriesSeason $season = null, \patest\StructType\Ticketing_Printing_Series $series = null, \patest\StructType\Ticketing_Printing_Subscription $subscription = null, \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setExtraFieldsData($extraFieldsData)
            ->setSeason($season)
            ->setSeries($series)
            ->setSubscription($subscription)
            ->setSubscriptionInstance($subscriptionInstance);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get ExtraFieldsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_Sales_ExtraFieldsData|null
     */
    public function getExtraFieldsData()
    {
        return isset($this->ExtraFieldsData) ? $this->ExtraFieldsData : null;
    }
    /**
     * Set ExtraFieldsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setExtraFieldsData(\patest\StructType\Printing_Sales_ExtraFieldsData $extraFieldsData = null)
    {
        if (is_null($extraFieldsData) || (is_array($extraFieldsData) && empty($extraFieldsData))) {
            unset($this->ExtraFieldsData);
        } else {
            $this->ExtraFieldsData = $extraFieldsData;
        }
        return $this;
    }
    /**
     * Get Season value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_SeriesSeason|null
     */
    public function getSeason()
    {
        return isset($this->Season) ? $this->Season : null;
    }
    /**
     * Set Season value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_SeriesSeason $season
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setSeason(\patest\StructType\Ticketing_Printing_SeriesSeason $season = null)
    {
        if (is_null($season) || (is_array($season) && empty($season))) {
            unset($this->Season);
        } else {
            $this->Season = $season;
        }
        return $this;
    }
    /**
     * Get Series value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Series|null
     */
    public function getSeries()
    {
        return isset($this->Series) ? $this->Series : null;
    }
    /**
     * Set Series value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Series $series
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setSeries(\patest\StructType\Ticketing_Printing_Series $series = null)
    {
        if (is_null($series) || (is_array($series) && empty($series))) {
            unset($this->Series);
        } else {
            $this->Series = $series;
        }
        return $this;
    }
    /**
     * Get Subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Subscription|null
     */
    public function getSubscription()
    {
        return isset($this->Subscription) ? $this->Subscription : null;
    }
    /**
     * Set Subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Subscription $subscription
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setSubscription(\patest\StructType\Ticketing_Printing_Subscription $subscription = null)
    {
        if (is_null($subscription) || (is_array($subscription) && empty($subscription))) {
            unset($this->Subscription);
        } else {
            $this->Subscription = $subscription;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_SubscriptionInstance|null
     */
    public function getSubscriptionInstance()
    {
        return isset($this->SubscriptionInstance) ? $this->SubscriptionInstance : null;
    }
    /**
     * Set SubscriptionInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public function setSubscriptionInstance(\patest\StructType\Ticketing_Printing_SubscriptionInstance $subscriptionInstance = null)
    {
        if (is_null($subscriptionInstance) || (is_array($subscriptionInstance) && empty($subscriptionInstance))) {
            unset($this->SubscriptionInstance);
        } else {
            $this->SubscriptionInstance = $subscriptionInstance;
        }
        return $this;
    }
}
