<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.Service StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_Service extends AnyEntity
{
    /**
     * The MerchandiseItemTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MerchandiseItemTypeName;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneAccount
     */
    public $Payer;
    /**
     * The PricePerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerUnit;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ServiceName;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * Constructor method for Printing.PrintableItem.Service
     * @uses Printing_PrintableItem_Service::setMerchandiseItemTypeName()
     * @uses Printing_PrintableItem_Service::setPayer()
     * @uses Printing_PrintableItem_Service::setPricePerUnit()
     * @uses Printing_PrintableItem_Service::setQuantity()
     * @uses Printing_PrintableItem_Service::setServiceName()
     * @uses Printing_PrintableItem_Service::setTotalPrice()
     * @param \patest\StructType\GlobalString $merchandiseItemTypeName
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @param float $pricePerUnit
     * @param int $quantity
     * @param \patest\StructType\GlobalString $serviceName
     * @param float $totalPrice
     */
    public function __construct(\patest\StructType\GlobalString $merchandiseItemTypeName = null, \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null, $pricePerUnit = null, $quantity = null, \patest\StructType\GlobalString $serviceName = null, $totalPrice = null)
    {
        $this
            ->setMerchandiseItemTypeName($merchandiseItemTypeName)
            ->setPayer($payer)
            ->setPricePerUnit($pricePerUnit)
            ->setQuantity($quantity)
            ->setServiceName($serviceName)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get MerchandiseItemTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandiseItemTypeName()
    {
        return isset($this->MerchandiseItemTypeName) ? $this->MerchandiseItemTypeName : null;
    }
    /**
     * Set MerchandiseItemTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandiseItemTypeName
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setMerchandiseItemTypeName(\patest\StructType\GlobalString $merchandiseItemTypeName = null)
    {
        if (is_null($merchandiseItemTypeName) || (is_array($merchandiseItemTypeName) && empty($merchandiseItemTypeName))) {
            unset($this->MerchandiseItemTypeName);
        } else {
            $this->MerchandiseItemTypeName = $merchandiseItemTypeName;
        }
        return $this;
    }
    /**
     * Get Payer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneAccount|null
     */
    public function getPayer()
    {
        return isset($this->Payer) ? $this->Payer : null;
    }
    /**
     * Set Payer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setPayer(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null)
    {
        if (is_null($payer) || (is_array($payer) && empty($payer))) {
            unset($this->Payer);
        } else {
            $this->Payer = $payer;
        }
        return $this;
    }
    /**
     * Get PricePerUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return isset($this->PricePerUnit) ? $this->PricePerUnit : null;
    }
    /**
     * Set PricePerUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerUnit
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setPricePerUnit($pricePerUnit = null)
    {
        // validation for constraint: float
        if (!is_null($pricePerUnit) && !(is_float($pricePerUnit) || is_numeric($pricePerUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePerUnit, true), gettype($pricePerUnit)), __LINE__);
        }
        if (is_null($pricePerUnit) || (is_array($pricePerUnit) && empty($pricePerUnit))) {
            unset($this->PricePerUnit);
        } else {
            $this->PricePerUnit = $pricePerUnit;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $serviceName
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setServiceName(\patest\StructType\GlobalString $serviceName = null)
    {
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \patest\StructType\Printing_PrintableItem_Service
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
}
