<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MultiTicketBase StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MultiTicketBase extends Printing_PrintableItem_Base
{
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket
     */
    public $Tickets;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * Constructor method for Printing.PrintableItem.MultiTicketBase
     * @uses Printing_PrintableItem_MultiTicketBase::setOwnerId()
     * @uses Printing_PrintableItem_MultiTicketBase::setTickets()
     * @uses Printing_PrintableItem_MultiTicketBase::setTicketsCount()
     * @param string $ownerId
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $tickets
     * @param int $ticketsCount
     */
    public function __construct($ownerId = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $tickets = null, $ticketsCount = null)
    {
        $this
            ->setOwnerId($ownerId)
            ->setTickets($tickets)
            ->setTicketsCount($ticketsCount);
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Printing_PrintableItem_MultiTicketBase
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $tickets
     * @return \patest\StructType\Printing_PrintableItem_MultiTicketBase
     */
    public function setTickets(\patest\StructType\RecordSetOfPrinting_PrintableItem_Ticket $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\Printing_PrintableItem_MultiTicketBase
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
}
