<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.GroupTicket StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_GroupTicket extends Printing_PrintableItem_Base
{
    /**
     * The AccessControlParentDefinitionDataReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlParentDefinitionDataReferenceId;
    /**
     * The AccessControlProductExtensionReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlProductExtensionReferenceId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Event
     */
    public $Event;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Hall
     */
    public $Hall;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Show
     */
    public $Show;
    /**
     * The ShowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_ShowType
     */
    public $ShowType;
    /**
     * The SupplierAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount
     */
    public $SupplierAccount;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket
     */
    public $Tickets;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * The TicketsSummaryByPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem
     */
    public $TicketsSummaryByPriceType;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Venue
     */
    public $Venue;
    /**
     * Constructor method for Printing.PrintableItem.GroupTicket
     * @uses Printing_PrintableItem_GroupTicket::setAccessControlParentDefinitionDataReferenceId()
     * @uses Printing_PrintableItem_GroupTicket::setAccessControlProductExtensionReferenceId()
     * @uses Printing_PrintableItem_GroupTicket::setBarcode()
     * @uses Printing_PrintableItem_GroupTicket::setClientId()
     * @uses Printing_PrintableItem_GroupTicket::setEvent()
     * @uses Printing_PrintableItem_GroupTicket::setHall()
     * @uses Printing_PrintableItem_GroupTicket::setOrganizationUnitId()
     * @uses Printing_PrintableItem_GroupTicket::setShow()
     * @uses Printing_PrintableItem_GroupTicket::setShowType()
     * @uses Printing_PrintableItem_GroupTicket::setSupplierAccount()
     * @uses Printing_PrintableItem_GroupTicket::setTickets()
     * @uses Printing_PrintableItem_GroupTicket::setTicketsCount()
     * @uses Printing_PrintableItem_GroupTicket::setTicketsSummaryByPriceType()
     * @uses Printing_PrintableItem_GroupTicket::setVenue()
     * @param string $accessControlParentDefinitionDataReferenceId
     * @param string $accessControlProductExtensionReferenceId
     * @param string $barcode
     * @param string $clientId
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @param string $organizationUnitId
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket $tickets
     * @param int $ticketsCount
     * @param \patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem $ticketsSummaryByPriceType
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     */
    public function __construct($accessControlParentDefinitionDataReferenceId = null, $accessControlProductExtensionReferenceId = null, $barcode = null, $clientId = null, \patest\StructType\Ticketing_Printing_Event $event = null, \patest\StructType\Ticketing_Printing_Hall $hall = null, $organizationUnitId = null, \patest\StructType\Ticketing_Printing_Show $show = null, \patest\StructType\Ticketing_Printing_ShowType $showType = null, \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket $tickets = null, $ticketsCount = null, \patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem $ticketsSummaryByPriceType = null, \patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        $this
            ->setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId)
            ->setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId)
            ->setBarcode($barcode)
            ->setClientId($clientId)
            ->setEvent($event)
            ->setHall($hall)
            ->setOrganizationUnitId($organizationUnitId)
            ->setShow($show)
            ->setShowType($showType)
            ->setSupplierAccount($supplierAccount)
            ->setTickets($tickets)
            ->setTicketsCount($ticketsCount)
            ->setTicketsSummaryByPriceType($ticketsSummaryByPriceType)
            ->setVenue($venue);
    }
    /**
     * Get AccessControlParentDefinitionDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlParentDefinitionDataReferenceId()
    {
        return isset($this->AccessControlParentDefinitionDataReferenceId) ? $this->AccessControlParentDefinitionDataReferenceId : null;
    }
    /**
     * Set AccessControlParentDefinitionDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlParentDefinitionDataReferenceId
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !is_string($accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlParentDefinitionDataReferenceId, true), gettype($accessControlParentDefinitionDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlParentDefinitionDataReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlParentDefinitionDataReferenceId) || (is_array($accessControlParentDefinitionDataReferenceId) && empty($accessControlParentDefinitionDataReferenceId))) {
            unset($this->AccessControlParentDefinitionDataReferenceId);
        } else {
            $this->AccessControlParentDefinitionDataReferenceId = $accessControlParentDefinitionDataReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlProductExtensionReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProductExtensionReferenceId()
    {
        return isset($this->AccessControlProductExtensionReferenceId) ? $this->AccessControlProductExtensionReferenceId : null;
    }
    /**
     * Set AccessControlProductExtensionReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProductExtensionReferenceId
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProductExtensionReferenceId) && !is_string($accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProductExtensionReferenceId, true), gettype($accessControlProductExtensionReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlProductExtensionReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlProductExtensionReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlProductExtensionReferenceId) || (is_array($accessControlProductExtensionReferenceId) && empty($accessControlProductExtensionReferenceId))) {
            unset($this->AccessControlProductExtensionReferenceId);
        } else {
            $this->AccessControlProductExtensionReferenceId = $accessControlProductExtensionReferenceId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Event|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setEvent(\patest\StructType\Ticketing_Printing_Event $event = null)
    {
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Hall|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setHall(\patest\StructType\Ticketing_Printing_Hall $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Show|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setShow(\patest\StructType\Ticketing_Printing_Show $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get ShowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_ShowType|null
     */
    public function getShowType()
    {
        return isset($this->ShowType) ? $this->ShowType : null;
    }
    /**
     * Set ShowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setShowType(\patest\StructType\Ticketing_Printing_ShowType $showType = null)
    {
        if (is_null($showType) || (is_array($showType) && empty($showType))) {
            unset($this->ShowType);
        } else {
            $this->ShowType = $showType;
        }
        return $this;
    }
    /**
     * Get SupplierAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount|null
     */
    public function getSupplierAccount()
    {
        return isset($this->SupplierAccount) ? $this->SupplierAccount : null;
    }
    /**
     * Set SupplierAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setSupplierAccount(\patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $supplierAccount = null)
    {
        if (is_null($supplierAccount) || (is_array($supplierAccount) && empty($supplierAccount))) {
            unset($this->SupplierAccount);
        } else {
            $this->SupplierAccount = $supplierAccount;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket $tickets
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setTickets(\patest\StructType\RecordSetOfPrinting_PrintableItem_TicketInGroupTicket $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
    /**
     * Get TicketsSummaryByPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem|null
     */
    public function getTicketsSummaryByPriceType()
    {
        return isset($this->TicketsSummaryByPriceType) ? $this->TicketsSummaryByPriceType : null;
    }
    /**
     * Set TicketsSummaryByPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem $ticketsSummaryByPriceType
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setTicketsSummaryByPriceType(\patest\StructType\RecordSetOfPrinting_GroupTicket_TicketsSummaryByPriceType_SummaryItem $ticketsSummaryByPriceType = null)
    {
        if (is_null($ticketsSummaryByPriceType) || (is_array($ticketsSummaryByPriceType) && empty($ticketsSummaryByPriceType))) {
            unset($this->TicketsSummaryByPriceType);
        } else {
            $this->TicketsSummaryByPriceType = $ticketsSummaryByPriceType;
        }
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Venue|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     * @return \patest\StructType\Printing_PrintableItem_GroupTicket
     */
    public function setVenue(\patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
}
