<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.EventExtraVoucher StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_EventExtraVoucher extends Printing_PrintableItem_Base
{
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Event
     */
    public $Event;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Hall
     */
    public $Hall;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Show
     */
    public $Show;
    /**
     * The ShowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_ShowType
     */
    public $ShowType;
    /**
     * The SubscriptionInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public $SubscriptionInfo;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Venue
     */
    public $Venue;
    /**
     * Constructor method for Printing.PrintableItem.EventExtraVoucher
     * @uses Printing_PrintableItem_EventExtraVoucher::setEvent()
     * @uses Printing_PrintableItem_EventExtraVoucher::setHall()
     * @uses Printing_PrintableItem_EventExtraVoucher::setOrganizationUnitId()
     * @uses Printing_PrintableItem_EventExtraVoucher::setShow()
     * @uses Printing_PrintableItem_EventExtraVoucher::setShowType()
     * @uses Printing_PrintableItem_EventExtraVoucher::setSubscriptionInfo()
     * @uses Printing_PrintableItem_EventExtraVoucher::setVenue()
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @param string $organizationUnitId
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @param \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     */
    public function __construct(\patest\StructType\Ticketing_Printing_Event $event = null, \patest\StructType\Ticketing_Printing_Hall $hall = null, $organizationUnitId = null, \patest\StructType\Ticketing_Printing_Show $show = null, \patest\StructType\Ticketing_Printing_ShowType $showType = null, \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo = null, \patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        $this
            ->setEvent($event)
            ->setHall($hall)
            ->setOrganizationUnitId($organizationUnitId)
            ->setShow($show)
            ->setShowType($showType)
            ->setSubscriptionInfo($subscriptionInfo)
            ->setVenue($venue);
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Event|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setEvent(\patest\StructType\Ticketing_Printing_Event $event = null)
    {
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Hall|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setHall(\patest\StructType\Ticketing_Printing_Hall $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Show|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setShow(\patest\StructType\Ticketing_Printing_Show $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get ShowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_ShowType|null
     */
    public function getShowType()
    {
        return isset($this->ShowType) ? $this->ShowType : null;
    }
    /**
     * Set ShowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setShowType(\patest\StructType\Ticketing_Printing_ShowType $showType = null)
    {
        if (is_null($showType) || (is_array($showType) && empty($showType))) {
            unset($this->ShowType);
        } else {
            $this->ShowType = $showType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo|null
     */
    public function getSubscriptionInfo()
    {
        return isset($this->SubscriptionInfo) ? $this->SubscriptionInfo : null;
    }
    /**
     * Set SubscriptionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setSubscriptionInfo(\patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo = null)
    {
        if (is_null($subscriptionInfo) || (is_array($subscriptionInfo) && empty($subscriptionInfo))) {
            unset($this->SubscriptionInfo);
        } else {
            $this->SubscriptionInfo = $subscriptionInfo;
        }
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Venue|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     * @return \patest\StructType\Printing_PrintableItem_EventExtraVoucher
     */
    public function setVenue(\patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
}
