<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DonationTributeLetter StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DonationTributeLetter extends Printing_PrintableItem_DonationBase
{
    /**
     * The Donations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo
     */
    public $Donations;
    /**
     * The TotalDonatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDonatedAmount;
    /**
     * The TributeTargetEmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTargetEmailAddress;
    /**
     * The TributeTo_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTo_Name;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The TributeTypeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTypeText;
    /**
     * Constructor method for Printing.PrintableItem.DonationTributeLetter
     * @uses Printing_PrintableItem_DonationTributeLetter::setDonations()
     * @uses Printing_PrintableItem_DonationTributeLetter::setTotalDonatedAmount()
     * @uses Printing_PrintableItem_DonationTributeLetter::setTributeTargetEmailAddress()
     * @uses Printing_PrintableItem_DonationTributeLetter::setTributeTo_Name()
     * @uses Printing_PrintableItem_DonationTributeLetter::setTributeType()
     * @uses Printing_PrintableItem_DonationTributeLetter::setTributeTypeText()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations
     * @param float $totalDonatedAmount
     * @param string $tributeTargetEmailAddress
     * @param string $tributeTo_Name
     * @param string $tributeType
     * @param string $tributeTypeText
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations = null, $totalDonatedAmount = null, $tributeTargetEmailAddress = null, $tributeTo_Name = null, $tributeType = null, $tributeTypeText = null)
    {
        $this
            ->setDonations($donations)
            ->setTotalDonatedAmount($totalDonatedAmount)
            ->setTributeTargetEmailAddress($tributeTargetEmailAddress)
            ->setTributeTo_Name($tributeTo_Name)
            ->setTributeType($tributeType)
            ->setTributeTypeText($tributeTypeText);
    }
    /**
     * Get Donations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo|null
     */
    public function getDonations()
    {
        return isset($this->Donations) ? $this->Donations : null;
    }
    /**
     * Set Donations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setDonations(\patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations = null)
    {
        if (is_null($donations) || (is_array($donations) && empty($donations))) {
            unset($this->Donations);
        } else {
            $this->Donations = $donations;
        }
        return $this;
    }
    /**
     * Get TotalDonatedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDonatedAmount()
    {
        return isset($this->TotalDonatedAmount) ? $this->TotalDonatedAmount : null;
    }
    /**
     * Set TotalDonatedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDonatedAmount
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setTotalDonatedAmount($totalDonatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalDonatedAmount) && !(is_float($totalDonatedAmount) || is_numeric($totalDonatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDonatedAmount, true), gettype($totalDonatedAmount)), __LINE__);
        }
        if (is_null($totalDonatedAmount) || (is_array($totalDonatedAmount) && empty($totalDonatedAmount))) {
            unset($this->TotalDonatedAmount);
        } else {
            $this->TotalDonatedAmount = $totalDonatedAmount;
        }
        return $this;
    }
    /**
     * Get TributeTargetEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTargetEmailAddress()
    {
        return isset($this->TributeTargetEmailAddress) ? $this->TributeTargetEmailAddress : null;
    }
    /**
     * Set TributeTargetEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTargetEmailAddress
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setTributeTargetEmailAddress($tributeTargetEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTargetEmailAddress) && !is_string($tributeTargetEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTargetEmailAddress, true), gettype($tributeTargetEmailAddress)), __LINE__);
        }
        if (is_null($tributeTargetEmailAddress) || (is_array($tributeTargetEmailAddress) && empty($tributeTargetEmailAddress))) {
            unset($this->TributeTargetEmailAddress);
        } else {
            $this->TributeTargetEmailAddress = $tributeTargetEmailAddress;
        }
        return $this;
    }
    /**
     * Get TributeTo_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTo_Name()
    {
        return isset($this->TributeTo_Name) ? $this->TributeTo_Name : null;
    }
    /**
     * Set TributeTo_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTo_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setTributeTo_Name($tributeTo_Name = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTo_Name) && !is_string($tributeTo_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTo_Name, true), gettype($tributeTo_Name)), __LINE__);
        }
        if (is_null($tributeTo_Name) || (is_array($tributeTo_Name) && empty($tributeTo_Name))) {
            unset($this->TributeTo_Name);
        } else {
            $this->TributeTo_Name = $tributeTo_Name;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get TributeTypeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTypeText()
    {
        return isset($this->TributeTypeText) ? $this->TributeTypeText : null;
    }
    /**
     * Set TributeTypeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTypeText
     * @return \patest\StructType\Printing_PrintableItem_DonationTributeLetter
     */
    public function setTributeTypeText($tributeTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTypeText) && !is_string($tributeTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTypeText, true), gettype($tributeTypeText)), __LINE__);
        }
        if (is_null($tributeTypeText) || (is_array($tributeTypeText) && empty($tributeTypeText))) {
            unset($this->TributeTypeText);
        } else {
            $this->TributeTypeText = $tributeTypeText;
        }
        return $this;
    }
}
