<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableDocumentFilter StructType
 * @subpackage Structs
 */
class Printing_PrintableDocumentFilter extends FilterEntity
{
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeId;
    /**
     * Constructor method for Printing.PrintableDocumentFilter
     * @uses Printing_PrintableDocumentFilter::setDocumentTypeId()
     * @param string $documentTypeId
     */
    public function __construct($documentTypeId = null)
    {
        $this
            ->setDocumentTypeId($documentTypeId);
    }
    /**
     * Get DocumentTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return isset($this->DocumentTypeId) ? $this->DocumentTypeId : null;
    }
    /**
     * Set DocumentTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeId
     * @return \patest\StructType\Printing_PrintableDocumentFilter
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        if (is_null($documentTypeId) || (is_array($documentTypeId) && empty($documentTypeId))) {
            unset($this->DocumentTypeId);
        } else {
            $this->DocumentTypeId = $documentTypeId;
        }
        return $this;
    }
}
