<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.DataItem.BookingInformationTicket StructType
 * @subpackage Structs
 */
class Printing_DataItem_BookingInformationTicket extends AnyEntity
{
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The FacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FacePrice;
    /**
     * The HallGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallGuid;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The IsSubscriberTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriberTicket;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The RegularPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RegularPrice;
    /**
     * The ReservedUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservedUntil;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The SeatGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatGroupId;
    /**
     * The SeatOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatOrdinal;
    /**
     * The SeatTypeGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeGuid;
    /**
     * The SeatTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The ShowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowGuid;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TheaterCommissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions
     */
    public $TheaterCommissions;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * Constructor method for Printing.DataItem.BookingInformationTicket
     * @uses Printing_DataItem_BookingInformationTicket::setAreaGuid()
     * @uses Printing_DataItem_BookingInformationTicket::setAreaName()
     * @uses Printing_DataItem_BookingInformationTicket::setClientId()
     * @uses Printing_DataItem_BookingInformationTicket::setClientName()
     * @uses Printing_DataItem_BookingInformationTicket::setEventDate()
     * @uses Printing_DataItem_BookingInformationTicket::setEventGuid()
     * @uses Printing_DataItem_BookingInformationTicket::setFacePrice()
     * @uses Printing_DataItem_BookingInformationTicket::setHallGuid()
     * @uses Printing_DataItem_BookingInformationTicket::setHallName()
     * @uses Printing_DataItem_BookingInformationTicket::setIsActive()
     * @uses Printing_DataItem_BookingInformationTicket::setIsReserved()
     * @uses Printing_DataItem_BookingInformationTicket::setIsReturned()
     * @uses Printing_DataItem_BookingInformationTicket::setIsSubscriberTicket()
     * @uses Printing_DataItem_BookingInformationTicket::setListPrice()
     * @uses Printing_DataItem_BookingInformationTicket::setPrice()
     * @uses Printing_DataItem_BookingInformationTicket::setRegularPrice()
     * @uses Printing_DataItem_BookingInformationTicket::setReservedUntil()
     * @uses Printing_DataItem_BookingInformationTicket::setRow()
     * @uses Printing_DataItem_BookingInformationTicket::setSeat()
     * @uses Printing_DataItem_BookingInformationTicket::setSeatGroupId()
     * @uses Printing_DataItem_BookingInformationTicket::setSeatOrdinal()
     * @uses Printing_DataItem_BookingInformationTicket::setSeatTypeGuid()
     * @uses Printing_DataItem_BookingInformationTicket::setSeatTypeName()
     * @uses Printing_DataItem_BookingInformationTicket::setSectorName()
     * @uses Printing_DataItem_BookingInformationTicket::setSeriesName()
     * @uses Printing_DataItem_BookingInformationTicket::setShowGuid()
     * @uses Printing_DataItem_BookingInformationTicket::setShowName()
     * @uses Printing_DataItem_BookingInformationTicket::setSubscriptionInstanceId()
     * @uses Printing_DataItem_BookingInformationTicket::setTheaterCommissions()
     * @uses Printing_DataItem_BookingInformationTicket::setTotalPrice()
     * @param string $areaGuid
     * @param string $areaName
     * @param string $clientId
     * @param string $clientName
     * @param string $eventDate
     * @param string $eventGuid
     * @param \patest\StructType\Money $facePrice
     * @param string $hallGuid
     * @param string $hallName
     * @param bool $isActive
     * @param bool $isReserved
     * @param bool $isReturned
     * @param bool $isSubscriberTicket
     * @param \patest\StructType\Money $listPrice
     * @param \patest\StructType\Money $price
     * @param \patest\StructType\Money $regularPrice
     * @param string $reservedUntil
     * @param string $row
     * @param string $seat
     * @param int $seatGroupId
     * @param int $seatOrdinal
     * @param string $seatTypeGuid
     * @param string $seatTypeName
     * @param string $sectorName
     * @param string $seriesName
     * @param string $showGuid
     * @param string $showName
     * @param string $subscriptionInstanceId
     * @param \patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions $theaterCommissions
     * @param \patest\StructType\Money $totalPrice
     */
    public function __construct($areaGuid = null, $areaName = null, $clientId = null, $clientName = null, $eventDate = null, $eventGuid = null, \patest\StructType\Money $facePrice = null, $hallGuid = null, $hallName = null, $isActive = null, $isReserved = null, $isReturned = null, $isSubscriberTicket = null, \patest\StructType\Money $listPrice = null, \patest\StructType\Money $price = null, \patest\StructType\Money $regularPrice = null, $reservedUntil = null, $row = null, $seat = null, $seatGroupId = null, $seatOrdinal = null, $seatTypeGuid = null, $seatTypeName = null, $sectorName = null, $seriesName = null, $showGuid = null, $showName = null, $subscriptionInstanceId = null, \patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions $theaterCommissions = null, \patest\StructType\Money $totalPrice = null)
    {
        $this
            ->setAreaGuid($areaGuid)
            ->setAreaName($areaName)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setEventDate($eventDate)
            ->setEventGuid($eventGuid)
            ->setFacePrice($facePrice)
            ->setHallGuid($hallGuid)
            ->setHallName($hallName)
            ->setIsActive($isActive)
            ->setIsReserved($isReserved)
            ->setIsReturned($isReturned)
            ->setIsSubscriberTicket($isSubscriberTicket)
            ->setListPrice($listPrice)
            ->setPrice($price)
            ->setRegularPrice($regularPrice)
            ->setReservedUntil($reservedUntil)
            ->setRow($row)
            ->setSeat($seat)
            ->setSeatGroupId($seatGroupId)
            ->setSeatOrdinal($seatOrdinal)
            ->setSeatTypeGuid($seatTypeGuid)
            ->setSeatTypeName($seatTypeName)
            ->setSectorName($sectorName)
            ->setSeriesName($seriesName)
            ->setShowGuid($showGuid)
            ->setShowName($showName)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTheaterCommissions($theaterCommissions)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get AreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaGuid()
    {
        return isset($this->AreaGuid) ? $this->AreaGuid : null;
    }
    /**
     * Set AreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaGuid
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        if (is_null($areaGuid) || (is_array($areaGuid) && empty($areaGuid))) {
            unset($this->AreaGuid);
        } else {
            $this->AreaGuid = $areaGuid;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get FacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFacePrice()
    {
        return isset($this->FacePrice) ? $this->FacePrice : null;
    }
    /**
     * Set FacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $facePrice
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setFacePrice(\patest\StructType\Money $facePrice = null)
    {
        if (is_null($facePrice) || (is_array($facePrice) && empty($facePrice))) {
            unset($this->FacePrice);
        } else {
            $this->FacePrice = $facePrice;
        }
        return $this;
    }
    /**
     * Get HallGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallGuid()
    {
        return isset($this->HallGuid) ? $this->HallGuid : null;
    }
    /**
     * Set HallGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallGuid
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setHallGuid($hallGuid = null)
    {
        // validation for constraint: string
        if (!is_null($hallGuid) && !is_string($hallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallGuid, true), gettype($hallGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallGuid, true)), __LINE__);
        }
        if (is_null($hallGuid) || (is_array($hallGuid) && empty($hallGuid))) {
            unset($this->HallGuid);
        } else {
            $this->HallGuid = $hallGuid;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get IsSubscriberTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriberTicket()
    {
        return isset($this->IsSubscriberTicket) ? $this->IsSubscriberTicket : null;
    }
    /**
     * Set IsSubscriberTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriberTicket
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setIsSubscriberTicket($isSubscriberTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriberTicket) && !is_bool($isSubscriberTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriberTicket, true), gettype($isSubscriberTicket)), __LINE__);
        }
        if (is_null($isSubscriberTicket) || (is_array($isSubscriberTicket) && empty($isSubscriberTicket))) {
            unset($this->IsSubscriberTicket);
        } else {
            $this->IsSubscriberTicket = $isSubscriberTicket;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get RegularPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRegularPrice()
    {
        return isset($this->RegularPrice) ? $this->RegularPrice : null;
    }
    /**
     * Set RegularPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $regularPrice
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setRegularPrice(\patest\StructType\Money $regularPrice = null)
    {
        if (is_null($regularPrice) || (is_array($regularPrice) && empty($regularPrice))) {
            unset($this->RegularPrice);
        } else {
            $this->RegularPrice = $regularPrice;
        }
        return $this;
    }
    /**
     * Get ReservedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservedUntil()
    {
        return isset($this->ReservedUntil) ? $this->ReservedUntil : null;
    }
    /**
     * Set ReservedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservedUntil
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setReservedUntil($reservedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($reservedUntil) && !is_string($reservedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservedUntil, true), gettype($reservedUntil)), __LINE__);
        }
        if (is_null($reservedUntil) || (is_array($reservedUntil) && empty($reservedUntil))) {
            unset($this->ReservedUntil);
        } else {
            $this->ReservedUntil = $reservedUntil;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SeatGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatGroupId()
    {
        return isset($this->SeatGroupId) ? $this->SeatGroupId : null;
    }
    /**
     * Set SeatGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatGroupId
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeatGroupId($seatGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGroupId) && !(is_int($seatGroupId) || ctype_digit($seatGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGroupId, true), gettype($seatGroupId)), __LINE__);
        }
        if (is_null($seatGroupId) || (is_array($seatGroupId) && empty($seatGroupId))) {
            unset($this->SeatGroupId);
        } else {
            $this->SeatGroupId = $seatGroupId;
        }
        return $this;
    }
    /**
     * Get SeatOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatOrdinal()
    {
        return isset($this->SeatOrdinal) ? $this->SeatOrdinal : null;
    }
    /**
     * Set SeatOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatOrdinal
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeatOrdinal($seatOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($seatOrdinal) && !(is_int($seatOrdinal) || ctype_digit($seatOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatOrdinal, true), gettype($seatOrdinal)), __LINE__);
        }
        if (is_null($seatOrdinal) || (is_array($seatOrdinal) && empty($seatOrdinal))) {
            unset($this->SeatOrdinal);
        } else {
            $this->SeatOrdinal = $seatOrdinal;
        }
        return $this;
    }
    /**
     * Get SeatTypeGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeGuid()
    {
        return isset($this->SeatTypeGuid) ? $this->SeatTypeGuid : null;
    }
    /**
     * Set SeatTypeGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeGuid
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeatTypeGuid($seatTypeGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeGuid) && !is_string($seatTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeGuid, true), gettype($seatTypeGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeGuid, true)), __LINE__);
        }
        if (is_null($seatTypeGuid) || (is_array($seatTypeGuid) && empty($seatTypeGuid))) {
            unset($this->SeatTypeGuid);
        } else {
            $this->SeatTypeGuid = $seatTypeGuid;
        }
        return $this;
    }
    /**
     * Get SeatTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeName()
    {
        return isset($this->SeatTypeName) ? $this->SeatTypeName : null;
    }
    /**
     * Set SeatTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeatTypeName($seatTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeName) && !is_string($seatTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeName, true), gettype($seatTypeName)), __LINE__);
        }
        if (is_null($seatTypeName) || (is_array($seatTypeName) && empty($seatTypeName))) {
            unset($this->SeatTypeName);
        } else {
            $this->SeatTypeName = $seatTypeName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get ShowGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowGuid()
    {
        return isset($this->ShowGuid) ? $this->ShowGuid : null;
    }
    /**
     * Set ShowGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showGuid
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setShowGuid($showGuid = null)
    {
        // validation for constraint: string
        if (!is_null($showGuid) && !is_string($showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showGuid, true), gettype($showGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showGuid, true)), __LINE__);
        }
        if (is_null($showGuid) || (is_array($showGuid) && empty($showGuid))) {
            unset($this->ShowGuid);
        } else {
            $this->ShowGuid = $showGuid;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TheaterCommissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions|null
     */
    public function getTheaterCommissions()
    {
        return isset($this->TheaterCommissions) ? $this->TheaterCommissions : null;
    }
    /**
     * Set TheaterCommissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions $theaterCommissions
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setTheaterCommissions(\patest\StructType\Printing_AuxDataItem_CommercialTheaterCommissions $theaterCommissions = null)
    {
        if (is_null($theaterCommissions) || (is_array($theaterCommissions) && empty($theaterCommissions))) {
            unset($this->TheaterCommissions);
        } else {
            $this->TheaterCommissions = $theaterCommissions;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Printing_DataItem_BookingInformationTicket
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
}
