<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.BatchPrintGeneratedDocument StructType
 * @subpackage Structs
 */
class Printing_BatchPrintGeneratedDocument extends PersistableEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The GeneratedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocument;
    /**
     * The GeneratedDocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocumentName;
    /**
     * The GeneratedDocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocumentType;
    /**
     * The IsGeneratedDocumentCompressed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGeneratedDocumentCompressed;
    /**
     * Constructor method for Printing.BatchPrintGeneratedDocument
     * @uses Printing_BatchPrintGeneratedDocument::setBatchId()
     * @uses Printing_BatchPrintGeneratedDocument::setGeneratedDocument()
     * @uses Printing_BatchPrintGeneratedDocument::setGeneratedDocumentName()
     * @uses Printing_BatchPrintGeneratedDocument::setGeneratedDocumentType()
     * @uses Printing_BatchPrintGeneratedDocument::setIsGeneratedDocumentCompressed()
     * @param string $batchId
     * @param string $generatedDocument
     * @param string $generatedDocumentName
     * @param string $generatedDocumentType
     * @param bool $isGeneratedDocumentCompressed
     */
    public function __construct($batchId = null, $generatedDocument = null, $generatedDocumentName = null, $generatedDocumentType = null, $isGeneratedDocumentCompressed = null)
    {
        $this
            ->setBatchId($batchId)
            ->setGeneratedDocument($generatedDocument)
            ->setGeneratedDocumentName($generatedDocumentName)
            ->setGeneratedDocumentType($generatedDocumentType)
            ->setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Printing_BatchPrintGeneratedDocument
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get GeneratedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocument()
    {
        return isset($this->GeneratedDocument) ? $this->GeneratedDocument : null;
    }
    /**
     * Set GeneratedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocument
     * @return \patest\StructType\Printing_BatchPrintGeneratedDocument
     */
    public function setGeneratedDocument($generatedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocument) && !is_string($generatedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocument, true), gettype($generatedDocument)), __LINE__);
        }
        if (is_null($generatedDocument) || (is_array($generatedDocument) && empty($generatedDocument))) {
            unset($this->GeneratedDocument);
        } else {
            $this->GeneratedDocument = $generatedDocument;
        }
        return $this;
    }
    /**
     * Get GeneratedDocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocumentName()
    {
        return isset($this->GeneratedDocumentName) ? $this->GeneratedDocumentName : null;
    }
    /**
     * Set GeneratedDocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocumentName
     * @return \patest\StructType\Printing_BatchPrintGeneratedDocument
     */
    public function setGeneratedDocumentName($generatedDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocumentName) && !is_string($generatedDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocumentName, true), gettype($generatedDocumentName)), __LINE__);
        }
        if (is_null($generatedDocumentName) || (is_array($generatedDocumentName) && empty($generatedDocumentName))) {
            unset($this->GeneratedDocumentName);
        } else {
            $this->GeneratedDocumentName = $generatedDocumentName;
        }
        return $this;
    }
    /**
     * Get GeneratedDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocumentType()
    {
        return isset($this->GeneratedDocumentType) ? $this->GeneratedDocumentType : null;
    }
    /**
     * Set GeneratedDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocumentType
     * @return \patest\StructType\Printing_BatchPrintGeneratedDocument
     */
    public function setGeneratedDocumentType($generatedDocumentType = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocumentType) && !is_string($generatedDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocumentType, true), gettype($generatedDocumentType)), __LINE__);
        }
        if (is_null($generatedDocumentType) || (is_array($generatedDocumentType) && empty($generatedDocumentType))) {
            unset($this->GeneratedDocumentType);
        } else {
            $this->GeneratedDocumentType = $generatedDocumentType;
        }
        return $this;
    }
    /**
     * Get IsGeneratedDocumentCompressed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGeneratedDocumentCompressed()
    {
        return isset($this->IsGeneratedDocumentCompressed) ? $this->IsGeneratedDocumentCompressed : null;
    }
    /**
     * Set IsGeneratedDocumentCompressed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGeneratedDocumentCompressed
     * @return \patest\StructType\Printing_BatchPrintGeneratedDocument
     */
    public function setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGeneratedDocumentCompressed) && !is_bool($isGeneratedDocumentCompressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGeneratedDocumentCompressed, true), gettype($isGeneratedDocumentCompressed)), __LINE__);
        }
        if (is_null($isGeneratedDocumentCompressed) || (is_array($isGeneratedDocumentCompressed) && empty($isGeneratedDocumentCompressed))) {
            unset($this->IsGeneratedDocumentCompressed);
        } else {
            $this->IsGeneratedDocumentCompressed = $isGeneratedDocumentCompressed;
        }
        return $this;
    }
}
