<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.BatchPrintFilter StructType
 * @subpackage Structs
 */
class Printing_BatchPrintFilter extends FilterEntity
{
    /**
     * The BatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchType;
    /**
     * The FromBatchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromBatchCode;
    /**
     * The FromCreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromCreationDateTime;
    /**
     * The FromTotalGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromTotalGroups;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ToBatchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToBatchCode;
    /**
     * The ToCreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToCreationDateTime;
    /**
     * The ToTotalGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToTotalGroups;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Printing.BatchPrintFilter
     * @uses Printing_BatchPrintFilter::setBatchType()
     * @uses Printing_BatchPrintFilter::setFromBatchCode()
     * @uses Printing_BatchPrintFilter::setFromCreationDateTime()
     * @uses Printing_BatchPrintFilter::setFromTotalGroups()
     * @uses Printing_BatchPrintFilter::setStatus()
     * @uses Printing_BatchPrintFilter::setToBatchCode()
     * @uses Printing_BatchPrintFilter::setToCreationDateTime()
     * @uses Printing_BatchPrintFilter::setToTotalGroups()
     * @uses Printing_BatchPrintFilter::setUserId()
     * @param string $batchType
     * @param int $fromBatchCode
     * @param string $fromCreationDateTime
     * @param int $fromTotalGroups
     * @param string $status
     * @param int $toBatchCode
     * @param string $toCreationDateTime
     * @param int $toTotalGroups
     * @param string $userId
     */
    public function __construct($batchType = null, $fromBatchCode = null, $fromCreationDateTime = null, $fromTotalGroups = null, $status = null, $toBatchCode = null, $toCreationDateTime = null, $toTotalGroups = null, $userId = null)
    {
        $this
            ->setBatchType($batchType)
            ->setFromBatchCode($fromBatchCode)
            ->setFromCreationDateTime($fromCreationDateTime)
            ->setFromTotalGroups($fromTotalGroups)
            ->setStatus($status)
            ->setToBatchCode($toBatchCode)
            ->setToCreationDateTime($toCreationDateTime)
            ->setToTotalGroups($toTotalGroups)
            ->setUserId($userId);
    }
    /**
     * Get BatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchType()
    {
        return isset($this->BatchType) ? $this->BatchType : null;
    }
    /**
     * Set BatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintType::valueIsValid()
     * @uses \patest\EnumType\BatchPrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $batchType
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setBatchType($batchType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintType::valueIsValid($batchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintType', is_array($batchType) ? implode(', ', $batchType) : var_export($batchType, true), implode(', ', \patest\EnumType\BatchPrintType::getValidValues())), __LINE__);
        }
        if (is_null($batchType) || (is_array($batchType) && empty($batchType))) {
            unset($this->BatchType);
        } else {
            $this->BatchType = $batchType;
        }
        return $this;
    }
    /**
     * Get FromBatchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromBatchCode()
    {
        return isset($this->FromBatchCode) ? $this->FromBatchCode : null;
    }
    /**
     * Set FromBatchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromBatchCode
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setFromBatchCode($fromBatchCode = null)
    {
        // validation for constraint: int
        if (!is_null($fromBatchCode) && !(is_int($fromBatchCode) || ctype_digit($fromBatchCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromBatchCode, true), gettype($fromBatchCode)), __LINE__);
        }
        if (is_null($fromBatchCode) || (is_array($fromBatchCode) && empty($fromBatchCode))) {
            unset($this->FromBatchCode);
        } else {
            $this->FromBatchCode = $fromBatchCode;
        }
        return $this;
    }
    /**
     * Get FromCreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromCreationDateTime()
    {
        return isset($this->FromCreationDateTime) ? $this->FromCreationDateTime : null;
    }
    /**
     * Set FromCreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromCreationDateTime
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setFromCreationDateTime($fromCreationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromCreationDateTime) && !is_string($fromCreationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromCreationDateTime, true), gettype($fromCreationDateTime)), __LINE__);
        }
        if (is_null($fromCreationDateTime) || (is_array($fromCreationDateTime) && empty($fromCreationDateTime))) {
            unset($this->FromCreationDateTime);
        } else {
            $this->FromCreationDateTime = $fromCreationDateTime;
        }
        return $this;
    }
    /**
     * Get FromTotalGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromTotalGroups()
    {
        return isset($this->FromTotalGroups) ? $this->FromTotalGroups : null;
    }
    /**
     * Set FromTotalGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromTotalGroups
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setFromTotalGroups($fromTotalGroups = null)
    {
        // validation for constraint: int
        if (!is_null($fromTotalGroups) && !(is_int($fromTotalGroups) || ctype_digit($fromTotalGroups))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTotalGroups, true), gettype($fromTotalGroups)), __LINE__);
        }
        if (is_null($fromTotalGroups) || (is_array($fromTotalGroups) && empty($fromTotalGroups))) {
            unset($this->FromTotalGroups);
        } else {
            $this->FromTotalGroups = $fromTotalGroups;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintStatus::valueIsValid()
     * @uses \patest\EnumType\BatchPrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BatchPrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ToBatchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToBatchCode()
    {
        return isset($this->ToBatchCode) ? $this->ToBatchCode : null;
    }
    /**
     * Set ToBatchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toBatchCode
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setToBatchCode($toBatchCode = null)
    {
        // validation for constraint: int
        if (!is_null($toBatchCode) && !(is_int($toBatchCode) || ctype_digit($toBatchCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toBatchCode, true), gettype($toBatchCode)), __LINE__);
        }
        if (is_null($toBatchCode) || (is_array($toBatchCode) && empty($toBatchCode))) {
            unset($this->ToBatchCode);
        } else {
            $this->ToBatchCode = $toBatchCode;
        }
        return $this;
    }
    /**
     * Get ToCreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToCreationDateTime()
    {
        return isset($this->ToCreationDateTime) ? $this->ToCreationDateTime : null;
    }
    /**
     * Set ToCreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toCreationDateTime
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setToCreationDateTime($toCreationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toCreationDateTime) && !is_string($toCreationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toCreationDateTime, true), gettype($toCreationDateTime)), __LINE__);
        }
        if (is_null($toCreationDateTime) || (is_array($toCreationDateTime) && empty($toCreationDateTime))) {
            unset($this->ToCreationDateTime);
        } else {
            $this->ToCreationDateTime = $toCreationDateTime;
        }
        return $this;
    }
    /**
     * Get ToTotalGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToTotalGroups()
    {
        return isset($this->ToTotalGroups) ? $this->ToTotalGroups : null;
    }
    /**
     * Set ToTotalGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toTotalGroups
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setToTotalGroups($toTotalGroups = null)
    {
        // validation for constraint: int
        if (!is_null($toTotalGroups) && !(is_int($toTotalGroups) || ctype_digit($toTotalGroups))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTotalGroups, true), gettype($toTotalGroups)), __LINE__);
        }
        if (is_null($toTotalGroups) || (is_array($toTotalGroups) && empty($toTotalGroups))) {
            unset($this->ToTotalGroups);
        } else {
            $this->ToTotalGroups = $toTotalGroups;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_BatchPrintFilter
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
