<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.VatDetail StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_VatDetail extends AnyEntity
{
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The ItemServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemServiceSpecificId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The PriceEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceEffectiveness;
    /**
     * The PriceModifierName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceModifierName;
    /**
     * The PriceModifierType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceModifierType;
    /**
     * The SourceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SourceAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The UnitDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitDescription;
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitName;
    /**
     * The UnitTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitTypeName;
    /**
     * The VatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $VatAmount;
    /**
     * The VatDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VatDefinitionId;
    /**
     * The VatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VatName;
    /**
     * The VatValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VatValue;
    /**
     * The VatValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatValueType;
    /**
     * Constructor method for Printing.AuxDataItem.VatDetail
     * @uses Printing_AuxDataItem_VatDetail::setInsertionMode()
     * @uses Printing_AuxDataItem_VatDetail::setItemServiceSpecificId()
     * @uses Printing_AuxDataItem_VatDetail::setItemType()
     * @uses Printing_AuxDataItem_VatDetail::setPriceEffectiveness()
     * @uses Printing_AuxDataItem_VatDetail::setPriceModifierName()
     * @uses Printing_AuxDataItem_VatDetail::setPriceModifierType()
     * @uses Printing_AuxDataItem_VatDetail::setSourceAmount()
     * @uses Printing_AuxDataItem_VatDetail::setTotalAmount()
     * @uses Printing_AuxDataItem_VatDetail::setUnitDescription()
     * @uses Printing_AuxDataItem_VatDetail::setUnitName()
     * @uses Printing_AuxDataItem_VatDetail::setUnitTypeName()
     * @uses Printing_AuxDataItem_VatDetail::setVatAmount()
     * @uses Printing_AuxDataItem_VatDetail::setVatDefinitionId()
     * @uses Printing_AuxDataItem_VatDetail::setVatName()
     * @uses Printing_AuxDataItem_VatDetail::setVatValue()
     * @uses Printing_AuxDataItem_VatDetail::setVatValueType()
     * @param string $insertionMode
     * @param string $itemServiceSpecificId
     * @param int $itemType
     * @param string $priceEffectiveness
     * @param \patest\StructType\GlobalString $priceModifierName
     * @param string $priceModifierType
     * @param \patest\StructType\Money $sourceAmount
     * @param \patest\StructType\Money $totalAmount
     * @param string $unitDescription
     * @param string $unitName
     * @param string $unitTypeName
     * @param \patest\StructType\Money $vatAmount
     * @param string $vatDefinitionId
     * @param \patest\StructType\GlobalString $vatName
     * @param float $vatValue
     * @param string $vatValueType
     */
    public function __construct($insertionMode = null, $itemServiceSpecificId = null, $itemType = null, $priceEffectiveness = null, \patest\StructType\GlobalString $priceModifierName = null, $priceModifierType = null, \patest\StructType\Money $sourceAmount = null, \patest\StructType\Money $totalAmount = null, $unitDescription = null, $unitName = null, $unitTypeName = null, \patest\StructType\Money $vatAmount = null, $vatDefinitionId = null, \patest\StructType\GlobalString $vatName = null, $vatValue = null, $vatValueType = null)
    {
        $this
            ->setInsertionMode($insertionMode)
            ->setItemServiceSpecificId($itemServiceSpecificId)
            ->setItemType($itemType)
            ->setPriceEffectiveness($priceEffectiveness)
            ->setPriceModifierName($priceModifierName)
            ->setPriceModifierType($priceModifierType)
            ->setSourceAmount($sourceAmount)
            ->setTotalAmount($totalAmount)
            ->setUnitDescription($unitDescription)
            ->setUnitName($unitName)
            ->setUnitTypeName($unitTypeName)
            ->setVatAmount($vatAmount)
            ->setVatDefinitionId($vatDefinitionId)
            ->setVatName($vatName)
            ->setVatValue($vatValue)
            ->setVatValueType($vatValueType);
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get ItemServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemServiceSpecificId()
    {
        return isset($this->ItemServiceSpecificId) ? $this->ItemServiceSpecificId : null;
    }
    /**
     * Set ItemServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemServiceSpecificId
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setItemServiceSpecificId($itemServiceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($itemServiceSpecificId) && !is_string($itemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemServiceSpecificId, true), gettype($itemServiceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemServiceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemServiceSpecificId, true)), __LINE__);
        }
        if (is_null($itemServiceSpecificId) || (is_array($itemServiceSpecificId) && empty($itemServiceSpecificId))) {
            unset($this->ItemServiceSpecificId);
        } else {
            $this->ItemServiceSpecificId = $itemServiceSpecificId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get PriceEffectiveness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceEffectiveness()
    {
        return isset($this->PriceEffectiveness) ? $this->PriceEffectiveness : null;
    }
    /**
     * Set PriceEffectiveness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::valueIsValid()
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceEffectiveness
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setPriceEffectiveness($priceEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemPriceEffectiveness::valueIsValid($priceEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemPriceEffectiveness', is_array($priceEffectiveness) ? implode(', ', $priceEffectiveness) : var_export($priceEffectiveness, true), implode(', ', \patest\EnumType\ProductItemPriceEffectiveness::getValidValues())), __LINE__);
        }
        if (is_null($priceEffectiveness) || (is_array($priceEffectiveness) && empty($priceEffectiveness))) {
            unset($this->PriceEffectiveness);
        } else {
            $this->PriceEffectiveness = $priceEffectiveness;
        }
        return $this;
    }
    /**
     * Get PriceModifierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceModifierName()
    {
        return isset($this->PriceModifierName) ? $this->PriceModifierName : null;
    }
    /**
     * Set PriceModifierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceModifierName
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setPriceModifierName(\patest\StructType\GlobalString $priceModifierName = null)
    {
        if (is_null($priceModifierName) || (is_array($priceModifierName) && empty($priceModifierName))) {
            unset($this->PriceModifierName);
        } else {
            $this->PriceModifierName = $priceModifierName;
        }
        return $this;
    }
    /**
     * Get PriceModifierType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierType()
    {
        return isset($this->PriceModifierType) ? $this->PriceModifierType : null;
    }
    /**
     * Set PriceModifierType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierType
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setPriceModifierType($priceModifierType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierType) ? implode(', ', $priceModifierType) : var_export($priceModifierType, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($priceModifierType) || (is_array($priceModifierType) && empty($priceModifierType))) {
            unset($this->PriceModifierType);
        } else {
            $this->PriceModifierType = $priceModifierType;
        }
        return $this;
    }
    /**
     * Get SourceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSourceAmount()
    {
        return isset($this->SourceAmount) ? $this->SourceAmount : null;
    }
    /**
     * Set SourceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $sourceAmount
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setSourceAmount(\patest\StructType\Money $sourceAmount = null)
    {
        if (is_null($sourceAmount) || (is_array($sourceAmount) && empty($sourceAmount))) {
            unset($this->SourceAmount);
        } else {
            $this->SourceAmount = $sourceAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get UnitDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitDescription()
    {
        return isset($this->UnitDescription) ? $this->UnitDescription : null;
    }
    /**
     * Set UnitDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitDescription
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setUnitDescription($unitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescription) && !is_string($unitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDescription, true), gettype($unitDescription)), __LINE__);
        }
        if (is_null($unitDescription) || (is_array($unitDescription) && empty($unitDescription))) {
            unset($this->UnitDescription);
        } else {
            $this->UnitDescription = $unitDescription;
        }
        return $this;
    }
    /**
     * Get UnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitName()
    {
        return isset($this->UnitName) ? $this->UnitName : null;
    }
    /**
     * Set UnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitName
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        if (is_null($unitName) || (is_array($unitName) && empty($unitName))) {
            unset($this->UnitName);
        } else {
            $this->UnitName = $unitName;
        }
        return $this;
    }
    /**
     * Get UnitTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitTypeName()
    {
        return isset($this->UnitTypeName) ? $this->UnitTypeName : null;
    }
    /**
     * Set UnitTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitTypeName
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setUnitTypeName($unitTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($unitTypeName) && !is_string($unitTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitTypeName, true), gettype($unitTypeName)), __LINE__);
        }
        if (is_null($unitTypeName) || (is_array($unitTypeName) && empty($unitTypeName))) {
            unset($this->UnitTypeName);
        } else {
            $this->UnitTypeName = $unitTypeName;
        }
        return $this;
    }
    /**
     * Get VatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getVatAmount()
    {
        return isset($this->VatAmount) ? $this->VatAmount : null;
    }
    /**
     * Set VatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $vatAmount
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setVatAmount(\patest\StructType\Money $vatAmount = null)
    {
        if (is_null($vatAmount) || (is_array($vatAmount) && empty($vatAmount))) {
            unset($this->VatAmount);
        } else {
            $this->VatAmount = $vatAmount;
        }
        return $this;
    }
    /**
     * Get VatDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatDefinitionId()
    {
        return isset($this->VatDefinitionId) ? $this->VatDefinitionId : null;
    }
    /**
     * Set VatDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatDefinitionId
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setVatDefinitionId($vatDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($vatDefinitionId) && !is_string($vatDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatDefinitionId, true), gettype($vatDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($vatDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vatDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($vatDefinitionId, true)), __LINE__);
        }
        if (is_null($vatDefinitionId) || (is_array($vatDefinitionId) && empty($vatDefinitionId))) {
            unset($this->VatDefinitionId);
        } else {
            $this->VatDefinitionId = $vatDefinitionId;
        }
        return $this;
    }
    /**
     * Get VatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVatName()
    {
        return isset($this->VatName) ? $this->VatName : null;
    }
    /**
     * Set VatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $vatName
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setVatName(\patest\StructType\GlobalString $vatName = null)
    {
        if (is_null($vatName) || (is_array($vatName) && empty($vatName))) {
            unset($this->VatName);
        } else {
            $this->VatName = $vatName;
        }
        return $this;
    }
    /**
     * Get VatValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVatValue()
    {
        return isset($this->VatValue) ? $this->VatValue : null;
    }
    /**
     * Set VatValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vatValue
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setVatValue($vatValue = null)
    {
        // validation for constraint: float
        if (!is_null($vatValue) && !(is_float($vatValue) || is_numeric($vatValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatValue, true), gettype($vatValue)), __LINE__);
        }
        if (is_null($vatValue) || (is_array($vatValue) && empty($vatValue))) {
            unset($this->VatValue);
        } else {
            $this->VatValue = $vatValue;
        }
        return $this;
    }
    /**
     * Get VatValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatValueType()
    {
        return isset($this->VatValueType) ? $this->VatValueType : null;
    }
    /**
     * Set VatValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vatValueType
     * @return \patest\StructType\Printing_AuxDataItem_VatDetail
     */
    public function setVatValueType($vatValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($vatValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($vatValueType) ? implode(', ', $vatValueType) : var_export($vatValueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        if (is_null($vatValueType) || (is_array($vatValueType) && empty($vatValueType))) {
            unset($this->VatValueType);
        } else {
            $this->VatValueType = $vatValueType;
        }
        return $this;
    }
}
