<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.ClientAddressDetails StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_ClientAddressDetails extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress
     */
    public $Address;
    /**
     * The AddressType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AddressType;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The ValidFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDate;
    /**
     * The ValidToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDate;
    /**
     * Constructor method for Printing.AuxDataItem.ClientAddressDetails
     * @uses Printing_AuxDataItem_ClientAddressDetails::setAddress()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setAddressType()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setIsPrimary()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setNote()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setPhone()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setTypeId()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setValidFromDate()
     * @uses Printing_AuxDataItem_ClientAddressDetails::setValidToDate()
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $address
     * @param \patest\StructType\GlobalString $addressType
     * @param bool $isPrimary
     * @param \patest\StructType\GlobalString $note
     * @param string $phone
     * @param string $typeId
     * @param string $validFromDate
     * @param string $validToDate
     */
    public function __construct(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $address = null, \patest\StructType\GlobalString $addressType = null, $isPrimary = null, \patest\StructType\GlobalString $note = null, $phone = null, $typeId = null, $validFromDate = null, $validToDate = null)
    {
        $this
            ->setAddress($address)
            ->setAddressType($addressType)
            ->setIsPrimary($isPrimary)
            ->setNote($note)
            ->setPhone($phone)
            ->setTypeId($typeId)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $address
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setAddress(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAddressType()
    {
        return isset($this->AddressType) ? $this->AddressType : null;
    }
    /**
     * Set AddressType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $addressType
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setAddressType(\patest\StructType\GlobalString $addressType = null)
    {
        if (is_null($addressType) || (is_array($addressType) && empty($addressType))) {
            unset($this->AddressType);
        } else {
            $this->AddressType = $addressType;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return isset($this->IsPrimary) ? $this->IsPrimary : null;
    }
    /**
     * Set IsPrimary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrimary
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        if (is_null($isPrimary) || (is_array($isPrimary) && empty($isPrimary))) {
            unset($this->IsPrimary);
        } else {
            $this->IsPrimary = $isPrimary;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get ValidFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDate()
    {
        return isset($this->ValidFromDate) ? $this->ValidFromDate : null;
    }
    /**
     * Set ValidFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDate
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        if (is_null($validFromDate) || (is_array($validFromDate) && empty($validFromDate))) {
            unset($this->ValidFromDate);
        } else {
            $this->ValidFromDate = $validFromDate;
        }
        return $this;
    }
    /**
     * Get ValidToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDate()
    {
        return isset($this->ValidToDate) ? $this->ValidToDate : null;
    }
    /**
     * Set ValidToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDate
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetails
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        if (is_null($validToDate) || (is_array($validToDate) && empty($validToDate))) {
            unset($this->ValidToDate);
        } else {
            $this->ValidToDate = $validToDate;
        }
        return $this;
    }
}
