<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingTreePriceModifier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PricingTreePriceModifier
 * @subpackage Structs
 */
class PricingTreePriceModifier extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The CalculationBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CalculationBase;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPricingTreePriceModifier
     */
    public $Children;
    /**
     * The DefinedValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DefinedValue;
    /**
     * The DefinedValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DefinedValueType;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FullAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FullAmount;
    /**
     * The IsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncluded;
    /**
     * The ParentAmountContribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ParentAmountContribution;
    /**
     * The PriceModifierType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PriceModifierType;
    /**
     * The CalculationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CalculationLevel;
    /**
     * Constructor method for PricingTreePriceModifier
     * @uses PricingTreePriceModifier::setAmount()
     * @uses PricingTreePriceModifier::setCalculationBase()
     * @uses PricingTreePriceModifier::setChildren()
     * @uses PricingTreePriceModifier::setDefinedValue()
     * @uses PricingTreePriceModifier::setDefinedValueType()
     * @uses PricingTreePriceModifier::setDefinitionId()
     * @uses PricingTreePriceModifier::setDescription()
     * @uses PricingTreePriceModifier::setFullAmount()
     * @uses PricingTreePriceModifier::setIsIncluded()
     * @uses PricingTreePriceModifier::setParentAmountContribution()
     * @uses PricingTreePriceModifier::setPriceModifierType()
     * @uses PricingTreePriceModifier::setCalculationLevel()
     * @param float $amount
     * @param string $calculationBase
     * @param \patest\ArrayType\ArrayOfPricingTreePriceModifier $children
     * @param float $definedValue
     * @param string $definedValueType
     * @param string $definitionId
     * @param string $description
     * @param float $fullAmount
     * @param bool $isIncluded
     * @param float $parentAmountContribution
     * @param string $priceModifierType
     * @param string $calculationLevel
     */
    public function __construct($amount = null, $calculationBase = null, \patest\ArrayType\ArrayOfPricingTreePriceModifier $children = null, $definedValue = null, $definedValueType = null, $definitionId = null, $description = null, $fullAmount = null, $isIncluded = null, $parentAmountContribution = null, $priceModifierType = null, $calculationLevel = null)
    {
        $this
            ->setAmount($amount)
            ->setCalculationBase($calculationBase)
            ->setChildren($children)
            ->setDefinedValue($definedValue)
            ->setDefinedValueType($definedValueType)
            ->setDefinitionId($definitionId)
            ->setDescription($description)
            ->setFullAmount($fullAmount)
            ->setIsIncluded($isIncluded)
            ->setParentAmountContribution($parentAmountContribution)
            ->setPriceModifierType($priceModifierType)
            ->setCalculationLevel($calculationLevel);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CalculationBase value
     * @return string|null
     */
    public function getCalculationBase()
    {
        return $this->CalculationBase;
    }
    /**
     * Set CalculationBase value
     * @uses \patest\EnumType\PriceModifierCalculationBase::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationBase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationBase
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setCalculationBase($calculationBase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationBase::valueIsValid($calculationBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationBase', is_array($calculationBase) ? implode(', ', $calculationBase) : var_export($calculationBase, true), implode(', ', \patest\EnumType\PriceModifierCalculationBase::getValidValues())), __LINE__);
        }
        $this->CalculationBase = $calculationBase;
        return $this;
    }
    /**
     * Get Children value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPricingTreePriceModifier|null
     */
    public function getChildren()
    {
        return isset($this->Children) ? $this->Children : null;
    }
    /**
     * Set Children value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPricingTreePriceModifier $children
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setChildren(\patest\ArrayType\ArrayOfPricingTreePriceModifier $children = null)
    {
        if (is_null($children) || (is_array($children) && empty($children))) {
            unset($this->Children);
        } else {
            $this->Children = $children;
        }
        return $this;
    }
    /**
     * Get DefinedValue value
     * @return float|null
     */
    public function getDefinedValue()
    {
        return $this->DefinedValue;
    }
    /**
     * Set DefinedValue value
     * @param float $definedValue
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setDefinedValue($definedValue = null)
    {
        // validation for constraint: float
        if (!is_null($definedValue) && !(is_float($definedValue) || is_numeric($definedValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($definedValue, true), gettype($definedValue)), __LINE__);
        }
        $this->DefinedValue = $definedValue;
        return $this;
    }
    /**
     * Get DefinedValueType value
     * @return string|null
     */
    public function getDefinedValueType()
    {
        return $this->DefinedValueType;
    }
    /**
     * Set DefinedValueType value
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $definedValueType
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setDefinedValueType($definedValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($definedValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($definedValueType) ? implode(', ', $definedValueType) : var_export($definedValueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        $this->DefinedValueType = $definedValueType;
        return $this;
    }
    /**
     * Get DefinitionId value
     * @return string|null
     */
    public function getDefinitionId()
    {
        return $this->DefinitionId;
    }
    /**
     * Set DefinitionId value
     * @param string $definitionId
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        $this->DefinitionId = $definitionId;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FullAmount value
     * @return float|null
     */
    public function getFullAmount()
    {
        return $this->FullAmount;
    }
    /**
     * Set FullAmount value
     * @param float $fullAmount
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setFullAmount($fullAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fullAmount) && !(is_float($fullAmount) || is_numeric($fullAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullAmount, true), gettype($fullAmount)), __LINE__);
        }
        $this->FullAmount = $fullAmount;
        return $this;
    }
    /**
     * Get IsIncluded value
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return $this->IsIncluded;
    }
    /**
     * Set IsIncluded value
     * @param bool $isIncluded
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        $this->IsIncluded = $isIncluded;
        return $this;
    }
    /**
     * Get ParentAmountContribution value
     * @return float|null
     */
    public function getParentAmountContribution()
    {
        return $this->ParentAmountContribution;
    }
    /**
     * Set ParentAmountContribution value
     * @param float $parentAmountContribution
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setParentAmountContribution($parentAmountContribution = null)
    {
        // validation for constraint: float
        if (!is_null($parentAmountContribution) && !(is_float($parentAmountContribution) || is_numeric($parentAmountContribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($parentAmountContribution, true), gettype($parentAmountContribution)), __LINE__);
        }
        $this->ParentAmountContribution = $parentAmountContribution;
        return $this;
    }
    /**
     * Get PriceModifierType value
     * @return string|null
     */
    public function getPriceModifierType()
    {
        return $this->PriceModifierType;
    }
    /**
     * Set PriceModifierType value
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierType
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setPriceModifierType($priceModifierType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierType) ? implode(', ', $priceModifierType) : var_export($priceModifierType, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        $this->PriceModifierType = $priceModifierType;
        return $this;
    }
    /**
     * Get CalculationLevel value
     * @return string|null
     */
    public function getCalculationLevel()
    {
        return $this->CalculationLevel;
    }
    /**
     * Set CalculationLevel value
     * @uses \patest\EnumType\PriceModifierCalculationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationLevel
     * @return \patest\StructType\PricingTreePriceModifier
     */
    public function setCalculationLevel($calculationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationLevel::valueIsValid($calculationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationLevel', is_array($calculationLevel) ? implode(', ', $calculationLevel) : var_export($calculationLevel, true), implode(', ', \patest\EnumType\PriceModifierCalculationLevel::getValidValues())), __LINE__);
        }
        $this->CalculationLevel = $calculationLevel;
        return $this;
    }
}
