<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingTree StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PricingTree
 * @subpackage Structs
 */
class PricingTree extends AbstractStructBase
{
    /**
     * The FullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FullPrice;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ListPrice;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPricingTreePriceModifier
     */
    public $PriceModifiers;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BasePrice;
    /**
     * The IsCustomSeatPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCustomSeatPrice;
    /**
     * Constructor method for PricingTree
     * @uses PricingTree::setFullPrice()
     * @uses PricingTree::setListPrice()
     * @uses PricingTree::setPrice()
     * @uses PricingTree::setPriceModifiers()
     * @uses PricingTree::setBasePrice()
     * @uses PricingTree::setIsCustomSeatPrice()
     * @param float $fullPrice
     * @param float $listPrice
     * @param float $price
     * @param \patest\ArrayType\ArrayOfPricingTreePriceModifier $priceModifiers
     * @param float $basePrice
     * @param bool $isCustomSeatPrice
     */
    public function __construct($fullPrice = null, $listPrice = null, $price = null, \patest\ArrayType\ArrayOfPricingTreePriceModifier $priceModifiers = null, $basePrice = null, $isCustomSeatPrice = null)
    {
        $this
            ->setFullPrice($fullPrice)
            ->setListPrice($listPrice)
            ->setPrice($price)
            ->setPriceModifiers($priceModifiers)
            ->setBasePrice($basePrice)
            ->setIsCustomSeatPrice($isCustomSeatPrice);
    }
    /**
     * Get FullPrice value
     * @return float|null
     */
    public function getFullPrice()
    {
        return $this->FullPrice;
    }
    /**
     * Set FullPrice value
     * @param float $fullPrice
     * @return \patest\StructType\PricingTree
     */
    public function setFullPrice($fullPrice = null)
    {
        // validation for constraint: float
        if (!is_null($fullPrice) && !(is_float($fullPrice) || is_numeric($fullPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullPrice, true), gettype($fullPrice)), __LINE__);
        }
        $this->FullPrice = $fullPrice;
        return $this;
    }
    /**
     * Get ListPrice value
     * @return float|null
     */
    public function getListPrice()
    {
        return $this->ListPrice;
    }
    /**
     * Set ListPrice value
     * @param float $listPrice
     * @return \patest\StructType\PricingTree
     */
    public function setListPrice($listPrice = null)
    {
        // validation for constraint: float
        if (!is_null($listPrice) && !(is_float($listPrice) || is_numeric($listPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listPrice, true), gettype($listPrice)), __LINE__);
        }
        $this->ListPrice = $listPrice;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \patest\StructType\PricingTree
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPricingTreePriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPricingTreePriceModifier $priceModifiers
     * @return \patest\StructType\PricingTree
     */
    public function setPriceModifiers(\patest\ArrayType\ArrayOfPricingTreePriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get BasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBasePrice()
    {
        return isset($this->BasePrice) ? $this->BasePrice : null;
    }
    /**
     * Set BasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $basePrice
     * @return \patest\StructType\PricingTree
     */
    public function setBasePrice($basePrice = null)
    {
        // validation for constraint: float
        if (!is_null($basePrice) && !(is_float($basePrice) || is_numeric($basePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePrice, true), gettype($basePrice)), __LINE__);
        }
        if (is_null($basePrice) || (is_array($basePrice) && empty($basePrice))) {
            unset($this->BasePrice);
        } else {
            $this->BasePrice = $basePrice;
        }
        return $this;
    }
    /**
     * Get IsCustomSeatPrice value
     * @return bool|null
     */
    public function getIsCustomSeatPrice()
    {
        return $this->IsCustomSeatPrice;
    }
    /**
     * Set IsCustomSeatPrice value
     * @param bool $isCustomSeatPrice
     * @return \patest\StructType\PricingTree
     */
    public function setIsCustomSeatPrice($isCustomSeatPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomSeatPrice) && !is_bool($isCustomSeatPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCustomSeatPrice, true), gettype($isCustomSeatPrice)), __LINE__);
        }
        $this->IsCustomSeatPrice = $isCustomSeatPrice;
        return $this;
    }
}
