<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceModifierDefinitionSnapshot StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceModifierDefinitionSnapshot
 * @subpackage Structs
 */
class PriceModifierDefinitionSnapshot extends AbstractStructBase
{
    /**
     * The CalculationBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CalculationBase;
    /**
     * The CalculationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CalculationLevel;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The IsSeatgeekFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSeatgeekFee;
    /**
     * The MaxPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxPerTransaction;
    /**
     * The RegistrationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationLevel;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValueType;
    /**
     * Constructor method for PriceModifierDefinitionSnapshot
     * @uses PriceModifierDefinitionSnapshot::setCalculationBase()
     * @uses PriceModifierDefinitionSnapshot::setCalculationLevel()
     * @uses PriceModifierDefinitionSnapshot::setDefinitionId()
     * @uses PriceModifierDefinitionSnapshot::setIsSeatgeekFee()
     * @uses PriceModifierDefinitionSnapshot::setMaxPerTransaction()
     * @uses PriceModifierDefinitionSnapshot::setRegistrationLevel()
     * @uses PriceModifierDefinitionSnapshot::setValue()
     * @uses PriceModifierDefinitionSnapshot::setValueType()
     * @param string $calculationBase
     * @param string $calculationLevel
     * @param string $definitionId
     * @param bool $isSeatgeekFee
     * @param \patest\StructType\Money $maxPerTransaction
     * @param string $registrationLevel
     * @param float $value
     * @param string $valueType
     */
    public function __construct($calculationBase = null, $calculationLevel = null, $definitionId = null, $isSeatgeekFee = null, \patest\StructType\Money $maxPerTransaction = null, $registrationLevel = null, $value = null, $valueType = null)
    {
        $this
            ->setCalculationBase($calculationBase)
            ->setCalculationLevel($calculationLevel)
            ->setDefinitionId($definitionId)
            ->setIsSeatgeekFee($isSeatgeekFee)
            ->setMaxPerTransaction($maxPerTransaction)
            ->setRegistrationLevel($registrationLevel)
            ->setValue($value)
            ->setValueType($valueType);
    }
    /**
     * Get CalculationBase value
     * @return string|null
     */
    public function getCalculationBase()
    {
        return $this->CalculationBase;
    }
    /**
     * Set CalculationBase value
     * @uses \patest\EnumType\PriceModifierCalculationBase::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationBase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationBase
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setCalculationBase($calculationBase = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationBase::valueIsValid($calculationBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationBase', is_array($calculationBase) ? implode(', ', $calculationBase) : var_export($calculationBase, true), implode(', ', \patest\EnumType\PriceModifierCalculationBase::getValidValues())), __LINE__);
        }
        $this->CalculationBase = $calculationBase;
        return $this;
    }
    /**
     * Get CalculationLevel value
     * @return string|null
     */
    public function getCalculationLevel()
    {
        return $this->CalculationLevel;
    }
    /**
     * Set CalculationLevel value
     * @uses \patest\EnumType\PriceModifierCalculationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationLevel
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setCalculationLevel($calculationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationLevel::valueIsValid($calculationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationLevel', is_array($calculationLevel) ? implode(', ', $calculationLevel) : var_export($calculationLevel, true), implode(', ', \patest\EnumType\PriceModifierCalculationLevel::getValidValues())), __LINE__);
        }
        $this->CalculationLevel = $calculationLevel;
        return $this;
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get IsSeatgeekFee value
     * @return bool|null
     */
    public function getIsSeatgeekFee()
    {
        return $this->IsSeatgeekFee;
    }
    /**
     * Set IsSeatgeekFee value
     * @param bool $isSeatgeekFee
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setIsSeatgeekFee($isSeatgeekFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeatgeekFee) && !is_bool($isSeatgeekFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeatgeekFee, true), gettype($isSeatgeekFee)), __LINE__);
        }
        $this->IsSeatgeekFee = $isSeatgeekFee;
        return $this;
    }
    /**
     * Get MaxPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxPerTransaction()
    {
        return isset($this->MaxPerTransaction) ? $this->MaxPerTransaction : null;
    }
    /**
     * Set MaxPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxPerTransaction
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setMaxPerTransaction(\patest\StructType\Money $maxPerTransaction = null)
    {
        if (is_null($maxPerTransaction) || (is_array($maxPerTransaction) && empty($maxPerTransaction))) {
            unset($this->MaxPerTransaction);
        } else {
            $this->MaxPerTransaction = $maxPerTransaction;
        }
        return $this;
    }
    /**
     * Get RegistrationLevel value
     * @return string|null
     */
    public function getRegistrationLevel()
    {
        return $this->RegistrationLevel;
    }
    /**
     * Set RegistrationLevel value
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierRegistrationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registrationLevel
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setRegistrationLevel($registrationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierRegistrationLevel::valueIsValid($registrationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierRegistrationLevel', is_array($registrationLevel) ? implode(', ', $registrationLevel) : var_export($registrationLevel, true), implode(', ', \patest\EnumType\PriceModifierRegistrationLevel::getValidValues())), __LINE__);
        }
        $this->RegistrationLevel = $registrationLevel;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
}
