<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareInitiateSubscriptionsRenewalRequestRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareInitiateSubscriptionsRenewalRequestRequest
 * @subpackage Structs
 */
class PrepareInitiateSubscriptionsRenewalRequestRequest extends ExtensibleDataContract
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DoNotThrowExceptionIfNoSubscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotThrowExceptionIfNoSubscriptions;
    /**
     * The IsIncludeRelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncludeRelatedClients;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The IsIncludeFriendClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncludeFriendClients;
    /**
     * Constructor method for PrepareInitiateSubscriptionsRenewalRequestRequest
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setClientId()
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setDoNotThrowExceptionIfNoSubscriptions()
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setIsIncludeRelatedClients()
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setSeasonId()
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setTransactionGuid()
     * @uses PrepareInitiateSubscriptionsRenewalRequestRequest::setIsIncludeFriendClients()
     * @param string $clientId
     * @param bool $doNotThrowExceptionIfNoSubscriptions
     * @param bool $isIncludeRelatedClients
     * @param string $seasonId
     * @param string $transactionGuid
     * @param bool $isIncludeFriendClients
     */
    public function __construct($clientId = null, $doNotThrowExceptionIfNoSubscriptions = null, $isIncludeRelatedClients = null, $seasonId = null, $transactionGuid = null, $isIncludeFriendClients = null)
    {
        $this
            ->setClientId($clientId)
            ->setDoNotThrowExceptionIfNoSubscriptions($doNotThrowExceptionIfNoSubscriptions)
            ->setIsIncludeRelatedClients($isIncludeRelatedClients)
            ->setSeasonId($seasonId)
            ->setTransactionGuid($transactionGuid)
            ->setIsIncludeFriendClients($isIncludeFriendClients);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get DoNotThrowExceptionIfNoSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotThrowExceptionIfNoSubscriptions()
    {
        return isset($this->DoNotThrowExceptionIfNoSubscriptions) ? $this->DoNotThrowExceptionIfNoSubscriptions : null;
    }
    /**
     * Set DoNotThrowExceptionIfNoSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotThrowExceptionIfNoSubscriptions
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setDoNotThrowExceptionIfNoSubscriptions($doNotThrowExceptionIfNoSubscriptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotThrowExceptionIfNoSubscriptions) && !is_bool($doNotThrowExceptionIfNoSubscriptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotThrowExceptionIfNoSubscriptions, true), gettype($doNotThrowExceptionIfNoSubscriptions)), __LINE__);
        }
        if (is_null($doNotThrowExceptionIfNoSubscriptions) || (is_array($doNotThrowExceptionIfNoSubscriptions) && empty($doNotThrowExceptionIfNoSubscriptions))) {
            unset($this->DoNotThrowExceptionIfNoSubscriptions);
        } else {
            $this->DoNotThrowExceptionIfNoSubscriptions = $doNotThrowExceptionIfNoSubscriptions;
        }
        return $this;
    }
    /**
     * Get IsIncludeRelatedClients value
     * @return bool|null
     */
    public function getIsIncludeRelatedClients()
    {
        return $this->IsIncludeRelatedClients;
    }
    /**
     * Set IsIncludeRelatedClients value
     * @param bool $isIncludeRelatedClients
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setIsIncludeRelatedClients($isIncludeRelatedClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeRelatedClients) && !is_bool($isIncludeRelatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeRelatedClients, true), gettype($isIncludeRelatedClients)), __LINE__);
        }
        $this->IsIncludeRelatedClients = $isIncludeRelatedClients;
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get IsIncludeFriendClients value
     * @return bool|null
     */
    public function getIsIncludeFriendClients()
    {
        return $this->IsIncludeFriendClients;
    }
    /**
     * Set IsIncludeFriendClients value
     * @param bool $isIncludeFriendClients
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest
     */
    public function setIsIncludeFriendClients($isIncludeFriendClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeFriendClients) && !is_bool($isIncludeFriendClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeFriendClients, true), gettype($isIncludeFriendClients)), __LINE__);
        }
        $this->IsIncludeFriendClients = $isIncludeFriendClients;
        return $this;
    }
}
