<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments.GetOpsUnattendedPaymentParameters StructType
 * @subpackage Structs
 */
class Payments_GetOpsUnattendedPaymentParameters extends AnyEntity
{
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The PayUsingPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUsingPaymentTokenId;
    /**
     * Constructor method for Payments.GetOpsUnattendedPaymentParameters
     * @uses Payments_GetOpsUnattendedPaymentParameters::setIsForFuturePayByCustomer()
     * @uses Payments_GetOpsUnattendedPaymentParameters::setPayUsingPaymentTokenId()
     * @param bool $isForFuturePayByCustomer
     * @param string $payUsingPaymentTokenId
     */
    public function __construct($isForFuturePayByCustomer = null, $payUsingPaymentTokenId = null)
    {
        $this
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setPayUsingPaymentTokenId($payUsingPaymentTokenId);
    }
    /**
     * Get IsForFuturePayByCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return isset($this->IsForFuturePayByCustomer) ? $this->IsForFuturePayByCustomer : null;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\Payments_GetOpsUnattendedPaymentParameters
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        if (is_null($isForFuturePayByCustomer) || (is_array($isForFuturePayByCustomer) && empty($isForFuturePayByCustomer))) {
            unset($this->IsForFuturePayByCustomer);
        } else {
            $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        }
        return $this;
    }
    /**
     * Get PayUsingPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUsingPaymentTokenId()
    {
        return isset($this->PayUsingPaymentTokenId) ? $this->PayUsingPaymentTokenId : null;
    }
    /**
     * Set PayUsingPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUsingPaymentTokenId
     * @return \patest\StructType\Payments_GetOpsUnattendedPaymentParameters
     */
    public function setPayUsingPaymentTokenId($payUsingPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($payUsingPaymentTokenId) && !is_string($payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUsingPaymentTokenId, true), gettype($payUsingPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUsingPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUsingPaymentTokenId, true)), __LINE__);
        }
        if (is_null($payUsingPaymentTokenId) || (is_array($payUsingPaymentTokenId) && empty($payUsingPaymentTokenId))) {
            unset($this->PayUsingPaymentTokenId);
        } else {
            $this->PayUsingPaymentTokenId = $payUsingPaymentTokenId;
        }
        return $this;
    }
}
