<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.DirectDebitMandate StructType
 * @subpackage Structs
 */
class Payment_Printing_DirectDebitMandate extends AnyEntity
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AuthorizationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationDate;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Authorized;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BIC;
    /**
     * The CollectPaymentOnDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CollectPaymentOnDay;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The GiroAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiroAccountNumber;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The MandateExpirationInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateExpirationInDays;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The NotSoonerThenDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotSoonerThenDate;
    /**
     * Constructor method for Payment.Printing.DirectDebitMandate
     * @uses Payment_Printing_DirectDebitMandate::setAccountName()
     * @uses Payment_Printing_DirectDebitMandate::setAccountNumber()
     * @uses Payment_Printing_DirectDebitMandate::setAuthorizationDate()
     * @uses Payment_Printing_DirectDebitMandate::setAuthorized()
     * @uses Payment_Printing_DirectDebitMandate::setBankAddress()
     * @uses Payment_Printing_DirectDebitMandate::setBankCode()
     * @uses Payment_Printing_DirectDebitMandate::setBankName()
     * @uses Payment_Printing_DirectDebitMandate::setBIC()
     * @uses Payment_Printing_DirectDebitMandate::setCollectPaymentOnDay()
     * @uses Payment_Printing_DirectDebitMandate::setExpirationDate()
     * @uses Payment_Printing_DirectDebitMandate::setGiroAccountNumber()
     * @uses Payment_Printing_DirectDebitMandate::setIBAN()
     * @uses Payment_Printing_DirectDebitMandate::setMandateExpirationInDays()
     * @uses Payment_Printing_DirectDebitMandate::setMandateNumber()
     * @uses Payment_Printing_DirectDebitMandate::setNotSoonerThenDate()
     * @param string $accountName
     * @param string $accountNumber
     * @param string $authorizationDate
     * @param bool $authorized
     * @param string $bankAddress
     * @param string $bankCode
     * @param string $bankName
     * @param string $bIC
     * @param int $collectPaymentOnDay
     * @param string $expirationDate
     * @param string $giroAccountNumber
     * @param string $iBAN
     * @param int $mandateExpirationInDays
     * @param int $mandateNumber
     * @param string $notSoonerThenDate
     */
    public function __construct($accountName = null, $accountNumber = null, $authorizationDate = null, $authorized = null, $bankAddress = null, $bankCode = null, $bankName = null, $bIC = null, $collectPaymentOnDay = null, $expirationDate = null, $giroAccountNumber = null, $iBAN = null, $mandateExpirationInDays = null, $mandateNumber = null, $notSoonerThenDate = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setAuthorizationDate($authorizationDate)
            ->setAuthorized($authorized)
            ->setBankAddress($bankAddress)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBIC($bIC)
            ->setCollectPaymentOnDay($collectPaymentOnDay)
            ->setExpirationDate($expirationDate)
            ->setGiroAccountNumber($giroAccountNumber)
            ->setIBAN($iBAN)
            ->setMandateExpirationInDays($mandateExpirationInDays)
            ->setMandateNumber($mandateNumber)
            ->setNotSoonerThenDate($notSoonerThenDate);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get AuthorizationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationDate()
    {
        return isset($this->AuthorizationDate) ? $this->AuthorizationDate : null;
    }
    /**
     * Set AuthorizationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationDate
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setAuthorizationDate($authorizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationDate) && !is_string($authorizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationDate, true), gettype($authorizationDate)), __LINE__);
        }
        if (is_null($authorizationDate) || (is_array($authorizationDate) && empty($authorizationDate))) {
            unset($this->AuthorizationDate);
        } else {
            $this->AuthorizationDate = $authorizationDate;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAuthorized()
    {
        return isset($this->Authorized) ? $this->Authorized : null;
    }
    /**
     * Set Authorized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $authorized
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        if (is_null($authorized) || (is_array($authorized) && empty($authorized))) {
            unset($this->Authorized);
        } else {
            $this->Authorized = $authorized;
        }
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get BIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBIC()
    {
        return isset($this->BIC) ? $this->BIC : null;
    }
    /**
     * Set BIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bIC
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        if (is_null($bIC) || (is_array($bIC) && empty($bIC))) {
            unset($this->BIC);
        } else {
            $this->BIC = $bIC;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCollectPaymentOnDay()
    {
        return isset($this->CollectPaymentOnDay) ? $this->CollectPaymentOnDay : null;
    }
    /**
     * Set CollectPaymentOnDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $collectPaymentOnDay
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setCollectPaymentOnDay($collectPaymentOnDay = null)
    {
        // validation for constraint: int
        if (!is_null($collectPaymentOnDay) && !(is_int($collectPaymentOnDay) || ctype_digit($collectPaymentOnDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectPaymentOnDay, true), gettype($collectPaymentOnDay)), __LINE__);
        }
        if (is_null($collectPaymentOnDay) || (is_array($collectPaymentOnDay) && empty($collectPaymentOnDay))) {
            unset($this->CollectPaymentOnDay);
        } else {
            $this->CollectPaymentOnDay = $collectPaymentOnDay;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get GiroAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiroAccountNumber()
    {
        return isset($this->GiroAccountNumber) ? $this->GiroAccountNumber : null;
    }
    /**
     * Set GiroAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giroAccountNumber
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setGiroAccountNumber($giroAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giroAccountNumber) && !is_string($giroAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giroAccountNumber, true), gettype($giroAccountNumber)), __LINE__);
        }
        if (is_null($giroAccountNumber) || (is_array($giroAccountNumber) && empty($giroAccountNumber))) {
            unset($this->GiroAccountNumber);
        } else {
            $this->GiroAccountNumber = $giroAccountNumber;
        }
        return $this;
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get MandateExpirationInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateExpirationInDays()
    {
        return isset($this->MandateExpirationInDays) ? $this->MandateExpirationInDays : null;
    }
    /**
     * Set MandateExpirationInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateExpirationInDays
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setMandateExpirationInDays($mandateExpirationInDays = null)
    {
        // validation for constraint: int
        if (!is_null($mandateExpirationInDays) && !(is_int($mandateExpirationInDays) || ctype_digit($mandateExpirationInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateExpirationInDays, true), gettype($mandateExpirationInDays)), __LINE__);
        }
        if (is_null($mandateExpirationInDays) || (is_array($mandateExpirationInDays) && empty($mandateExpirationInDays))) {
            unset($this->MandateExpirationInDays);
        } else {
            $this->MandateExpirationInDays = $mandateExpirationInDays;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get NotSoonerThenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotSoonerThenDate()
    {
        return isset($this->NotSoonerThenDate) ? $this->NotSoonerThenDate : null;
    }
    /**
     * Set NotSoonerThenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notSoonerThenDate
     * @return \patest\StructType\Payment_Printing_DirectDebitMandate
     */
    public function setNotSoonerThenDate($notSoonerThenDate = null)
    {
        // validation for constraint: string
        if (!is_null($notSoonerThenDate) && !is_string($notSoonerThenDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notSoonerThenDate, true), gettype($notSoonerThenDate)), __LINE__);
        }
        if (is_null($notSoonerThenDate) || (is_array($notSoonerThenDate) && empty($notSoonerThenDate))) {
            unset($this->NotSoonerThenDate);
        } else {
            $this->NotSoonerThenDate = $notSoonerThenDate;
        }
        return $this;
    }
}
