<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentJournalEntryFilter StructType
 * @subpackage Structs
 */
class Payment_PaymentJournalEntryFilter extends FilterEntity
{
    /**
     * The CorrelationNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CorrelationNum;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTo;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.PaymentJournalEntryFilter
     * @uses Payment_PaymentJournalEntryFilter::setCorrelationNum()
     * @uses Payment_PaymentJournalEntryFilter::setDateFrom()
     * @uses Payment_PaymentJournalEntryFilter::setDateTo()
     * @uses Payment_PaymentJournalEntryFilter::setPaymentMethodId()
     * @uses Payment_PaymentJournalEntryFilter::setReferenceNumber()
     * @uses Payment_PaymentJournalEntryFilter::setTransactionNumber()
     * @param int $correlationNum
     * @param string $dateFrom
     * @param string $dateTo
     * @param string $paymentMethodId
     * @param string $referenceNumber
     * @param int $transactionNumber
     */
    public function __construct($correlationNum = null, $dateFrom = null, $dateTo = null, $paymentMethodId = null, $referenceNumber = null, $transactionNumber = null)
    {
        $this
            ->setCorrelationNum($correlationNum)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setPaymentMethodId($paymentMethodId)
            ->setReferenceNumber($referenceNumber)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get CorrelationNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCorrelationNum()
    {
        return isset($this->CorrelationNum) ? $this->CorrelationNum : null;
    }
    /**
     * Set CorrelationNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $correlationNum
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setCorrelationNum($correlationNum = null)
    {
        // validation for constraint: int
        if (!is_null($correlationNum) && !(is_int($correlationNum) || ctype_digit($correlationNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($correlationNum, true), gettype($correlationNum)), __LINE__);
        }
        if (is_null($correlationNum) || (is_array($correlationNum) && empty($correlationNum))) {
            unset($this->CorrelationNum);
        } else {
            $this->CorrelationNum = $correlationNum;
        }
        return $this;
    }
    /**
     * Get DateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFrom()
    {
        return isset($this->DateFrom) ? $this->DateFrom : null;
    }
    /**
     * Set DateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFrom
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        if (is_null($dateFrom) || (is_array($dateFrom) && empty($dateFrom))) {
            unset($this->DateFrom);
        } else {
            $this->DateFrom = $dateFrom;
        }
        return $this;
    }
    /**
     * Get DateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTo()
    {
        return isset($this->DateTo) ? $this->DateTo : null;
    }
    /**
     * Set DateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTo
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        if (is_null($dateTo) || (is_array($dateTo) && empty($dateTo))) {
            unset($this->DateTo);
        } else {
            $this->DateTo = $dateTo;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_PaymentJournalEntryFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
