<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentJournalEntry StructType
 * @subpackage Structs
 */
class Payment_PaymentJournalEntry extends Foundation_JournalEntry
{
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraInfo
     */
    public $ExtraInfo;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PaymentItemXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentItemXml;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderSpecificData;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for Payment.PaymentJournalEntry
     * @uses Payment_PaymentJournalEntry::setExtraInfo()
     * @uses Payment_PaymentJournalEntry::setPaymentItemId()
     * @uses Payment_PaymentJournalEntry::setPaymentItemXml()
     * @uses Payment_PaymentJournalEntry::setPaymentMethodId()
     * @uses Payment_PaymentJournalEntry::setPaymentSessionId()
     * @uses Payment_PaymentJournalEntry::setProviderSpecificData()
     * @uses Payment_PaymentJournalEntry::setStatusCode()
     * @uses Payment_PaymentJournalEntry::setTransactionId()
     * @param \patest\StructType\ExtraInfo $extraInfo
     * @param string $paymentItemId
     * @param string $paymentItemXml
     * @param string $paymentMethodId
     * @param string $paymentSessionId
     * @param string $providerSpecificData
     * @param string $statusCode
     * @param string $transactionId
     */
    public function __construct(\patest\StructType\ExtraInfo $extraInfo = null, $paymentItemId = null, $paymentItemXml = null, $paymentMethodId = null, $paymentSessionId = null, $providerSpecificData = null, $statusCode = null, $transactionId = null)
    {
        $this
            ->setExtraInfo($extraInfo)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentItemXml($paymentItemXml)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentSessionId($paymentSessionId)
            ->setProviderSpecificData($providerSpecificData)
            ->setStatusCode($statusCode)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraInfo|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraInfo $extraInfo
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setExtraInfo(\patest\StructType\ExtraInfo $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PaymentItemXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemXml()
    {
        return isset($this->PaymentItemXml) ? $this->PaymentItemXml : null;
    }
    /**
     * Set PaymentItemXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemXml
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setPaymentItemXml($paymentItemXml = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemXml) && !is_string($paymentItemXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemXml, true), gettype($paymentItemXml)), __LINE__);
        }
        if (is_null($paymentItemXml) || (is_array($paymentItemXml) && empty($paymentItemXml))) {
            unset($this->PaymentItemXml);
        } else {
            $this->PaymentItemXml = $paymentItemXml;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return isset($this->PaymentSessionId) ? $this->PaymentSessionId : null;
    }
    /**
     * Set PaymentSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSessionId
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        if (is_null($paymentSessionId) || (is_array($paymentSessionId) && empty($paymentSessionId))) {
            unset($this->PaymentSessionId);
        } else {
            $this->PaymentSessionId = $paymentSessionId;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificData
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setProviderSpecificData($providerSpecificData = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificData) && !is_string($providerSpecificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificData, true), gettype($providerSpecificData)), __LINE__);
        }
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Payment_PaymentJournalEntry
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
