<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.LoyaltyPointsAuditFilter StructType
 * @subpackage Structs
 */
class Payment_LoyaltyPointsAuditFilter extends FilterEntity
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTo;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Event;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for Payment.LoyaltyPointsAuditFilter
     * @uses Payment_LoyaltyPointsAuditFilter::setAccountName()
     * @uses Payment_LoyaltyPointsAuditFilter::setDateFrom()
     * @uses Payment_LoyaltyPointsAuditFilter::setDateTo()
     * @uses Payment_LoyaltyPointsAuditFilter::setEvent()
     * @uses Payment_LoyaltyPointsAuditFilter::setFirstName()
     * @uses Payment_LoyaltyPointsAuditFilter::setLastName()
     * @param string $accountName
     * @param string $dateFrom
     * @param string $dateTo
     * @param string $event
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct($accountName = null, $dateFrom = null, $dateTo = null, $event = null, $firstName = null, $lastName = null)
    {
        $this
            ->setAccountName($accountName)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setEvent($event)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get DateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFrom()
    {
        return isset($this->DateFrom) ? $this->DateFrom : null;
    }
    /**
     * Set DateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFrom
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        if (is_null($dateFrom) || (is_array($dateFrom) && empty($dateFrom))) {
            unset($this->DateFrom);
        } else {
            $this->DateFrom = $dateFrom;
        }
        return $this;
    }
    /**
     * Get DateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTo()
    {
        return isset($this->DateTo) ? $this->DateTo : null;
    }
    /**
     * Set DateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTo
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        if (is_null($dateTo) || (is_array($dateTo) && empty($dateTo))) {
            unset($this->DateTo);
        } else {
            $this->DateTo = $dateTo;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsOperationEvent::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsOperationEvent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $event
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setEvent($event = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsOperationEvent::valueIsValid($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsOperationEvent', is_array($event) ? implode(', ', $event) : var_export($event, true), implode(', ', \patest\EnumType\LoyaltyPointsOperationEvent::getValidValues())), __LINE__);
        }
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Payment_LoyaltyPointsAuditFilter
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
}
