<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Installment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment.Installment
 * @subpackage Structs
 */
class Payment_Installment extends PersistableEntity
{
    /**
     * The AmountAdjustmentOption
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountAdjustmentOption;
    /**
     * The AutomaticallyAdded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutomaticallyAdded;
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The ClientCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCurrencyCode;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DepositTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositTransactionId;
    /**
     * The DepositTransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepositTransactionNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The Expired
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Expired;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedCount;
    /**
     * The FailReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailReason;
    /**
     * The InstallmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatus;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The PaidOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaidOnDate;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The ProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProviderSpecificTokenId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.Installment
     * @uses Payment_Installment::setAmountAdjustmentOption()
     * @uses Payment_Installment::setAutomaticallyAdded()
     * @uses Payment_Installment::setClientAmount()
     * @uses Payment_Installment::setClientCurrencyCode()
     * @uses Payment_Installment::setClientId()
     * @uses Payment_Installment::setDepositTransactionId()
     * @uses Payment_Installment::setDepositTransactionNumber()
     * @uses Payment_Installment::setDescription()
     * @uses Payment_Installment::setDueDate()
     * @uses Payment_Installment::setExpired()
     * @uses Payment_Installment::setExpiryDate()
     * @uses Payment_Installment::setFailedCount()
     * @uses Payment_Installment::setFailReason()
     * @uses Payment_Installment::setInstallmentStatus()
     * @uses Payment_Installment::setNotes()
     * @uses Payment_Installment::setNumberOfInstallments()
     * @uses Payment_Installment::setOrder()
     * @uses Payment_Installment::setPaidOnDate()
     * @uses Payment_Installment::setPaymentDetails()
     * @uses Payment_Installment::setPaymentInstallmentsScheduleId()
     * @uses Payment_Installment::setPaymentItemId()
     * @uses Payment_Installment::setPaymentMethodId()
     * @uses Payment_Installment::setPaymentMethodType()
     * @uses Payment_Installment::setPaymentPlanId()
     * @uses Payment_Installment::setPaymentStatus()
     * @uses Payment_Installment::setProviderSpecificTokenId()
     * @uses Payment_Installment::setTransactionId()
     * @uses Payment_Installment::setTransactionNumber()
     * @param string $amountAdjustmentOption
     * @param bool $automaticallyAdded
     * @param \patest\StructType\Money $clientAmount
     * @param string $clientCurrencyCode
     * @param string $clientId
     * @param string $depositTransactionId
     * @param string $depositTransactionNumber
     * @param string $description
     * @param string $dueDate
     * @param bool $expired
     * @param string $expiryDate
     * @param int $failedCount
     * @param string $failReason
     * @param string $installmentStatus
     * @param string $notes
     * @param int $numberOfInstallments
     * @param int $order
     * @param string $paidOnDate
     * @param string $paymentDetails
     * @param string $paymentInstallmentsScheduleId
     * @param string $paymentItemId
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $paymentPlanId
     * @param string $paymentStatus
     * @param string $providerSpecificTokenId
     * @param string $transactionId
     * @param int $transactionNumber
     */
    public function __construct($amountAdjustmentOption = null, $automaticallyAdded = null, \patest\StructType\Money $clientAmount = null, $clientCurrencyCode = null, $clientId = null, $depositTransactionId = null, $depositTransactionNumber = null, $description = null, $dueDate = null, $expired = null, $expiryDate = null, $failedCount = null, $failReason = null, $installmentStatus = null, $notes = null, $numberOfInstallments = null, $order = null, $paidOnDate = null, $paymentDetails = null, $paymentInstallmentsScheduleId = null, $paymentItemId = null, $paymentMethodId = null, $paymentMethodType = null, $paymentPlanId = null, $paymentStatus = null, $providerSpecificTokenId = null, $transactionId = null, $transactionNumber = null)
    {
        $this
            ->setAmountAdjustmentOption($amountAdjustmentOption)
            ->setAutomaticallyAdded($automaticallyAdded)
            ->setClientAmount($clientAmount)
            ->setClientCurrencyCode($clientCurrencyCode)
            ->setClientId($clientId)
            ->setDepositTransactionId($depositTransactionId)
            ->setDepositTransactionNumber($depositTransactionNumber)
            ->setDescription($description)
            ->setDueDate($dueDate)
            ->setExpired($expired)
            ->setExpiryDate($expiryDate)
            ->setFailedCount($failedCount)
            ->setFailReason($failReason)
            ->setInstallmentStatus($installmentStatus)
            ->setNotes($notes)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setOrder($order)
            ->setPaidOnDate($paidOnDate)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentPlanId($paymentPlanId)
            ->setPaymentStatus($paymentStatus)
            ->setProviderSpecificTokenId($providerSpecificTokenId)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AmountAdjustmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountAdjustmentOption()
    {
        return isset($this->AmountAdjustmentOption) ? $this->AmountAdjustmentOption : null;
    }
    /**
     * Set AmountAdjustmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountAdjustmentOption
     * @return \patest\StructType\Payment_Installment
     */
    public function setAmountAdjustmentOption($amountAdjustmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($amountAdjustmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($amountAdjustmentOption) ? implode(', ', $amountAdjustmentOption) : var_export($amountAdjustmentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($amountAdjustmentOption) || (is_array($amountAdjustmentOption) && empty($amountAdjustmentOption))) {
            unset($this->AmountAdjustmentOption);
        } else {
            $this->AmountAdjustmentOption = $amountAdjustmentOption;
        }
        return $this;
    }
    /**
     * Get AutomaticallyAdded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutomaticallyAdded()
    {
        return isset($this->AutomaticallyAdded) ? $this->AutomaticallyAdded : null;
    }
    /**
     * Set AutomaticallyAdded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $automaticallyAdded
     * @return \patest\StructType\Payment_Installment
     */
    public function setAutomaticallyAdded($automaticallyAdded = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticallyAdded) && !is_bool($automaticallyAdded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automaticallyAdded, true), gettype($automaticallyAdded)), __LINE__);
        }
        if (is_null($automaticallyAdded) || (is_array($automaticallyAdded) && empty($automaticallyAdded))) {
            unset($this->AutomaticallyAdded);
        } else {
            $this->AutomaticallyAdded = $automaticallyAdded;
        }
        return $this;
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_Installment
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get ClientCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCurrencyCode()
    {
        return isset($this->ClientCurrencyCode) ? $this->ClientCurrencyCode : null;
    }
    /**
     * Set ClientCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCurrencyCode
     * @return \patest\StructType\Payment_Installment
     */
    public function setClientCurrencyCode($clientCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCurrencyCode) && !is_string($clientCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCurrencyCode, true), gettype($clientCurrencyCode)), __LINE__);
        }
        if (is_null($clientCurrencyCode) || (is_array($clientCurrencyCode) && empty($clientCurrencyCode))) {
            unset($this->ClientCurrencyCode);
        } else {
            $this->ClientCurrencyCode = $clientCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_Installment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DepositTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositTransactionId()
    {
        return isset($this->DepositTransactionId) ? $this->DepositTransactionId : null;
    }
    /**
     * Set DepositTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositTransactionId
     * @return \patest\StructType\Payment_Installment
     */
    public function setDepositTransactionId($depositTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($depositTransactionId) && !is_string($depositTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTransactionId, true), gettype($depositTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositTransactionId, true)), __LINE__);
        }
        if (is_null($depositTransactionId) || (is_array($depositTransactionId) && empty($depositTransactionId))) {
            unset($this->DepositTransactionId);
        } else {
            $this->DepositTransactionId = $depositTransactionId;
        }
        return $this;
    }
    /**
     * Get DepositTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositTransactionNumber()
    {
        return isset($this->DepositTransactionNumber) ? $this->DepositTransactionNumber : null;
    }
    /**
     * Set DepositTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositTransactionNumber
     * @return \patest\StructType\Payment_Installment
     */
    public function setDepositTransactionNumber($depositTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depositTransactionNumber) && !is_string($depositTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTransactionNumber, true), gettype($depositTransactionNumber)), __LINE__);
        }
        if (is_null($depositTransactionNumber) || (is_array($depositTransactionNumber) && empty($depositTransactionNumber))) {
            unset($this->DepositTransactionNumber);
        } else {
            $this->DepositTransactionNumber = $depositTransactionNumber;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Payment_Installment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Payment_Installment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get Expired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExpired()
    {
        return isset($this->Expired) ? $this->Expired : null;
    }
    /**
     * Set Expired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $expired
     * @return \patest\StructType\Payment_Installment
     */
    public function setExpired($expired = null)
    {
        // validation for constraint: boolean
        if (!is_null($expired) && !is_bool($expired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expired, true), gettype($expired)), __LINE__);
        }
        if (is_null($expired) || (is_array($expired) && empty($expired))) {
            unset($this->Expired);
        } else {
            $this->Expired = $expired;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Payment_Installment
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get FailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedCount()
    {
        return isset($this->FailedCount) ? $this->FailedCount : null;
    }
    /**
     * Set FailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedCount
     * @return \patest\StructType\Payment_Installment
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        if (is_null($failedCount) || (is_array($failedCount) && empty($failedCount))) {
            unset($this->FailedCount);
        } else {
            $this->FailedCount = $failedCount;
        }
        return $this;
    }
    /**
     * Get FailReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailReason()
    {
        return isset($this->FailReason) ? $this->FailReason : null;
    }
    /**
     * Set FailReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failReason
     * @return \patest\StructType\Payment_Installment
     */
    public function setFailReason($failReason = null)
    {
        // validation for constraint: string
        if (!is_null($failReason) && !is_string($failReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failReason, true), gettype($failReason)), __LINE__);
        }
        if (is_null($failReason) || (is_array($failReason) && empty($failReason))) {
            unset($this->FailReason);
        } else {
            $this->FailReason = $failReason;
        }
        return $this;
    }
    /**
     * Get InstallmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatus()
    {
        return isset($this->InstallmentStatus) ? $this->InstallmentStatus : null;
    }
    /**
     * Set InstallmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentStatus::valueIsValid()
     * @uses \patest\EnumType\InstallmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentStatus
     * @return \patest\StructType\Payment_Installment
     */
    public function setInstallmentStatus($installmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentStatus::valueIsValid($installmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentStatus', is_array($installmentStatus) ? implode(', ', $installmentStatus) : var_export($installmentStatus, true), implode(', ', \patest\EnumType\InstallmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($installmentStatus) || (is_array($installmentStatus) && empty($installmentStatus))) {
            unset($this->InstallmentStatus);
        } else {
            $this->InstallmentStatus = $installmentStatus;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Payment_Installment
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_Installment
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\Payment_Installment
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get PaidOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaidOnDate()
    {
        return isset($this->PaidOnDate) ? $this->PaidOnDate : null;
    }
    /**
     * Set PaidOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paidOnDate
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaidOnDate($paidOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($paidOnDate) && !is_string($paidOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidOnDate, true), gettype($paidOnDate)), __LINE__);
        }
        if (is_null($paidOnDate) || (is_array($paidOnDate) && empty($paidOnDate))) {
            unset($this->PaidOnDate);
        } else {
            $this->PaidOnDate = $paidOnDate;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Payment_Installment
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificTokenId()
    {
        return isset($this->ProviderSpecificTokenId) ? $this->ProviderSpecificTokenId : null;
    }
    /**
     * Set ProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificTokenId
     * @return \patest\StructType\Payment_Installment
     */
    public function setProviderSpecificTokenId($providerSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificTokenId) && !is_string($providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificTokenId, true), gettype($providerSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($providerSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($providerSpecificTokenId, true)), __LINE__);
        }
        if (is_null($providerSpecificTokenId) || (is_array($providerSpecificTokenId) && empty($providerSpecificTokenId))) {
            unset($this->ProviderSpecificTokenId);
        } else {
            $this->ProviderSpecificTokenId = $providerSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Payment_Installment
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_Installment
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
