<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddOnlinePaymentToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddOnlinePaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The PayUsingPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUsingPaymentTokenId;
    /**
     * The UseStoredCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseStoredCard;
    /**
     * Constructor method for Payment.AddOnlinePaymentToBasketRequest
     * @uses Payment_AddOnlinePaymentToBasketRequest::setIsForFuturePayByCustomer()
     * @uses Payment_AddOnlinePaymentToBasketRequest::setPayUsingPaymentTokenId()
     * @uses Payment_AddOnlinePaymentToBasketRequest::setUseStoredCard()
     * @param bool $isForFuturePayByCustomer
     * @param string $payUsingPaymentTokenId
     * @param bool $useStoredCard
     */
    public function __construct($isForFuturePayByCustomer = null, $payUsingPaymentTokenId = null, $useStoredCard = null)
    {
        $this
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setPayUsingPaymentTokenId($payUsingPaymentTokenId)
            ->setUseStoredCard($useStoredCard);
    }
    /**
     * Get IsForFuturePayByCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return isset($this->IsForFuturePayByCustomer) ? $this->IsForFuturePayByCustomer : null;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\Payment_AddOnlinePaymentToBasketRequest
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        if (is_null($isForFuturePayByCustomer) || (is_array($isForFuturePayByCustomer) && empty($isForFuturePayByCustomer))) {
            unset($this->IsForFuturePayByCustomer);
        } else {
            $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        }
        return $this;
    }
    /**
     * Get PayUsingPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUsingPaymentTokenId()
    {
        return isset($this->PayUsingPaymentTokenId) ? $this->PayUsingPaymentTokenId : null;
    }
    /**
     * Set PayUsingPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUsingPaymentTokenId
     * @return \patest\StructType\Payment_AddOnlinePaymentToBasketRequest
     */
    public function setPayUsingPaymentTokenId($payUsingPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($payUsingPaymentTokenId) && !is_string($payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUsingPaymentTokenId, true), gettype($payUsingPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUsingPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUsingPaymentTokenId, true)), __LINE__);
        }
        if (is_null($payUsingPaymentTokenId) || (is_array($payUsingPaymentTokenId) && empty($payUsingPaymentTokenId))) {
            unset($this->PayUsingPaymentTokenId);
        } else {
            $this->PayUsingPaymentTokenId = $payUsingPaymentTokenId;
        }
        return $this;
    }
    /**
     * Get UseStoredCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseStoredCard()
    {
        return isset($this->UseStoredCard) ? $this->UseStoredCard : null;
    }
    /**
     * Set UseStoredCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useStoredCard
     * @return \patest\StructType\Payment_AddOnlinePaymentToBasketRequest
     */
    public function setUseStoredCard($useStoredCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($useStoredCard) && !is_bool($useStoredCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useStoredCard, true), gettype($useStoredCard)), __LINE__);
        }
        if (is_null($useStoredCard) || (is_array($useStoredCard) && empty($useStoredCard))) {
            unset($this->UseStoredCard);
        } else {
            $this->UseStoredCard = $useStoredCard;
        }
        return $this;
    }
}
