<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddCustomDummyDirectDebitPaymentToBasketRequest
 * StructType
 * @subpackage Structs
 */
class Payment_AddCustomDummyDirectDebitPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Authorized;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The CollectPaymentOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectPaymentOnDate;
    /**
     * The Expires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Expires;
    /**
     * The MandateCollectPaymentOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateCollectPaymentOnDate;
    /**
     * The MandateEffectiveOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MandateEffectiveOnly;
    /**
     * The MandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateId;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * Constructor method for Payment.AddCustomDummyDirectDebitPaymentToBasketRequest
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setAccountName()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setAccountNumber()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setAuthorized()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setBankAddress()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setBankCode()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setBankName()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setCollectPaymentOnDate()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setExpires()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setMandateCollectPaymentOnDate()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setMandateEffectiveOnly()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setMandateId()
     * @uses Payment_AddCustomDummyDirectDebitPaymentToBasketRequest::setMandateTypeId()
     * @param string $accountName
     * @param string $accountNumber
     * @param bool $authorized
     * @param string $bankAddress
     * @param string $bankCode
     * @param string $bankName
     * @param string $collectPaymentOnDate
     * @param int $expires
     * @param int $mandateCollectPaymentOnDate
     * @param bool $mandateEffectiveOnly
     * @param string $mandateId
     * @param string $mandateTypeId
     */
    public function __construct($accountName = null, $accountNumber = null, $authorized = null, $bankAddress = null, $bankCode = null, $bankName = null, $collectPaymentOnDate = null, $expires = null, $mandateCollectPaymentOnDate = null, $mandateEffectiveOnly = null, $mandateId = null, $mandateTypeId = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setAuthorized($authorized)
            ->setBankAddress($bankAddress)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setCollectPaymentOnDate($collectPaymentOnDate)
            ->setExpires($expires)
            ->setMandateCollectPaymentOnDate($mandateCollectPaymentOnDate)
            ->setMandateEffectiveOnly($mandateEffectiveOnly)
            ->setMandateId($mandateId)
            ->setMandateTypeId($mandateTypeId);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAuthorized()
    {
        return isset($this->Authorized) ? $this->Authorized : null;
    }
    /**
     * Set Authorized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $authorized
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        if (is_null($authorized) || (is_array($authorized) && empty($authorized))) {
            unset($this->Authorized);
        } else {
            $this->Authorized = $authorized;
        }
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectPaymentOnDate()
    {
        return isset($this->CollectPaymentOnDate) ? $this->CollectPaymentOnDate : null;
    }
    /**
     * Set CollectPaymentOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectPaymentOnDate
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setCollectPaymentOnDate($collectPaymentOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($collectPaymentOnDate) && !is_string($collectPaymentOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectPaymentOnDate, true), gettype($collectPaymentOnDate)), __LINE__);
        }
        if (is_null($collectPaymentOnDate) || (is_array($collectPaymentOnDate) && empty($collectPaymentOnDate))) {
            unset($this->CollectPaymentOnDate);
        } else {
            $this->CollectPaymentOnDate = $collectPaymentOnDate;
        }
        return $this;
    }
    /**
     * Get Expires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpires()
    {
        return isset($this->Expires) ? $this->Expires : null;
    }
    /**
     * Set Expires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expires
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: int
        if (!is_null($expires) && !(is_int($expires) || ctype_digit($expires))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expires, true), gettype($expires)), __LINE__);
        }
        if (is_null($expires) || (is_array($expires) && empty($expires))) {
            unset($this->Expires);
        } else {
            $this->Expires = $expires;
        }
        return $this;
    }
    /**
     * Get MandateCollectPaymentOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateCollectPaymentOnDate()
    {
        return isset($this->MandateCollectPaymentOnDate) ? $this->MandateCollectPaymentOnDate : null;
    }
    /**
     * Set MandateCollectPaymentOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateCollectPaymentOnDate
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setMandateCollectPaymentOnDate($mandateCollectPaymentOnDate = null)
    {
        // validation for constraint: int
        if (!is_null($mandateCollectPaymentOnDate) && !(is_int($mandateCollectPaymentOnDate) || ctype_digit($mandateCollectPaymentOnDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateCollectPaymentOnDate, true), gettype($mandateCollectPaymentOnDate)), __LINE__);
        }
        if (is_null($mandateCollectPaymentOnDate) || (is_array($mandateCollectPaymentOnDate) && empty($mandateCollectPaymentOnDate))) {
            unset($this->MandateCollectPaymentOnDate);
        } else {
            $this->MandateCollectPaymentOnDate = $mandateCollectPaymentOnDate;
        }
        return $this;
    }
    /**
     * Get MandateEffectiveOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMandateEffectiveOnly()
    {
        return isset($this->MandateEffectiveOnly) ? $this->MandateEffectiveOnly : null;
    }
    /**
     * Set MandateEffectiveOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mandateEffectiveOnly
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setMandateEffectiveOnly($mandateEffectiveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateEffectiveOnly) && !is_bool($mandateEffectiveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateEffectiveOnly, true), gettype($mandateEffectiveOnly)), __LINE__);
        }
        if (is_null($mandateEffectiveOnly) || (is_array($mandateEffectiveOnly) && empty($mandateEffectiveOnly))) {
            unset($this->MandateEffectiveOnly);
        } else {
            $this->MandateEffectiveOnly = $mandateEffectiveOnly;
        }
        return $this;
    }
    /**
     * Get MandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateId()
    {
        return isset($this->MandateId) ? $this->MandateId : null;
    }
    /**
     * Set MandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateId
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setMandateId($mandateId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateId) && !is_string($mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateId, true), gettype($mandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateId, true)), __LINE__);
        }
        if (is_null($mandateId) || (is_array($mandateId) && empty($mandateId))) {
            unset($this->MandateId);
        } else {
            $this->MandateId = $mandateId;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Payment_AddCustomDummyDirectDebitPaymentToBasketRequest
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
}
