<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AdHocRefundProductItemFilter StructType
 * @subpackage Structs
 */
class Payment_AdHocRefundProductItemFilter extends FilterEntity
{
    /**
     * The CommitDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateFrom;
    /**
     * The CommitDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateTo;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReasonId;
    /**
     * The SiteAmountGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmountGreaterThan;
    /**
     * The SiteAmountLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmountLessThan;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Payment.AdHocRefundProductItemFilter
     * @uses Payment_AdHocRefundProductItemFilter::setCommitDateFrom()
     * @uses Payment_AdHocRefundProductItemFilter::setCommitDateTo()
     * @uses Payment_AdHocRefundProductItemFilter::setReasonId()
     * @uses Payment_AdHocRefundProductItemFilter::setSiteAmountGreaterThan()
     * @uses Payment_AdHocRefundProductItemFilter::setSiteAmountLessThan()
     * @uses Payment_AdHocRefundProductItemFilter::setTransactionNumber()
     * @uses Payment_AdHocRefundProductItemFilter::setUserId()
     * @param string $commitDateFrom
     * @param string $commitDateTo
     * @param string $reasonId
     * @param \patest\StructType\Money $siteAmountGreaterThan
     * @param \patest\StructType\Money $siteAmountLessThan
     * @param int $transactionNumber
     * @param string $userId
     */
    public function __construct($commitDateFrom = null, $commitDateTo = null, $reasonId = null, \patest\StructType\Money $siteAmountGreaterThan = null, \patest\StructType\Money $siteAmountLessThan = null, $transactionNumber = null, $userId = null)
    {
        $this
            ->setCommitDateFrom($commitDateFrom)
            ->setCommitDateTo($commitDateTo)
            ->setReasonId($reasonId)
            ->setSiteAmountGreaterThan($siteAmountGreaterThan)
            ->setSiteAmountLessThan($siteAmountLessThan)
            ->setTransactionNumber($transactionNumber)
            ->setUserId($userId);
    }
    /**
     * Get CommitDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateFrom()
    {
        return isset($this->CommitDateFrom) ? $this->CommitDateFrom : null;
    }
    /**
     * Set CommitDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateFrom
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setCommitDateFrom($commitDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateFrom) && !is_string($commitDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateFrom, true), gettype($commitDateFrom)), __LINE__);
        }
        if (is_null($commitDateFrom) || (is_array($commitDateFrom) && empty($commitDateFrom))) {
            unset($this->CommitDateFrom);
        } else {
            $this->CommitDateFrom = $commitDateFrom;
        }
        return $this;
    }
    /**
     * Get CommitDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateTo()
    {
        return isset($this->CommitDateTo) ? $this->CommitDateTo : null;
    }
    /**
     * Set CommitDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateTo
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setCommitDateTo($commitDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateTo) && !is_string($commitDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateTo, true), gettype($commitDateTo)), __LINE__);
        }
        if (is_null($commitDateTo) || (is_array($commitDateTo) && empty($commitDateTo))) {
            unset($this->CommitDateTo);
        } else {
            $this->CommitDateTo = $commitDateTo;
        }
        return $this;
    }
    /**
     * Get ReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonId()
    {
        return isset($this->ReasonId) ? $this->ReasonId : null;
    }
    /**
     * Set ReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonId
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: string
        if (!is_null($reasonId) && !is_string($reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reasonId, true)), __LINE__);
        }
        if (is_null($reasonId) || (is_array($reasonId) && empty($reasonId))) {
            unset($this->ReasonId);
        } else {
            $this->ReasonId = $reasonId;
        }
        return $this;
    }
    /**
     * Get SiteAmountGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmountGreaterThan()
    {
        return isset($this->SiteAmountGreaterThan) ? $this->SiteAmountGreaterThan : null;
    }
    /**
     * Set SiteAmountGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmountGreaterThan
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setSiteAmountGreaterThan(\patest\StructType\Money $siteAmountGreaterThan = null)
    {
        if (is_null($siteAmountGreaterThan) || (is_array($siteAmountGreaterThan) && empty($siteAmountGreaterThan))) {
            unset($this->SiteAmountGreaterThan);
        } else {
            $this->SiteAmountGreaterThan = $siteAmountGreaterThan;
        }
        return $this;
    }
    /**
     * Get SiteAmountLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmountLessThan()
    {
        return isset($this->SiteAmountLessThan) ? $this->SiteAmountLessThan : null;
    }
    /**
     * Set SiteAmountLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmountLessThan
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setSiteAmountLessThan(\patest\StructType\Money $siteAmountLessThan = null)
    {
        if (is_null($siteAmountLessThan) || (is_array($siteAmountLessThan) && empty($siteAmountLessThan))) {
            unset($this->SiteAmountLessThan);
        } else {
            $this->SiteAmountLessThan = $siteAmountLessThan;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Payment_AdHocRefundProductItemFilter
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
