<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentItemData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentItemData
 * @subpackage Structs
 */
class PaymentItemData extends AbstractStructBase
{
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsertionMode;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentId;
    /**
     * The PaymentLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentLocalId;
    /**
     * Constructor method for PaymentItemData
     * @uses PaymentItemData::setInsertionMode()
     * @uses PaymentItemData::setPaymentId()
     * @uses PaymentItemData::setPaymentLocalId()
     * @param string $insertionMode
     * @param string $paymentId
     * @param int $paymentLocalId
     */
    public function __construct($insertionMode = null, $paymentId = null, $paymentLocalId = null)
    {
        $this
            ->setInsertionMode($insertionMode)
            ->setPaymentId($paymentId)
            ->setPaymentLocalId($paymentLocalId);
    }
    /**
     * Get InsertionMode value
     * @return string|null
     */
    public function getInsertionMode()
    {
        return $this->InsertionMode;
    }
    /**
     * Set InsertionMode value
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\PaymentItemData
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        $this->InsertionMode = $insertionMode;
        return $this;
    }
    /**
     * Get PaymentId value
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param string $paymentId
     * @return \patest\StructType\PaymentItemData
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentId) && !is_string($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentId, true)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PaymentLocalId value
     * @return int|null
     */
    public function getPaymentLocalId()
    {
        return $this->PaymentLocalId;
    }
    /**
     * Set PaymentLocalId value
     * @param int $paymentLocalId
     * @return \patest\StructType\PaymentItemData
     */
    public function setPaymentLocalId($paymentLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLocalId) && !(is_int($paymentLocalId) || ctype_digit($paymentLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentLocalId, true), gettype($paymentLocalId)), __LINE__);
        }
        $this->PaymentLocalId = $paymentLocalId;
        return $this;
    }
}
