<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableSubscriptionItemSpecificProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableSubscriptionItemSpecificProperties
 * @subpackage Structs
 */
class OverridableSubscriptionItemSpecificProperties extends AbstractStructBase
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The BonusEventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusEventCount;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCount;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * The TicketSchemesToEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo
     */
    public $TicketSchemesToEnroll;
    /**
     * Constructor method for OverridableSubscriptionItemSpecificProperties
     * @uses OverridableSubscriptionItemSpecificProperties::setAffectProperties()
     * @uses OverridableSubscriptionItemSpecificProperties::setAreaId()
     * @uses OverridableSubscriptionItemSpecificProperties::setBonusEventCount()
     * @uses OverridableSubscriptionItemSpecificProperties::setEndDate()
     * @uses OverridableSubscriptionItemSpecificProperties::setEventCount()
     * @uses OverridableSubscriptionItemSpecificProperties::setItemId()
     * @uses OverridableSubscriptionItemSpecificProperties::setPriceLevelId()
     * @uses OverridableSubscriptionItemSpecificProperties::setStartDate()
     * @uses OverridableSubscriptionItemSpecificProperties::setIsAutoRenewRequested()
     * @uses OverridableSubscriptionItemSpecificProperties::setSkipAutoRenewValidation()
     * @uses OverridableSubscriptionItemSpecificProperties::setTicketSchemesToEnroll()
     * @param string[] $affectProperties
     * @param string $areaId
     * @param int $bonusEventCount
     * @param string $endDate
     * @param int $eventCount
     * @param int $itemId
     * @param string $priceLevelId
     * @param string $startDate
     * @param bool $isAutoRenewRequested
     * @param bool $skipAutoRenewValidation
     * @param \patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo $ticketSchemesToEnroll
     */
    public function __construct(array $affectProperties = array(), $areaId = null, $bonusEventCount = null, $endDate = null, $eventCount = null, $itemId = null, $priceLevelId = null, $startDate = null, $isAutoRenewRequested = null, $skipAutoRenewValidation = null, \patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo $ticketSchemesToEnroll = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setAreaId($areaId)
            ->setBonusEventCount($bonusEventCount)
            ->setEndDate($endDate)
            ->setEventCount($eventCount)
            ->setItemId($itemId)
            ->setPriceLevelId($priceLevelId)
            ->setStartDate($startDate)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation)
            ->setTicketSchemesToEnroll($ticketSchemesToEnroll);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableSubscriptionItemProperties::valueIsValid($overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem)) {
                $invalidValues[] = is_object($overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem) ? get_class($overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem) : sprintf('%s(%s)', gettype($overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem), var_export($overridableSubscriptionItemSpecificPropertiesAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableSubscriptionItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableSubscriptionItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableSubscriptionItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableSubscriptionItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get BonusEventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusEventCount()
    {
        return isset($this->BonusEventCount) ? $this->BonusEventCount : null;
    }
    /**
     * Set BonusEventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusEventCount
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setBonusEventCount($bonusEventCount = null)
    {
        // validation for constraint: int
        if (!is_null($bonusEventCount) && !(is_int($bonusEventCount) || ctype_digit($bonusEventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusEventCount, true), gettype($bonusEventCount)), __LINE__);
        }
        if (is_null($bonusEventCount) || (is_array($bonusEventCount) && empty($bonusEventCount))) {
            unset($this->BonusEventCount);
        } else {
            $this->BonusEventCount = $bonusEventCount;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCount()
    {
        return isset($this->EventCount) ? $this->EventCount : null;
    }
    /**
     * Set EventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCount
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setEventCount($eventCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventCount) && !(is_int($eventCount) || ctype_digit($eventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCount, true), gettype($eventCount)), __LINE__);
        }
        if (is_null($eventCount) || (is_array($eventCount) && empty($eventCount))) {
            unset($this->EventCount);
        } else {
            $this->EventCount = $eventCount;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
    /**
     * Get TicketSchemesToEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo|null
     */
    public function getTicketSchemesToEnroll()
    {
        return isset($this->TicketSchemesToEnroll) ? $this->TicketSchemesToEnroll : null;
    }
    /**
     * Set TicketSchemesToEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo $ticketSchemesToEnroll
     * @return \patest\StructType\OverridableSubscriptionItemSpecificProperties
     */
    public function setTicketSchemesToEnroll(\patest\ArrayType\ArrayOfTicketSchemeToEnrollItemInfo $ticketSchemesToEnroll = null)
    {
        if (is_null($ticketSchemesToEnroll) || (is_array($ticketSchemesToEnroll) && empty($ticketSchemesToEnroll))) {
            unset($this->TicketSchemesToEnroll);
        } else {
            $this->TicketSchemesToEnroll = $ticketSchemesToEnroll;
        }
        return $this;
    }
}
