<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputColumnSpecification StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OutputColumnSpecification
 * @subpackage Structs
 */
class OutputColumnSpecification extends AbstractStructBase
{
    /**
     * The ColumnName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ColumnName;
    /**
     * The GroupByInstanceNameParts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $GroupByInstanceNameParts;
    /**
     * The InstanceFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\InstanceFilter
     */
    public $InstanceFilter;
    /**
     * The InstanceNameMeaning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceNameMeaning;
    /**
     * The IsAllowMissingPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowMissingPoints;
    /**
     * The IsGroupByTimePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupByTimePeriod;
    /**
     * The IsMasterTenantMonitor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMasterTenantMonitor;
    /**
     * The MonitorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MonitorName;
    /**
     * The NullValuesBehavior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NullValuesBehavior;
    /**
     * The Precision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Precision;
    /**
     * The Scale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Scale;
    /**
     * The ValueKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValueKind;
    /**
     * Constructor method for OutputColumnSpecification
     * @uses OutputColumnSpecification::setColumnName()
     * @uses OutputColumnSpecification::setGroupByInstanceNameParts()
     * @uses OutputColumnSpecification::setInstanceFilter()
     * @uses OutputColumnSpecification::setInstanceNameMeaning()
     * @uses OutputColumnSpecification::setIsAllowMissingPoints()
     * @uses OutputColumnSpecification::setIsGroupByTimePeriod()
     * @uses OutputColumnSpecification::setIsMasterTenantMonitor()
     * @uses OutputColumnSpecification::setMonitorName()
     * @uses OutputColumnSpecification::setNullValuesBehavior()
     * @uses OutputColumnSpecification::setPrecision()
     * @uses OutputColumnSpecification::setScale()
     * @uses OutputColumnSpecification::setValueKind()
     * @param string $columnName
     * @param string[] $groupByInstanceNameParts
     * @param \patest\StructType\InstanceFilter $instanceFilter
     * @param string $instanceNameMeaning
     * @param bool $isAllowMissingPoints
     * @param bool $isGroupByTimePeriod
     * @param bool $isMasterTenantMonitor
     * @param string $monitorName
     * @param string $nullValuesBehavior
     * @param string $precision
     * @param float $scale
     * @param string $valueKind
     */
    public function __construct($columnName = null, array $groupByInstanceNameParts = array(), \patest\StructType\InstanceFilter $instanceFilter = null, $instanceNameMeaning = null, $isAllowMissingPoints = null, $isGroupByTimePeriod = null, $isMasterTenantMonitor = null, $monitorName = null, $nullValuesBehavior = null, $precision = null, $scale = null, $valueKind = null)
    {
        $this
            ->setColumnName($columnName)
            ->setGroupByInstanceNameParts($groupByInstanceNameParts)
            ->setInstanceFilter($instanceFilter)
            ->setInstanceNameMeaning($instanceNameMeaning)
            ->setIsAllowMissingPoints($isAllowMissingPoints)
            ->setIsGroupByTimePeriod($isGroupByTimePeriod)
            ->setIsMasterTenantMonitor($isMasterTenantMonitor)
            ->setMonitorName($monitorName)
            ->setNullValuesBehavior($nullValuesBehavior)
            ->setPrecision($precision)
            ->setScale($scale)
            ->setValueKind($valueKind);
    }
    /**
     * Get ColumnName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColumnName()
    {
        return isset($this->ColumnName) ? $this->ColumnName : null;
    }
    /**
     * Set ColumnName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $columnName
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setColumnName($columnName = null)
    {
        // validation for constraint: string
        if (!is_null($columnName) && !is_string($columnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnName, true), gettype($columnName)), __LINE__);
        }
        if (is_null($columnName) || (is_array($columnName) && empty($columnName))) {
            unset($this->ColumnName);
        } else {
            $this->ColumnName = $columnName;
        }
        return $this;
    }
    /**
     * Get GroupByInstanceNameParts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getGroupByInstanceNameParts()
    {
        return isset($this->GroupByInstanceNameParts) ? $this->GroupByInstanceNameParts : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupByInstanceNameParts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupByInstanceNameParts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outputColumnSpecificationGroupByInstanceNamePartsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\InstanceNamePart::valueIsValid($outputColumnSpecificationGroupByInstanceNamePartsItem)) {
                $invalidValues[] = is_object($outputColumnSpecificationGroupByInstanceNamePartsItem) ? get_class($outputColumnSpecificationGroupByInstanceNamePartsItem) : sprintf('%s(%s)', gettype($outputColumnSpecificationGroupByInstanceNamePartsItem), var_export($outputColumnSpecificationGroupByInstanceNamePartsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstanceNamePart', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\InstanceNamePart::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupByInstanceNameParts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstanceNamePart::valueIsValid()
     * @uses \patest\EnumType\InstanceNamePart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $groupByInstanceNameParts
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setGroupByInstanceNameParts(array $groupByInstanceNameParts = array())
    {
        // validation for constraint: list
        if ('' !== ($groupByInstanceNamePartsArrayErrorMessage = self::validateGroupByInstanceNamePartsForArrayConstraintsFromSetGroupByInstanceNameParts($groupByInstanceNameParts))) {
            throw new \InvalidArgumentException($groupByInstanceNamePartsArrayErrorMessage, __LINE__);
        }
        if (is_null($groupByInstanceNameParts) || (is_array($groupByInstanceNameParts) && empty($groupByInstanceNameParts))) {
            unset($this->GroupByInstanceNameParts);
        } else {
            $this->GroupByInstanceNameParts = is_array($groupByInstanceNameParts) ? implode(' ', $groupByInstanceNameParts) : null;
        }
        return $this;
    }
    /**
     * Get InstanceFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\InstanceFilter|null
     */
    public function getInstanceFilter()
    {
        return isset($this->InstanceFilter) ? $this->InstanceFilter : null;
    }
    /**
     * Set InstanceFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\InstanceFilter $instanceFilter
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setInstanceFilter(\patest\StructType\InstanceFilter $instanceFilter = null)
    {
        if (is_null($instanceFilter) || (is_array($instanceFilter) && empty($instanceFilter))) {
            unset($this->InstanceFilter);
        } else {
            $this->InstanceFilter = $instanceFilter;
        }
        return $this;
    }
    /**
     * Get InstanceNameMeaning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceNameMeaning()
    {
        return isset($this->InstanceNameMeaning) ? $this->InstanceNameMeaning : null;
    }
    /**
     * Set InstanceNameMeaning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceNameMeaning
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setInstanceNameMeaning($instanceNameMeaning = null)
    {
        // validation for constraint: string
        if (!is_null($instanceNameMeaning) && !is_string($instanceNameMeaning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceNameMeaning, true), gettype($instanceNameMeaning)), __LINE__);
        }
        if (is_null($instanceNameMeaning) || (is_array($instanceNameMeaning) && empty($instanceNameMeaning))) {
            unset($this->InstanceNameMeaning);
        } else {
            $this->InstanceNameMeaning = $instanceNameMeaning;
        }
        return $this;
    }
    /**
     * Get IsAllowMissingPoints value
     * @return bool|null
     */
    public function getIsAllowMissingPoints()
    {
        return $this->IsAllowMissingPoints;
    }
    /**
     * Set IsAllowMissingPoints value
     * @param bool $isAllowMissingPoints
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setIsAllowMissingPoints($isAllowMissingPoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowMissingPoints) && !is_bool($isAllowMissingPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowMissingPoints, true), gettype($isAllowMissingPoints)), __LINE__);
        }
        $this->IsAllowMissingPoints = $isAllowMissingPoints;
        return $this;
    }
    /**
     * Get IsGroupByTimePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupByTimePeriod()
    {
        return isset($this->IsGroupByTimePeriod) ? $this->IsGroupByTimePeriod : null;
    }
    /**
     * Set IsGroupByTimePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupByTimePeriod
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setIsGroupByTimePeriod($isGroupByTimePeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupByTimePeriod) && !is_bool($isGroupByTimePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupByTimePeriod, true), gettype($isGroupByTimePeriod)), __LINE__);
        }
        if (is_null($isGroupByTimePeriod) || (is_array($isGroupByTimePeriod) && empty($isGroupByTimePeriod))) {
            unset($this->IsGroupByTimePeriod);
        } else {
            $this->IsGroupByTimePeriod = $isGroupByTimePeriod;
        }
        return $this;
    }
    /**
     * Get IsMasterTenantMonitor value
     * @return bool|null
     */
    public function getIsMasterTenantMonitor()
    {
        return $this->IsMasterTenantMonitor;
    }
    /**
     * Set IsMasterTenantMonitor value
     * @param bool $isMasterTenantMonitor
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setIsMasterTenantMonitor($isMasterTenantMonitor = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMasterTenantMonitor) && !is_bool($isMasterTenantMonitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMasterTenantMonitor, true), gettype($isMasterTenantMonitor)), __LINE__);
        }
        $this->IsMasterTenantMonitor = $isMasterTenantMonitor;
        return $this;
    }
    /**
     * Get MonitorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMonitorName()
    {
        return isset($this->MonitorName) ? $this->MonitorName : null;
    }
    /**
     * Set MonitorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $monitorName
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setMonitorName($monitorName = null)
    {
        // validation for constraint: string
        if (!is_null($monitorName) && !is_string($monitorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitorName, true), gettype($monitorName)), __LINE__);
        }
        if (is_null($monitorName) || (is_array($monitorName) && empty($monitorName))) {
            unset($this->MonitorName);
        } else {
            $this->MonitorName = $monitorName;
        }
        return $this;
    }
    /**
     * Get NullValuesBehavior value
     * @return string|null
     */
    public function getNullValuesBehavior()
    {
        return $this->NullValuesBehavior;
    }
    /**
     * Set NullValuesBehavior value
     * @uses \patest\EnumType\NullValuesBehavior::valueIsValid()
     * @uses \patest\EnumType\NullValuesBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nullValuesBehavior
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setNullValuesBehavior($nullValuesBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NullValuesBehavior::valueIsValid($nullValuesBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NullValuesBehavior', is_array($nullValuesBehavior) ? implode(', ', $nullValuesBehavior) : var_export($nullValuesBehavior, true), implode(', ', \patest\EnumType\NullValuesBehavior::getValidValues())), __LINE__);
        }
        $this->NullValuesBehavior = $nullValuesBehavior;
        return $this;
    }
    /**
     * Get Precision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrecision()
    {
        return isset($this->Precision) ? $this->Precision : null;
    }
    /**
     * Set Precision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $precision
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: string
        if (!is_null($precision) && !is_string($precision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($precision, true), gettype($precision)), __LINE__);
        }
        if (is_null($precision) || (is_array($precision) && empty($precision))) {
            unset($this->Precision);
        } else {
            $this->Precision = $precision;
        }
        return $this;
    }
    /**
     * Get Scale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getScale()
    {
        return isset($this->Scale) ? $this->Scale : null;
    }
    /**
     * Set Scale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $scale
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setScale($scale = null)
    {
        // validation for constraint: float
        if (!is_null($scale) && !(is_float($scale) || is_numeric($scale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scale, true), gettype($scale)), __LINE__);
        }
        if (is_null($scale) || (is_array($scale) && empty($scale))) {
            unset($this->Scale);
        } else {
            $this->Scale = $scale;
        }
        return $this;
    }
    /**
     * Get ValueKind value
     * @return string|null
     */
    public function getValueKind()
    {
        return $this->ValueKind;
    }
    /**
     * Set ValueKind value
     * @uses \patest\EnumType\GlobalMonitorValueKind::valueIsValid()
     * @uses \patest\EnumType\GlobalMonitorValueKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueKind
     * @return \patest\StructType\OutputColumnSpecification
     */
    public function setValueKind($valueKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GlobalMonitorValueKind::valueIsValid($valueKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GlobalMonitorValueKind', is_array($valueKind) ? implode(', ', $valueKind) : var_export($valueKind, true), implode(', ', \patest\EnumType\GlobalMonitorValueKind::getValidValues())), __LINE__);
        }
        $this->ValueKind = $valueKind;
        return $this;
    }
}
