<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderIdentity
 * @subpackage Structs
 */
class OrderIdentity extends AbstractStructBase
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The OrderItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderItemId;
    /**
     * The OrderPartId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderPartId;
    /**
     * Constructor method for OrderIdentity
     * @uses OrderIdentity::setOrderId()
     * @uses OrderIdentity::setOrderItemId()
     * @uses OrderIdentity::setOrderPartId()
     * @param string $orderId
     * @param string $orderItemId
     * @param string $orderPartId
     */
    public function __construct($orderId = null, $orderItemId = null, $orderPartId = null)
    {
        $this
            ->setOrderId($orderId)
            ->setOrderItemId($orderItemId)
            ->setOrderPartId($orderPartId);
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \patest\StructType\OrderIdentity
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get OrderItemId value
     * @return string|null
     */
    public function getOrderItemId()
    {
        return $this->OrderItemId;
    }
    /**
     * Set OrderItemId value
     * @param string $orderItemId
     * @return \patest\StructType\OrderIdentity
     */
    public function setOrderItemId($orderItemId = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemId) && !is_string($orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemId, true), gettype($orderItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderItemId, true)), __LINE__);
        }
        $this->OrderItemId = $orderItemId;
        return $this;
    }
    /**
     * Get OrderPartId value
     * @return string|null
     */
    public function getOrderPartId()
    {
        return $this->OrderPartId;
    }
    /**
     * Set OrderPartId value
     * @param string $orderPartId
     * @return \patest\StructType\OrderIdentity
     */
    public function setOrderPartId($orderPartId = null)
    {
        // validation for constraint: string
        if (!is_null($orderPartId) && !is_string($orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderPartId, true), gettype($orderPartId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderPartId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderPartId, true)), __LINE__);
        }
        $this->OrderPartId = $orderPartId;
        return $this;
    }
}
