<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenScanningSessionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpenScanningSessionRequest
 * @subpackage Structs
 */
class OpenScanningSessionRequest extends ExtensibleDataContract
{
    /**
     * The ForceReplaceExistingSession
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceReplaceExistingSession;
    /**
     * The OldScanningSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OldScanningSessionId;
    /**
     * The ScanningPointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningPointId;
    /**
     * The ScanningPointType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScanningPointType;
    /**
     * Constructor method for OpenScanningSessionRequest
     * @uses OpenScanningSessionRequest::setForceReplaceExistingSession()
     * @uses OpenScanningSessionRequest::setOldScanningSessionId()
     * @uses OpenScanningSessionRequest::setScanningPointId()
     * @uses OpenScanningSessionRequest::setScanningPointType()
     * @param bool $forceReplaceExistingSession
     * @param string $oldScanningSessionId
     * @param string $scanningPointId
     * @param string $scanningPointType
     */
    public function __construct($forceReplaceExistingSession = null, $oldScanningSessionId = null, $scanningPointId = null, $scanningPointType = null)
    {
        $this
            ->setForceReplaceExistingSession($forceReplaceExistingSession)
            ->setOldScanningSessionId($oldScanningSessionId)
            ->setScanningPointId($scanningPointId)
            ->setScanningPointType($scanningPointType);
    }
    /**
     * Get ForceReplaceExistingSession value
     * @return bool|null
     */
    public function getForceReplaceExistingSession()
    {
        return $this->ForceReplaceExistingSession;
    }
    /**
     * Set ForceReplaceExistingSession value
     * @param bool $forceReplaceExistingSession
     * @return \patest\StructType\OpenScanningSessionRequest
     */
    public function setForceReplaceExistingSession($forceReplaceExistingSession = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceReplaceExistingSession) && !is_bool($forceReplaceExistingSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceReplaceExistingSession, true), gettype($forceReplaceExistingSession)), __LINE__);
        }
        $this->ForceReplaceExistingSession = $forceReplaceExistingSession;
        return $this;
    }
    /**
     * Get OldScanningSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldScanningSessionId()
    {
        return isset($this->OldScanningSessionId) ? $this->OldScanningSessionId : null;
    }
    /**
     * Set OldScanningSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldScanningSessionId
     * @return \patest\StructType\OpenScanningSessionRequest
     */
    public function setOldScanningSessionId($oldScanningSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($oldScanningSessionId) && !is_string($oldScanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldScanningSessionId, true), gettype($oldScanningSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oldScanningSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oldScanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oldScanningSessionId, true)), __LINE__);
        }
        if (is_null($oldScanningSessionId) || (is_array($oldScanningSessionId) && empty($oldScanningSessionId))) {
            unset($this->OldScanningSessionId);
        } else {
            $this->OldScanningSessionId = $oldScanningSessionId;
        }
        return $this;
    }
    /**
     * Get ScanningPointId value
     * @return string|null
     */
    public function getScanningPointId()
    {
        return $this->ScanningPointId;
    }
    /**
     * Set ScanningPointId value
     * @param string $scanningPointId
     * @return \patest\StructType\OpenScanningSessionRequest
     */
    public function setScanningPointId($scanningPointId = null)
    {
        // validation for constraint: string
        if (!is_null($scanningPointId) && !is_string($scanningPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningPointId, true), gettype($scanningPointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningPointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningPointId, true)), __LINE__);
        }
        $this->ScanningPointId = $scanningPointId;
        return $this;
    }
    /**
     * Get ScanningPointType value
     * @return string|null
     */
    public function getScanningPointType()
    {
        return $this->ScanningPointType;
    }
    /**
     * Set ScanningPointType value
     * @uses \patest\EnumType\ScanningPointType::valueIsValid()
     * @uses \patest\EnumType\ScanningPointType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scanningPointType
     * @return \patest\StructType\OpenScanningSessionRequest
     */
    public function setScanningPointType($scanningPointType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanningPointType::valueIsValid($scanningPointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanningPointType', is_array($scanningPointType) ? implode(', ', $scanningPointType) : var_export($scanningPointType, true), implode(', ', \patest\EnumType\ScanningPointType::getValidValues())), __LINE__);
        }
        $this->ScanningPointType = $scanningPointType;
        return $this;
    }
}
