<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.UIAttributeItemInformation StructType
 * @subpackage Structs
 */
class Merchandise_UIAttributeItemInformation extends AnyEntity
{
    /**
     * The AttributeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttributeId;
    /**
     * The AttributeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeName;
    /**
     * The AttributeSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeSelection;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * Constructor method for Merchandise.UIAttributeItemInformation
     * @uses Merchandise_UIAttributeItemInformation::setAttributeId()
     * @uses Merchandise_UIAttributeItemInformation::setAttributeName()
     * @uses Merchandise_UIAttributeItemInformation::setAttributeSelection()
     * @uses Merchandise_UIAttributeItemInformation::setPrice()
     * @param string $attributeId
     * @param string $attributeName
     * @param string $attributeSelection
     * @param \patest\StructType\Money $price
     */
    public function __construct($attributeId = null, $attributeName = null, $attributeSelection = null, \patest\StructType\Money $price = null)
    {
        $this
            ->setAttributeId($attributeId)
            ->setAttributeName($attributeName)
            ->setAttributeSelection($attributeSelection)
            ->setPrice($price);
    }
    /**
     * Get AttributeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeId()
    {
        return isset($this->AttributeId) ? $this->AttributeId : null;
    }
    /**
     * Set AttributeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeId
     * @return \patest\StructType\Merchandise_UIAttributeItemInformation
     */
    public function setAttributeId($attributeId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeId) && !is_string($attributeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeId, true), gettype($attributeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attributeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attributeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attributeId, true)), __LINE__);
        }
        if (is_null($attributeId) || (is_array($attributeId) && empty($attributeId))) {
            unset($this->AttributeId);
        } else {
            $this->AttributeId = $attributeId;
        }
        return $this;
    }
    /**
     * Get AttributeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeName()
    {
        return isset($this->AttributeName) ? $this->AttributeName : null;
    }
    /**
     * Set AttributeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeName
     * @return \patest\StructType\Merchandise_UIAttributeItemInformation
     */
    public function setAttributeName($attributeName = null)
    {
        // validation for constraint: string
        if (!is_null($attributeName) && !is_string($attributeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeName, true), gettype($attributeName)), __LINE__);
        }
        if (is_null($attributeName) || (is_array($attributeName) && empty($attributeName))) {
            unset($this->AttributeName);
        } else {
            $this->AttributeName = $attributeName;
        }
        return $this;
    }
    /**
     * Get AttributeSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeSelection()
    {
        return isset($this->AttributeSelection) ? $this->AttributeSelection : null;
    }
    /**
     * Set AttributeSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeSelection
     * @return \patest\StructType\Merchandise_UIAttributeItemInformation
     */
    public function setAttributeSelection($attributeSelection = null)
    {
        // validation for constraint: string
        if (!is_null($attributeSelection) && !is_string($attributeSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeSelection, true), gettype($attributeSelection)), __LINE__);
        }
        if (is_null($attributeSelection) || (is_array($attributeSelection) && empty($attributeSelection))) {
            unset($this->AttributeSelection);
        } else {
            $this->AttributeSelection = $attributeSelection;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Merchandise_UIAttributeItemInformation
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
}
