<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.MerchandiseProductItem StructType
 * @subpackage Structs
 */
class Merchandise_MerchandiseProductItem extends Merchandise_Base
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The AddOnDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddOnDetails;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MerchandiseItemTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction
     */
    public $MerchandiseItemTransactions;
    /**
     * The PricePerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerUnit;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * Constructor method for Merchandise.MerchandiseProductItem
     * @uses Merchandise_MerchandiseProductItem::setActive()
     * @uses Merchandise_MerchandiseProductItem::setAddOnDetails()
     * @uses Merchandise_MerchandiseProductItem::setIsPrinting()
     * @uses Merchandise_MerchandiseProductItem::setMerchandiseId()
     * @uses Merchandise_MerchandiseProductItem::setMerchandiseItemTransactions()
     * @uses Merchandise_MerchandiseProductItem::setPricePerUnit()
     * @uses Merchandise_MerchandiseProductItem::setPrintCount()
     * @param bool $active
     * @param string $addOnDetails
     * @param bool $isPrinting
     * @param string $merchandiseId
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction $merchandiseItemTransactions
     * @param float $pricePerUnit
     * @param int $printCount
     */
    public function __construct($active = null, $addOnDetails = null, $isPrinting = null, $merchandiseId = null, \patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction $merchandiseItemTransactions = null, $pricePerUnit = null, $printCount = null)
    {
        $this
            ->setActive($active)
            ->setAddOnDetails($addOnDetails)
            ->setIsPrinting($isPrinting)
            ->setMerchandiseId($merchandiseId)
            ->setMerchandiseItemTransactions($merchandiseItemTransactions)
            ->setPricePerUnit($pricePerUnit)
            ->setPrintCount($printCount);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AddOnDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnDetails()
    {
        return isset($this->AddOnDetails) ? $this->AddOnDetails : null;
    }
    /**
     * Set AddOnDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnDetails
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setAddOnDetails($addOnDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addOnDetails) && !is_string($addOnDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnDetails, true), gettype($addOnDetails)), __LINE__);
        }
        if (is_null($addOnDetails) || (is_array($addOnDetails) && empty($addOnDetails))) {
            unset($this->AddOnDetails);
        } else {
            $this->AddOnDetails = $addOnDetails;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction|null
     */
    public function getMerchandiseItemTransactions()
    {
        return isset($this->MerchandiseItemTransactions) ? $this->MerchandiseItemTransactions : null;
    }
    /**
     * Set MerchandiseItemTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction $merchandiseItemTransactions
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setMerchandiseItemTransactions(\patest\StructType\RecordSetOfMerchandise_MerchandiseItemTransaction $merchandiseItemTransactions = null)
    {
        if (is_null($merchandiseItemTransactions) || (is_array($merchandiseItemTransactions) && empty($merchandiseItemTransactions))) {
            unset($this->MerchandiseItemTransactions);
        } else {
            $this->MerchandiseItemTransactions = $merchandiseItemTransactions;
        }
        return $this;
    }
    /**
     * Get PricePerUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return isset($this->PricePerUnit) ? $this->PricePerUnit : null;
    }
    /**
     * Set PricePerUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerUnit
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setPricePerUnit($pricePerUnit = null)
    {
        // validation for constraint: float
        if (!is_null($pricePerUnit) && !(is_float($pricePerUnit) || is_numeric($pricePerUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePerUnit, true), gettype($pricePerUnit)), __LINE__);
        }
        if (is_null($pricePerUnit) || (is_array($pricePerUnit) && empty($pricePerUnit))) {
            unset($this->PricePerUnit);
        } else {
            $this->PricePerUnit = $pricePerUnit;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Merchandise_MerchandiseProductItem
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
}
