<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.FormHeader StructType
 * @subpackage Structs
 */
class Merchandise_FormHeader extends Merchandise_MerchandiseBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CompanyDiscountValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyDiscountValue;
    /**
     * The CompanyGrandTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyGrandTotal;
    /**
     * The CompanyTotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalCost;
    /**
     * The CompanyTotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalEsv;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrencyId;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrencyRate;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerId;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryTypeId;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DiscountPercent;
    /**
     * The DiscountValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DiscountValue;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The FormDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormDate;
    /**
     * The FormLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_FormLine
     */
    public $FormLines;
    /**
     * The FormNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormNo;
    /**
     * The FormTemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormTemplateId;
    /**
     * The FormTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormTypeId;
    /**
     * The FromLocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FromLocationId;
    /**
     * The GrandTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $GrandTotal;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsConsignmentIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConsignmentIn;
    /**
     * The IsDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDelivered;
    /**
     * The IsEditMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEditMode;
    /**
     * The IsFinalized
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFinalized;
    /**
     * The IsOpeningStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpeningStock;
    /**
     * The IsPrintable
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrintable;
    /**
     * The IsPrintBarcodes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrintBarcodes;
    /**
     * The NumberOfLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfLines;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SalesTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesTransactionId;
    /**
     * The SalesTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesTransactionNumber;
    /**
     * The StockAdjReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockAdjReasonId;
    /**
     * The SupplierFormNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierFormNo;
    /**
     * The ToLocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ToLocationId;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCost;
    /**
     * The TotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsv;
    /**
     * The TotalQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalQuantity;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.FormHeader
     * @uses Merchandise_FormHeader::setAccountId()
     * @uses Merchandise_FormHeader::setAclSchemeId()
     * @uses Merchandise_FormHeader::setCompanyDiscountValue()
     * @uses Merchandise_FormHeader::setCompanyGrandTotal()
     * @uses Merchandise_FormHeader::setCompanyTotalCost()
     * @uses Merchandise_FormHeader::setCompanyTotalEsv()
     * @uses Merchandise_FormHeader::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_FormHeader::setCurrencyId()
     * @uses Merchandise_FormHeader::setCurrencyRate()
     * @uses Merchandise_FormHeader::setCustomerId()
     * @uses Merchandise_FormHeader::setDeliveryDate()
     * @uses Merchandise_FormHeader::setDeliveryTypeId()
     * @uses Merchandise_FormHeader::setDiscountPercent()
     * @uses Merchandise_FormHeader::setDiscountValue()
     * @uses Merchandise_FormHeader::setDueDate()
     * @uses Merchandise_FormHeader::setFormDate()
     * @uses Merchandise_FormHeader::setFormLines()
     * @uses Merchandise_FormHeader::setFormNo()
     * @uses Merchandise_FormHeader::setFormTemplateId()
     * @uses Merchandise_FormHeader::setFormTypeId()
     * @uses Merchandise_FormHeader::setFromLocationId()
     * @uses Merchandise_FormHeader::setGrandTotal()
     * @uses Merchandise_FormHeader::setIsActive()
     * @uses Merchandise_FormHeader::setIsConsignmentIn()
     * @uses Merchandise_FormHeader::setIsDelivered()
     * @uses Merchandise_FormHeader::setIsEditMode()
     * @uses Merchandise_FormHeader::setIsFinalized()
     * @uses Merchandise_FormHeader::setIsOpeningStock()
     * @uses Merchandise_FormHeader::setIsPrintable()
     * @uses Merchandise_FormHeader::setIsPrintBarcodes()
     * @uses Merchandise_FormHeader::setNumberOfLines()
     * @uses Merchandise_FormHeader::setOrganizationUnitId()
     * @uses Merchandise_FormHeader::setSalesTransactionId()
     * @uses Merchandise_FormHeader::setSalesTransactionNumber()
     * @uses Merchandise_FormHeader::setStockAdjReasonId()
     * @uses Merchandise_FormHeader::setSupplierFormNo()
     * @uses Merchandise_FormHeader::setToLocationId()
     * @uses Merchandise_FormHeader::setTotalCost()
     * @uses Merchandise_FormHeader::setTotalEsv()
     * @uses Merchandise_FormHeader::setTotalQuantity()
     * @uses Merchandise_FormHeader::setVisibleBySubordinates()
     * @param string $accountId
     * @param int $aclSchemeId
     * @param \patest\StructType\Money $companyDiscountValue
     * @param \patest\StructType\Money $companyGrandTotal
     * @param \patest\StructType\Money $companyTotalCost
     * @param \patest\StructType\Money $companyTotalEsv
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $currencyId
     * @param float $currencyRate
     * @param string $customerId
     * @param string $deliveryDate
     * @param string $deliveryTypeId
     * @param float $discountPercent
     * @param \patest\StructType\Money $discountValue
     * @param string $dueDate
     * @param string $formDate
     * @param \patest\StructType\RecordSetOfMerchandise_FormLine $formLines
     * @param string $formNo
     * @param string $formTemplateId
     * @param string $formTypeId
     * @param string $fromLocationId
     * @param \patest\StructType\Money $grandTotal
     * @param bool $isActive
     * @param bool $isConsignmentIn
     * @param bool $isDelivered
     * @param bool $isEditMode
     * @param bool $isFinalized
     * @param bool $isOpeningStock
     * @param bool $isPrintable
     * @param bool $isPrintBarcodes
     * @param int $numberOfLines
     * @param string $organizationUnitId
     * @param string $salesTransactionId
     * @param int $salesTransactionNumber
     * @param string $stockAdjReasonId
     * @param string $supplierFormNo
     * @param string $toLocationId
     * @param \patest\StructType\Money $totalCost
     * @param \patest\StructType\Money $totalEsv
     * @param float $totalQuantity
     * @param bool $visibleBySubordinates
     */
    public function __construct($accountId = null, $aclSchemeId = null, \patest\StructType\Money $companyDiscountValue = null, \patest\StructType\Money $companyGrandTotal = null, \patest\StructType\Money $companyTotalCost = null, \patest\StructType\Money $companyTotalEsv = null, $crossOrgUnitsAclSchemeId = null, $currencyId = null, $currencyRate = null, $customerId = null, $deliveryDate = null, $deliveryTypeId = null, $discountPercent = null, \patest\StructType\Money $discountValue = null, $dueDate = null, $formDate = null, \patest\StructType\RecordSetOfMerchandise_FormLine $formLines = null, $formNo = null, $formTemplateId = null, $formTypeId = null, $fromLocationId = null, \patest\StructType\Money $grandTotal = null, $isActive = null, $isConsignmentIn = null, $isDelivered = null, $isEditMode = null, $isFinalized = null, $isOpeningStock = null, $isPrintable = null, $isPrintBarcodes = null, $numberOfLines = null, $organizationUnitId = null, $salesTransactionId = null, $salesTransactionNumber = null, $stockAdjReasonId = null, $supplierFormNo = null, $toLocationId = null, \patest\StructType\Money $totalCost = null, \patest\StructType\Money $totalEsv = null, $totalQuantity = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAclSchemeId($aclSchemeId)
            ->setCompanyDiscountValue($companyDiscountValue)
            ->setCompanyGrandTotal($companyGrandTotal)
            ->setCompanyTotalCost($companyTotalCost)
            ->setCompanyTotalEsv($companyTotalEsv)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setCurrencyId($currencyId)
            ->setCurrencyRate($currencyRate)
            ->setCustomerId($customerId)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryTypeId($deliveryTypeId)
            ->setDiscountPercent($discountPercent)
            ->setDiscountValue($discountValue)
            ->setDueDate($dueDate)
            ->setFormDate($formDate)
            ->setFormLines($formLines)
            ->setFormNo($formNo)
            ->setFormTemplateId($formTemplateId)
            ->setFormTypeId($formTypeId)
            ->setFromLocationId($fromLocationId)
            ->setGrandTotal($grandTotal)
            ->setIsActive($isActive)
            ->setIsConsignmentIn($isConsignmentIn)
            ->setIsDelivered($isDelivered)
            ->setIsEditMode($isEditMode)
            ->setIsFinalized($isFinalized)
            ->setIsOpeningStock($isOpeningStock)
            ->setIsPrintable($isPrintable)
            ->setIsPrintBarcodes($isPrintBarcodes)
            ->setNumberOfLines($numberOfLines)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSalesTransactionId($salesTransactionId)
            ->setSalesTransactionNumber($salesTransactionNumber)
            ->setStockAdjReasonId($stockAdjReasonId)
            ->setSupplierFormNo($supplierFormNo)
            ->setToLocationId($toLocationId)
            ->setTotalCost($totalCost)
            ->setTotalEsv($totalEsv)
            ->setTotalQuantity($totalQuantity)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CompanyDiscountValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyDiscountValue()
    {
        return isset($this->CompanyDiscountValue) ? $this->CompanyDiscountValue : null;
    }
    /**
     * Set CompanyDiscountValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyDiscountValue
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCompanyDiscountValue(\patest\StructType\Money $companyDiscountValue = null)
    {
        if (is_null($companyDiscountValue) || (is_array($companyDiscountValue) && empty($companyDiscountValue))) {
            unset($this->CompanyDiscountValue);
        } else {
            $this->CompanyDiscountValue = $companyDiscountValue;
        }
        return $this;
    }
    /**
     * Get CompanyGrandTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyGrandTotal()
    {
        return isset($this->CompanyGrandTotal) ? $this->CompanyGrandTotal : null;
    }
    /**
     * Set CompanyGrandTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyGrandTotal
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCompanyGrandTotal(\patest\StructType\Money $companyGrandTotal = null)
    {
        if (is_null($companyGrandTotal) || (is_array($companyGrandTotal) && empty($companyGrandTotal))) {
            unset($this->CompanyGrandTotal);
        } else {
            $this->CompanyGrandTotal = $companyGrandTotal;
        }
        return $this;
    }
    /**
     * Get CompanyTotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalCost()
    {
        return isset($this->CompanyTotalCost) ? $this->CompanyTotalCost : null;
    }
    /**
     * Set CompanyTotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalCost
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCompanyTotalCost(\patest\StructType\Money $companyTotalCost = null)
    {
        if (is_null($companyTotalCost) || (is_array($companyTotalCost) && empty($companyTotalCost))) {
            unset($this->CompanyTotalCost);
        } else {
            $this->CompanyTotalCost = $companyTotalCost;
        }
        return $this;
    }
    /**
     * Get CompanyTotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalEsv()
    {
        return isset($this->CompanyTotalEsv) ? $this->CompanyTotalEsv : null;
    }
    /**
     * Set CompanyTotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalEsv
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCompanyTotalEsv(\patest\StructType\Money $companyTotalEsv = null)
    {
        if (is_null($companyTotalEsv) || (is_array($companyTotalEsv) && empty($companyTotalEsv))) {
            unset($this->CompanyTotalEsv);
        } else {
            $this->CompanyTotalEsv = $companyTotalEsv;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get CurrencyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyId()
    {
        return isset($this->CurrencyId) ? $this->CurrencyId : null;
    }
    /**
     * Set CurrencyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currencyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currencyId, true)), __LINE__);
        }
        if (is_null($currencyId) || (is_array($currencyId) && empty($currencyId))) {
            unset($this->CurrencyId);
        } else {
            $this->CurrencyId = $currencyId;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currencyRate
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyRate) && !(is_float($currencyRate) || is_numeric($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerId, true)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get DeliveryTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryTypeId()
    {
        return isset($this->DeliveryTypeId) ? $this->DeliveryTypeId : null;
    }
    /**
     * Set DeliveryTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryTypeId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setDeliveryTypeId($deliveryTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTypeId) && !is_string($deliveryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTypeId, true), gettype($deliveryTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryTypeId, true)), __LINE__);
        }
        if (is_null($deliveryTypeId) || (is_array($deliveryTypeId) && empty($deliveryTypeId))) {
            unset($this->DeliveryTypeId);
        } else {
            $this->DeliveryTypeId = $deliveryTypeId;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discountPercent
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get DiscountValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDiscountValue()
    {
        return isset($this->DiscountValue) ? $this->DiscountValue : null;
    }
    /**
     * Set DiscountValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $discountValue
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setDiscountValue(\patest\StructType\Money $discountValue = null)
    {
        if (is_null($discountValue) || (is_array($discountValue) && empty($discountValue))) {
            unset($this->DiscountValue);
        } else {
            $this->DiscountValue = $discountValue;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get FormDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormDate()
    {
        return isset($this->FormDate) ? $this->FormDate : null;
    }
    /**
     * Set FormDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formDate
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFormDate($formDate = null)
    {
        // validation for constraint: string
        if (!is_null($formDate) && !is_string($formDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formDate, true), gettype($formDate)), __LINE__);
        }
        if (is_null($formDate) || (is_array($formDate) && empty($formDate))) {
            unset($this->FormDate);
        } else {
            $this->FormDate = $formDate;
        }
        return $this;
    }
    /**
     * Get FormLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_FormLine|null
     */
    public function getFormLines()
    {
        return isset($this->FormLines) ? $this->FormLines : null;
    }
    /**
     * Set FormLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_FormLine $formLines
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFormLines(\patest\StructType\RecordSetOfMerchandise_FormLine $formLines = null)
    {
        if (is_null($formLines) || (is_array($formLines) && empty($formLines))) {
            unset($this->FormLines);
        } else {
            $this->FormLines = $formLines;
        }
        return $this;
    }
    /**
     * Get FormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormNo()
    {
        return isset($this->FormNo) ? $this->FormNo : null;
    }
    /**
     * Set FormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formNo
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFormNo($formNo = null)
    {
        // validation for constraint: string
        if (!is_null($formNo) && !is_string($formNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNo, true), gettype($formNo)), __LINE__);
        }
        if (is_null($formNo) || (is_array($formNo) && empty($formNo))) {
            unset($this->FormNo);
        } else {
            $this->FormNo = $formNo;
        }
        return $this;
    }
    /**
     * Get FormTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormTemplateId()
    {
        return isset($this->FormTemplateId) ? $this->FormTemplateId : null;
    }
    /**
     * Set FormTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formTemplateId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFormTemplateId($formTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($formTemplateId) && !is_string($formTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formTemplateId, true), gettype($formTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formTemplateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formTemplateId, true)), __LINE__);
        }
        if (is_null($formTemplateId) || (is_array($formTemplateId) && empty($formTemplateId))) {
            unset($this->FormTemplateId);
        } else {
            $this->FormTemplateId = $formTemplateId;
        }
        return $this;
    }
    /**
     * Get FormTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormTypeId()
    {
        return isset($this->FormTypeId) ? $this->FormTypeId : null;
    }
    /**
     * Set FormTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formTypeId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFormTypeId($formTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($formTypeId) && !is_string($formTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formTypeId, true), gettype($formTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formTypeId, true)), __LINE__);
        }
        if (is_null($formTypeId) || (is_array($formTypeId) && empty($formTypeId))) {
            unset($this->FormTypeId);
        } else {
            $this->FormTypeId = $formTypeId;
        }
        return $this;
    }
    /**
     * Get FromLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromLocationId()
    {
        return isset($this->FromLocationId) ? $this->FromLocationId : null;
    }
    /**
     * Set FromLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromLocationId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setFromLocationId($fromLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($fromLocationId) && !is_string($fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromLocationId, true), gettype($fromLocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fromLocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fromLocationId, true)), __LINE__);
        }
        if (is_null($fromLocationId) || (is_array($fromLocationId) && empty($fromLocationId))) {
            unset($this->FromLocationId);
        } else {
            $this->FromLocationId = $fromLocationId;
        }
        return $this;
    }
    /**
     * Get GrandTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getGrandTotal()
    {
        return isset($this->GrandTotal) ? $this->GrandTotal : null;
    }
    /**
     * Set GrandTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $grandTotal
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setGrandTotal(\patest\StructType\Money $grandTotal = null)
    {
        if (is_null($grandTotal) || (is_array($grandTotal) && empty($grandTotal))) {
            unset($this->GrandTotal);
        } else {
            $this->GrandTotal = $grandTotal;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsConsignmentIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConsignmentIn()
    {
        return isset($this->IsConsignmentIn) ? $this->IsConsignmentIn : null;
    }
    /**
     * Set IsConsignmentIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConsignmentIn
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsConsignmentIn($isConsignmentIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConsignmentIn) && !is_bool($isConsignmentIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConsignmentIn, true), gettype($isConsignmentIn)), __LINE__);
        }
        if (is_null($isConsignmentIn) || (is_array($isConsignmentIn) && empty($isConsignmentIn))) {
            unset($this->IsConsignmentIn);
        } else {
            $this->IsConsignmentIn = $isConsignmentIn;
        }
        return $this;
    }
    /**
     * Get IsDelivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDelivered()
    {
        return isset($this->IsDelivered) ? $this->IsDelivered : null;
    }
    /**
     * Set IsDelivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDelivered
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsDelivered($isDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDelivered) && !is_bool($isDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDelivered, true), gettype($isDelivered)), __LINE__);
        }
        if (is_null($isDelivered) || (is_array($isDelivered) && empty($isDelivered))) {
            unset($this->IsDelivered);
        } else {
            $this->IsDelivered = $isDelivered;
        }
        return $this;
    }
    /**
     * Get IsEditMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEditMode()
    {
        return isset($this->IsEditMode) ? $this->IsEditMode : null;
    }
    /**
     * Set IsEditMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEditMode
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsEditMode($isEditMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditMode) && !is_bool($isEditMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditMode, true), gettype($isEditMode)), __LINE__);
        }
        if (is_null($isEditMode) || (is_array($isEditMode) && empty($isEditMode))) {
            unset($this->IsEditMode);
        } else {
            $this->IsEditMode = $isEditMode;
        }
        return $this;
    }
    /**
     * Get IsFinalized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFinalized()
    {
        return isset($this->IsFinalized) ? $this->IsFinalized : null;
    }
    /**
     * Set IsFinalized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFinalized
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsFinalized($isFinalized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinalized) && !is_bool($isFinalized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFinalized, true), gettype($isFinalized)), __LINE__);
        }
        if (is_null($isFinalized) || (is_array($isFinalized) && empty($isFinalized))) {
            unset($this->IsFinalized);
        } else {
            $this->IsFinalized = $isFinalized;
        }
        return $this;
    }
    /**
     * Get IsOpeningStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpeningStock()
    {
        return isset($this->IsOpeningStock) ? $this->IsOpeningStock : null;
    }
    /**
     * Set IsOpeningStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpeningStock
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsOpeningStock($isOpeningStock = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpeningStock) && !is_bool($isOpeningStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpeningStock, true), gettype($isOpeningStock)), __LINE__);
        }
        if (is_null($isOpeningStock) || (is_array($isOpeningStock) && empty($isOpeningStock))) {
            unset($this->IsOpeningStock);
        } else {
            $this->IsOpeningStock = $isOpeningStock;
        }
        return $this;
    }
    /**
     * Get IsPrintable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrintable()
    {
        return isset($this->IsPrintable) ? $this->IsPrintable : null;
    }
    /**
     * Set IsPrintable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrintable
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsPrintable($isPrintable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintable) && !is_bool($isPrintable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintable, true), gettype($isPrintable)), __LINE__);
        }
        if (is_null($isPrintable) || (is_array($isPrintable) && empty($isPrintable))) {
            unset($this->IsPrintable);
        } else {
            $this->IsPrintable = $isPrintable;
        }
        return $this;
    }
    /**
     * Get IsPrintBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrintBarcodes()
    {
        return isset($this->IsPrintBarcodes) ? $this->IsPrintBarcodes : null;
    }
    /**
     * Set IsPrintBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrintBarcodes
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setIsPrintBarcodes($isPrintBarcodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintBarcodes) && !is_bool($isPrintBarcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintBarcodes, true), gettype($isPrintBarcodes)), __LINE__);
        }
        if (is_null($isPrintBarcodes) || (is_array($isPrintBarcodes) && empty($isPrintBarcodes))) {
            unset($this->IsPrintBarcodes);
        } else {
            $this->IsPrintBarcodes = $isPrintBarcodes;
        }
        return $this;
    }
    /**
     * Get NumberOfLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfLines()
    {
        return isset($this->NumberOfLines) ? $this->NumberOfLines : null;
    }
    /**
     * Set NumberOfLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfLines
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setNumberOfLines($numberOfLines = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLines) && !(is_int($numberOfLines) || ctype_digit($numberOfLines))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfLines, true), gettype($numberOfLines)), __LINE__);
        }
        if (is_null($numberOfLines) || (is_array($numberOfLines) && empty($numberOfLines))) {
            unset($this->NumberOfLines);
        } else {
            $this->NumberOfLines = $numberOfLines;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SalesTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesTransactionId()
    {
        return isset($this->SalesTransactionId) ? $this->SalesTransactionId : null;
    }
    /**
     * Set SalesTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesTransactionId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setSalesTransactionId($salesTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($salesTransactionId) && !is_string($salesTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesTransactionId, true), gettype($salesTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesTransactionId, true)), __LINE__);
        }
        if (is_null($salesTransactionId) || (is_array($salesTransactionId) && empty($salesTransactionId))) {
            unset($this->SalesTransactionId);
        } else {
            $this->SalesTransactionId = $salesTransactionId;
        }
        return $this;
    }
    /**
     * Get SalesTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesTransactionNumber()
    {
        return isset($this->SalesTransactionNumber) ? $this->SalesTransactionNumber : null;
    }
    /**
     * Set SalesTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesTransactionNumber
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setSalesTransactionNumber($salesTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($salesTransactionNumber) && !(is_int($salesTransactionNumber) || ctype_digit($salesTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesTransactionNumber, true), gettype($salesTransactionNumber)), __LINE__);
        }
        if (is_null($salesTransactionNumber) || (is_array($salesTransactionNumber) && empty($salesTransactionNumber))) {
            unset($this->SalesTransactionNumber);
        } else {
            $this->SalesTransactionNumber = $salesTransactionNumber;
        }
        return $this;
    }
    /**
     * Get StockAdjReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockAdjReasonId()
    {
        return isset($this->StockAdjReasonId) ? $this->StockAdjReasonId : null;
    }
    /**
     * Set StockAdjReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockAdjReasonId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setStockAdjReasonId($stockAdjReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($stockAdjReasonId) && !is_string($stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockAdjReasonId, true), gettype($stockAdjReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockAdjReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockAdjReasonId, true)), __LINE__);
        }
        if (is_null($stockAdjReasonId) || (is_array($stockAdjReasonId) && empty($stockAdjReasonId))) {
            unset($this->StockAdjReasonId);
        } else {
            $this->StockAdjReasonId = $stockAdjReasonId;
        }
        return $this;
    }
    /**
     * Get SupplierFormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierFormNo()
    {
        return isset($this->SupplierFormNo) ? $this->SupplierFormNo : null;
    }
    /**
     * Set SupplierFormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierFormNo
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setSupplierFormNo($supplierFormNo = null)
    {
        // validation for constraint: string
        if (!is_null($supplierFormNo) && !is_string($supplierFormNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierFormNo, true), gettype($supplierFormNo)), __LINE__);
        }
        if (is_null($supplierFormNo) || (is_array($supplierFormNo) && empty($supplierFormNo))) {
            unset($this->SupplierFormNo);
        } else {
            $this->SupplierFormNo = $supplierFormNo;
        }
        return $this;
    }
    /**
     * Get ToLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToLocationId()
    {
        return isset($this->ToLocationId) ? $this->ToLocationId : null;
    }
    /**
     * Set ToLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toLocationId
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setToLocationId($toLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($toLocationId) && !is_string($toLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toLocationId, true), gettype($toLocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($toLocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $toLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($toLocationId, true)), __LINE__);
        }
        if (is_null($toLocationId) || (is_array($toLocationId) && empty($toLocationId))) {
            unset($this->ToLocationId);
        } else {
            $this->ToLocationId = $toLocationId;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCost
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setTotalCost(\patest\StructType\Money $totalCost = null)
    {
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
    /**
     * Get TotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsv()
    {
        return isset($this->TotalEsv) ? $this->TotalEsv : null;
    }
    /**
     * Set TotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsv
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setTotalEsv(\patest\StructType\Money $totalEsv = null)
    {
        if (is_null($totalEsv) || (is_array($totalEsv) && empty($totalEsv))) {
            unset($this->TotalEsv);
        } else {
            $this->TotalEsv = $totalEsv;
        }
        return $this;
    }
    /**
     * Get TotalQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalQuantity()
    {
        return isset($this->TotalQuantity) ? $this->TotalQuantity : null;
    }
    /**
     * Set TotalQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalQuantity
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setTotalQuantity($totalQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalQuantity) && !(is_float($totalQuantity) || is_numeric($totalQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalQuantity, true), gettype($totalQuantity)), __LINE__);
        }
        if (is_null($totalQuantity) || (is_array($totalQuantity) && empty($totalQuantity))) {
            unset($this->TotalQuantity);
        } else {
            $this->TotalQuantity = $totalQuantity;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_FormHeader
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
