<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipSearchData StructType
 * @subpackage Structs
 */
class Membership_MembershipSearchData extends Membership_MembershipTransactionItem
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The IsRenewed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRenewed;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MembershipName;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Membership.MembershipSearchData
     * @uses Membership_MembershipSearchData::setClientId()
     * @uses Membership_MembershipSearchData::setEndDate()
     * @uses Membership_MembershipSearchData::setIsRenewed()
     * @uses Membership_MembershipSearchData::setMembershipDefinitionId()
     * @uses Membership_MembershipSearchData::setMembershipName()
     * @uses Membership_MembershipSearchData::setMembershipNumber()
     * @uses Membership_MembershipSearchData::setOrganizationUnitId()
     * @uses Membership_MembershipSearchData::setPrintCount()
     * @uses Membership_MembershipSearchData::setStartDate()
     * @uses Membership_MembershipSearchData::setStatus()
     * @param string $clientId
     * @param string $endDate
     * @param bool $isRenewed
     * @param string $membershipDefinitionId
     * @param \patest\StructType\GlobalString $membershipName
     * @param string $membershipNumber
     * @param string $organizationUnitId
     * @param int $printCount
     * @param string $startDate
     * @param string $status
     */
    public function __construct($clientId = null, $endDate = null, $isRenewed = null, $membershipDefinitionId = null, \patest\StructType\GlobalString $membershipName = null, $membershipNumber = null, $organizationUnitId = null, $printCount = null, $startDate = null, $status = null)
    {
        $this
            ->setClientId($clientId)
            ->setEndDate($endDate)
            ->setIsRenewed($isRenewed)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipName($membershipName)
            ->setMembershipNumber($membershipNumber)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrintCount($printCount)
            ->setStartDate($startDate)
            ->setStatus($status);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get IsRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRenewed()
    {
        return isset($this->IsRenewed) ? $this->IsRenewed : null;
    }
    /**
     * Set IsRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRenewed
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setIsRenewed($isRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewed) && !is_bool($isRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRenewed, true), gettype($isRenewed)), __LINE__);
        }
        if (is_null($isRenewed) || (is_array($isRenewed) && empty($isRenewed))) {
            unset($this->IsRenewed);
        } else {
            $this->IsRenewed = $isRenewed;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMembershipName()
    {
        return isset($this->MembershipName) ? $this->MembershipName : null;
    }
    /**
     * Set MembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $membershipName
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setMembershipName(\patest\StructType\GlobalString $membershipName = null)
    {
        if (is_null($membershipName) || (is_array($membershipName) && empty($membershipName))) {
            unset($this->MembershipName);
        } else {
            $this->MembershipName = $membershipName;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Membership_MembershipSearchData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
