<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipExtended StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Membership.MembershipExtended
 * @subpackage Structs
 */
class Membership_MembershipExtended extends Membership_Membership
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlProviderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProviderId;
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The AllocatedBenefitsNum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedBenefitsNum;
    /**
     * The BackwardTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransaction;
    /**
     * The CanAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoRenew;
    /**
     * The CanRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRenew;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The ExtrasPriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtrasPriceTypeId;
    /**
     * The HasHistory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasHistory;
    /**
     * The IsAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenew;
    /**
     * The IsRelatedclient
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelatedclient;
    /**
     * The JointDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointDetails;
    /**
     * The JointOwnersIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointOwnersIds;
    /**
     * The JointPlanSummary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointPlanSummary;
    /**
     * The MembershipName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MembershipName;
    /**
     * The NumberOfExtras
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtras;
    /**
     * The NumberOfOwners
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwners;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The OwnersPriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnersPriceTypeId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The PurchaserCanModify
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PurchaserCanModify;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserName;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * The TransactionItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionItemId;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UsedBenefitsNum
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UsedBenefitsNum;
    /**
     * The ValidStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidStatus;
    /**
     * Constructor method for Membership.MembershipExtended
     * @uses Membership_MembershipExtended::setAccessCardId()
     * @uses Membership_MembershipExtended::setAccessControlProviderId()
     * @uses Membership_MembershipExtended::setAgencyAccountId()
     * @uses Membership_MembershipExtended::setAgencyName()
     * @uses Membership_MembershipExtended::setAllocatedBenefitsNum()
     * @uses Membership_MembershipExtended::setBackwardTransaction()
     * @uses Membership_MembershipExtended::setCanAutoRenew()
     * @uses Membership_MembershipExtended::setCanRenew()
     * @uses Membership_MembershipExtended::setCommitDate()
     * @uses Membership_MembershipExtended::setExtraInfo()
     * @uses Membership_MembershipExtended::setExtrasPriceTypeId()
     * @uses Membership_MembershipExtended::setHasHistory()
     * @uses Membership_MembershipExtended::setIsAutoRenew()
     * @uses Membership_MembershipExtended::setIsRelatedclient()
     * @uses Membership_MembershipExtended::setJointDetails()
     * @uses Membership_MembershipExtended::setJointOwnersIds()
     * @uses Membership_MembershipExtended::setJointPlanSummary()
     * @uses Membership_MembershipExtended::setMembershipName()
     * @uses Membership_MembershipExtended::setNumberOfExtras()
     * @uses Membership_MembershipExtended::setNumberOfOwners()
     * @uses Membership_MembershipExtended::setOwnerName()
     * @uses Membership_MembershipExtended::setOwnersPriceTypeId()
     * @uses Membership_MembershipExtended::setPriceTypeId()
     * @uses Membership_MembershipExtended::setPriceTypeName()
     * @uses Membership_MembershipExtended::setPurchaserCanModify()
     * @uses Membership_MembershipExtended::setPurchaserClientId()
     * @uses Membership_MembershipExtended::setPurchaserName()
     * @uses Membership_MembershipExtended::setRenewOfInstanceId()
     * @uses Membership_MembershipExtended::setTransactionItemId()
     * @uses Membership_MembershipExtended::setTransactionNotes()
     * @uses Membership_MembershipExtended::setTransactionNumber()
     * @uses Membership_MembershipExtended::setUsedBenefitsNum()
     * @uses Membership_MembershipExtended::setValidStatus()
     * @param string $accessCardId
     * @param string $accessControlProviderId
     * @param string $agencyAccountId
     * @param string $agencyName
     * @param int $allocatedBenefitsNum
     * @param string $backwardTransaction
     * @param bool $canAutoRenew
     * @param bool $canRenew
     * @param string $commitDate
     * @param string $extraInfo
     * @param string $extrasPriceTypeId
     * @param bool $hasHistory
     * @param bool $isAutoRenew
     * @param bool $isRelatedclient
     * @param string $jointDetails
     * @param string $jointOwnersIds
     * @param string $jointPlanSummary
     * @param \patest\StructType\GlobalString $membershipName
     * @param int $numberOfExtras
     * @param int $numberOfOwners
     * @param string $ownerName
     * @param string $ownersPriceTypeId
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param bool $purchaserCanModify
     * @param string $purchaserClientId
     * @param string $purchaserName
     * @param string $renewOfInstanceId
     * @param int $transactionItemId
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $usedBenefitsNum
     * @param bool $validStatus
     */
    public function __construct($accessCardId = null, $accessControlProviderId = null, $agencyAccountId = null, $agencyName = null, $allocatedBenefitsNum = null, $backwardTransaction = null, $canAutoRenew = null, $canRenew = null, $commitDate = null, $extraInfo = null, $extrasPriceTypeId = null, $hasHistory = null, $isAutoRenew = null, $isRelatedclient = null, $jointDetails = null, $jointOwnersIds = null, $jointPlanSummary = null, \patest\StructType\GlobalString $membershipName = null, $numberOfExtras = null, $numberOfOwners = null, $ownerName = null, $ownersPriceTypeId = null, $priceTypeId = null, $priceTypeName = null, $purchaserCanModify = null, $purchaserClientId = null, $purchaserName = null, $renewOfInstanceId = null, $transactionItemId = null, $transactionNotes = null, $transactionNumber = null, $usedBenefitsNum = null, $validStatus = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlProviderId($accessControlProviderId)
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyName($agencyName)
            ->setAllocatedBenefitsNum($allocatedBenefitsNum)
            ->setBackwardTransaction($backwardTransaction)
            ->setCanAutoRenew($canAutoRenew)
            ->setCanRenew($canRenew)
            ->setCommitDate($commitDate)
            ->setExtraInfo($extraInfo)
            ->setExtrasPriceTypeId($extrasPriceTypeId)
            ->setHasHistory($hasHistory)
            ->setIsAutoRenew($isAutoRenew)
            ->setIsRelatedclient($isRelatedclient)
            ->setJointDetails($jointDetails)
            ->setJointOwnersIds($jointOwnersIds)
            ->setJointPlanSummary($jointPlanSummary)
            ->setMembershipName($membershipName)
            ->setNumberOfExtras($numberOfExtras)
            ->setNumberOfOwners($numberOfOwners)
            ->setOwnerName($ownerName)
            ->setOwnersPriceTypeId($ownersPriceTypeId)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setPurchaserCanModify($purchaserCanModify)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserName($purchaserName)
            ->setRenewOfInstanceId($renewOfInstanceId)
            ->setTransactionItemId($transactionItemId)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setUsedBenefitsNum($usedBenefitsNum)
            ->setValidStatus($validStatus);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProviderId()
    {
        return isset($this->AccessControlProviderId) ? $this->AccessControlProviderId : null;
    }
    /**
     * Set AccessControlProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProviderId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setAccessControlProviderId($accessControlProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProviderId) && !is_string($accessControlProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProviderId, true), gettype($accessControlProviderId)), __LINE__);
        }
        if (is_null($accessControlProviderId) || (is_array($accessControlProviderId) && empty($accessControlProviderId))) {
            unset($this->AccessControlProviderId);
        } else {
            $this->AccessControlProviderId = $accessControlProviderId;
        }
        return $this;
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyName()
    {
        return isset($this->AgencyName) ? $this->AgencyName : null;
    }
    /**
     * Set AgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyName
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        if (is_null($agencyName) || (is_array($agencyName) && empty($agencyName))) {
            unset($this->AgencyName);
        } else {
            $this->AgencyName = $agencyName;
        }
        return $this;
    }
    /**
     * Get AllocatedBenefitsNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedBenefitsNum()
    {
        return isset($this->AllocatedBenefitsNum) ? $this->AllocatedBenefitsNum : null;
    }
    /**
     * Set AllocatedBenefitsNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedBenefitsNum
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setAllocatedBenefitsNum($allocatedBenefitsNum = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedBenefitsNum) && !(is_int($allocatedBenefitsNum) || ctype_digit($allocatedBenefitsNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedBenefitsNum, true), gettype($allocatedBenefitsNum)), __LINE__);
        }
        if (is_null($allocatedBenefitsNum) || (is_array($allocatedBenefitsNum) && empty($allocatedBenefitsNum))) {
            unset($this->AllocatedBenefitsNum);
        } else {
            $this->AllocatedBenefitsNum = $allocatedBenefitsNum;
        }
        return $this;
    }
    /**
     * Get BackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransaction()
    {
        return isset($this->BackwardTransaction) ? $this->BackwardTransaction : null;
    }
    /**
     * Set BackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransaction
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setBackwardTransaction($backwardTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransaction) && !is_string($backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransaction, true), gettype($backwardTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransaction, true)), __LINE__);
        }
        if (is_null($backwardTransaction) || (is_array($backwardTransaction) && empty($backwardTransaction))) {
            unset($this->BackwardTransaction);
        } else {
            $this->BackwardTransaction = $backwardTransaction;
        }
        return $this;
    }
    /**
     * Get CanAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoRenew()
    {
        return isset($this->CanAutoRenew) ? $this->CanAutoRenew : null;
    }
    /**
     * Set CanAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoRenew
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setCanAutoRenew($canAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoRenew) && !is_bool($canAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoRenew, true), gettype($canAutoRenew)), __LINE__);
        }
        if (is_null($canAutoRenew) || (is_array($canAutoRenew) && empty($canAutoRenew))) {
            unset($this->CanAutoRenew);
        } else {
            $this->CanAutoRenew = $canAutoRenew;
        }
        return $this;
    }
    /**
     * Get CanRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRenew()
    {
        return isset($this->CanRenew) ? $this->CanRenew : null;
    }
    /**
     * Set CanRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRenew
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setCanRenew($canRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRenew) && !is_bool($canRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRenew, true), gettype($canRenew)), __LINE__);
        }
        if (is_null($canRenew) || (is_array($canRenew) && empty($canRenew))) {
            unset($this->CanRenew);
        } else {
            $this->CanRenew = $canRenew;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get ExtrasPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeId()
    {
        return isset($this->ExtrasPriceTypeId) ? $this->ExtrasPriceTypeId : null;
    }
    /**
     * Set ExtrasPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setExtrasPriceTypeId($extrasPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeId) && !is_string($extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeId, true), gettype($extrasPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extrasPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extrasPriceTypeId, true)), __LINE__);
        }
        if (is_null($extrasPriceTypeId) || (is_array($extrasPriceTypeId) && empty($extrasPriceTypeId))) {
            unset($this->ExtrasPriceTypeId);
        } else {
            $this->ExtrasPriceTypeId = $extrasPriceTypeId;
        }
        return $this;
    }
    /**
     * Get HasHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasHistory()
    {
        return isset($this->HasHistory) ? $this->HasHistory : null;
    }
    /**
     * Set HasHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasHistory
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setHasHistory($hasHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHistory) && !is_bool($hasHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHistory, true), gettype($hasHistory)), __LINE__);
        }
        if (is_null($hasHistory) || (is_array($hasHistory) && empty($hasHistory))) {
            unset($this->HasHistory);
        } else {
            $this->HasHistory = $hasHistory;
        }
        return $this;
    }
    /**
     * Get IsAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenew()
    {
        return isset($this->IsAutoRenew) ? $this->IsAutoRenew : null;
    }
    /**
     * Set IsAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenew
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setIsAutoRenew($isAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenew) && !is_bool($isAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenew, true), gettype($isAutoRenew)), __LINE__);
        }
        if (is_null($isAutoRenew) || (is_array($isAutoRenew) && empty($isAutoRenew))) {
            unset($this->IsAutoRenew);
        } else {
            $this->IsAutoRenew = $isAutoRenew;
        }
        return $this;
    }
    /**
     * Get IsRelatedclient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelatedclient()
    {
        return isset($this->IsRelatedclient) ? $this->IsRelatedclient : null;
    }
    /**
     * Set IsRelatedclient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelatedclient
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setIsRelatedclient($isRelatedclient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelatedclient) && !is_bool($isRelatedclient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelatedclient, true), gettype($isRelatedclient)), __LINE__);
        }
        if (is_null($isRelatedclient) || (is_array($isRelatedclient) && empty($isRelatedclient))) {
            unset($this->IsRelatedclient);
        } else {
            $this->IsRelatedclient = $isRelatedclient;
        }
        return $this;
    }
    /**
     * Get JointDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointDetails()
    {
        return isset($this->JointDetails) ? $this->JointDetails : null;
    }
    /**
     * Set JointDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointDetails
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setJointDetails($jointDetails = null)
    {
        // validation for constraint: string
        if (!is_null($jointDetails) && !is_string($jointDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointDetails, true), gettype($jointDetails)), __LINE__);
        }
        if (is_null($jointDetails) || (is_array($jointDetails) && empty($jointDetails))) {
            unset($this->JointDetails);
        } else {
            $this->JointDetails = $jointDetails;
        }
        return $this;
    }
    /**
     * Get JointOwnersIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointOwnersIds()
    {
        return isset($this->JointOwnersIds) ? $this->JointOwnersIds : null;
    }
    /**
     * Set JointOwnersIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointOwnersIds
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setJointOwnersIds($jointOwnersIds = null)
    {
        // validation for constraint: string
        if (!is_null($jointOwnersIds) && !is_string($jointOwnersIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointOwnersIds, true), gettype($jointOwnersIds)), __LINE__);
        }
        if (is_null($jointOwnersIds) || (is_array($jointOwnersIds) && empty($jointOwnersIds))) {
            unset($this->JointOwnersIds);
        } else {
            $this->JointOwnersIds = $jointOwnersIds;
        }
        return $this;
    }
    /**
     * Get JointPlanSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointPlanSummary()
    {
        return isset($this->JointPlanSummary) ? $this->JointPlanSummary : null;
    }
    /**
     * Set JointPlanSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointPlanSummary
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setJointPlanSummary($jointPlanSummary = null)
    {
        // validation for constraint: string
        if (!is_null($jointPlanSummary) && !is_string($jointPlanSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointPlanSummary, true), gettype($jointPlanSummary)), __LINE__);
        }
        if (is_null($jointPlanSummary) || (is_array($jointPlanSummary) && empty($jointPlanSummary))) {
            unset($this->JointPlanSummary);
        } else {
            $this->JointPlanSummary = $jointPlanSummary;
        }
        return $this;
    }
    /**
     * Get MembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMembershipName()
    {
        return isset($this->MembershipName) ? $this->MembershipName : null;
    }
    /**
     * Set MembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $membershipName
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setMembershipName(\patest\StructType\GlobalString $membershipName = null)
    {
        if (is_null($membershipName) || (is_array($membershipName) && empty($membershipName))) {
            unset($this->MembershipName);
        } else {
            $this->MembershipName = $membershipName;
        }
        return $this;
    }
    /**
     * Get NumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtras()
    {
        return isset($this->NumberOfExtras) ? $this->NumberOfExtras : null;
    }
    /**
     * Set NumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtras
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setNumberOfExtras($numberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtras) && !(is_int($numberOfExtras) || ctype_digit($numberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtras, true), gettype($numberOfExtras)), __LINE__);
        }
        if (is_null($numberOfExtras) || (is_array($numberOfExtras) && empty($numberOfExtras))) {
            unset($this->NumberOfExtras);
        } else {
            $this->NumberOfExtras = $numberOfExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwners()
    {
        return isset($this->NumberOfOwners) ? $this->NumberOfOwners : null;
    }
    /**
     * Set NumberOfOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwners
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setNumberOfOwners($numberOfOwners = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwners) && !(is_int($numberOfOwners) || ctype_digit($numberOfOwners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwners, true), gettype($numberOfOwners)), __LINE__);
        }
        if (is_null($numberOfOwners) || (is_array($numberOfOwners) && empty($numberOfOwners))) {
            unset($this->NumberOfOwners);
        } else {
            $this->NumberOfOwners = $numberOfOwners;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeId()
    {
        return isset($this->OwnersPriceTypeId) ? $this->OwnersPriceTypeId : null;
    }
    /**
     * Set OwnersPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setOwnersPriceTypeId($ownersPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeId) && !is_string($ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeId, true), gettype($ownersPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownersPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownersPriceTypeId, true)), __LINE__);
        }
        if (is_null($ownersPriceTypeId) || (is_array($ownersPriceTypeId) && empty($ownersPriceTypeId))) {
            unset($this->OwnersPriceTypeId);
        } else {
            $this->OwnersPriceTypeId = $ownersPriceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get PurchaserCanModify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPurchaserCanModify()
    {
        return isset($this->PurchaserCanModify) ? $this->PurchaserCanModify : null;
    }
    /**
     * Set PurchaserCanModify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $purchaserCanModify
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setPurchaserCanModify($purchaserCanModify = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchaserCanModify) && !is_bool($purchaserCanModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchaserCanModify, true), gettype($purchaserCanModify)), __LINE__);
        }
        if (is_null($purchaserCanModify) || (is_array($purchaserCanModify) && empty($purchaserCanModify))) {
            unset($this->PurchaserCanModify);
        } else {
            $this->PurchaserCanModify = $purchaserCanModify;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserName()
    {
        return isset($this->PurchaserName) ? $this->PurchaserName : null;
    }
    /**
     * Set PurchaserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserName
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setPurchaserName($purchaserName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserName) && !is_string($purchaserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserName, true), gettype($purchaserName)), __LINE__);
        }
        if (is_null($purchaserName) || (is_array($purchaserName) && empty($purchaserName))) {
            unset($this->PurchaserName);
        } else {
            $this->PurchaserName = $purchaserName;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
    /**
     * Get TransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionItemId()
    {
        return isset($this->TransactionItemId) ? $this->TransactionItemId : null;
    }
    /**
     * Set TransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionItemId
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setTransactionItemId($transactionItemId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionItemId) && !(is_int($transactionItemId) || ctype_digit($transactionItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionItemId, true), gettype($transactionItemId)), __LINE__);
        }
        if (is_null($transactionItemId) || (is_array($transactionItemId) && empty($transactionItemId))) {
            unset($this->TransactionItemId);
        } else {
            $this->TransactionItemId = $transactionItemId;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UsedBenefitsNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUsedBenefitsNum()
    {
        return isset($this->UsedBenefitsNum) ? $this->UsedBenefitsNum : null;
    }
    /**
     * Set UsedBenefitsNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $usedBenefitsNum
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setUsedBenefitsNum($usedBenefitsNum = null)
    {
        // validation for constraint: int
        if (!is_null($usedBenefitsNum) && !(is_int($usedBenefitsNum) || ctype_digit($usedBenefitsNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usedBenefitsNum, true), gettype($usedBenefitsNum)), __LINE__);
        }
        if (is_null($usedBenefitsNum) || (is_array($usedBenefitsNum) && empty($usedBenefitsNum))) {
            unset($this->UsedBenefitsNum);
        } else {
            $this->UsedBenefitsNum = $usedBenefitsNum;
        }
        return $this;
    }
    /**
     * Get ValidStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidStatus()
    {
        return isset($this->ValidStatus) ? $this->ValidStatus : null;
    }
    /**
     * Set ValidStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validStatus
     * @return \patest\StructType\Membership_MembershipExtended
     */
    public function setValidStatus($validStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($validStatus) && !is_bool($validStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validStatus, true), gettype($validStatus)), __LINE__);
        }
        if (is_null($validStatus) || (is_array($validStatus) && empty($validStatus))) {
            unset($this->ValidStatus);
        } else {
            $this->ValidStatus = $validStatus;
        }
        return $this;
    }
}
