<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ScheduledQueryExecution StructType
 * @subpackage Structs
 */
class Marketing_ScheduledQueryExecution extends PersistableEntity
{
    /**
     * The EmailSentTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSentTo;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSubject;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The Exception
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Exception;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The GeneratedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocument;
    /**
     * The GeneratedDocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocumentName;
    /**
     * The GeneratedDocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneratedDocumentType;
    /**
     * The IsGeneratedDocumentCompressed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGeneratedDocumentCompressed;
    /**
     * The IsSuccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSuccess;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The QueryResultsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QueryResultsCount;
    /**
     * The ServiceRequestsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ServiceRequestsCount;
    /**
     * The UrlToGeneratedDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlToGeneratedDocument;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Marketing.ScheduledQueryExecution
     * @uses Marketing_ScheduledQueryExecution::setEmailSentTo()
     * @uses Marketing_ScheduledQueryExecution::setEmailSubject()
     * @uses Marketing_ScheduledQueryExecution::setError()
     * @uses Marketing_ScheduledQueryExecution::setException()
     * @uses Marketing_ScheduledQueryExecution::setExecutionDate()
     * @uses Marketing_ScheduledQueryExecution::setGeneratedDocument()
     * @uses Marketing_ScheduledQueryExecution::setGeneratedDocumentName()
     * @uses Marketing_ScheduledQueryExecution::setGeneratedDocumentType()
     * @uses Marketing_ScheduledQueryExecution::setIsGeneratedDocumentCompressed()
     * @uses Marketing_ScheduledQueryExecution::setIsSuccess()
     * @uses Marketing_ScheduledQueryExecution::setOrganizationUnitId()
     * @uses Marketing_ScheduledQueryExecution::setProcessDefinitionId()
     * @uses Marketing_ScheduledQueryExecution::setQueryId()
     * @uses Marketing_ScheduledQueryExecution::setQueryResultsCount()
     * @uses Marketing_ScheduledQueryExecution::setServiceRequestsCount()
     * @uses Marketing_ScheduledQueryExecution::setUrlToGeneratedDocument()
     * @uses Marketing_ScheduledQueryExecution::setUserId()
     * @param string $emailSentTo
     * @param string $emailSubject
     * @param string $error
     * @param string $exception
     * @param string $executionDate
     * @param string $generatedDocument
     * @param string $generatedDocumentName
     * @param string $generatedDocumentType
     * @param bool $isGeneratedDocumentCompressed
     * @param bool $isSuccess
     * @param string $organizationUnitId
     * @param string $processDefinitionId
     * @param string $queryId
     * @param int $queryResultsCount
     * @param int $serviceRequestsCount
     * @param string $urlToGeneratedDocument
     * @param string $userId
     */
    public function __construct($emailSentTo = null, $emailSubject = null, $error = null, $exception = null, $executionDate = null, $generatedDocument = null, $generatedDocumentName = null, $generatedDocumentType = null, $isGeneratedDocumentCompressed = null, $isSuccess = null, $organizationUnitId = null, $processDefinitionId = null, $queryId = null, $queryResultsCount = null, $serviceRequestsCount = null, $urlToGeneratedDocument = null, $userId = null)
    {
        $this
            ->setEmailSentTo($emailSentTo)
            ->setEmailSubject($emailSubject)
            ->setError($error)
            ->setException($exception)
            ->setExecutionDate($executionDate)
            ->setGeneratedDocument($generatedDocument)
            ->setGeneratedDocumentName($generatedDocumentName)
            ->setGeneratedDocumentType($generatedDocumentType)
            ->setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed)
            ->setIsSuccess($isSuccess)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessDefinitionId($processDefinitionId)
            ->setQueryId($queryId)
            ->setQueryResultsCount($queryResultsCount)
            ->setServiceRequestsCount($serviceRequestsCount)
            ->setUrlToGeneratedDocument($urlToGeneratedDocument)
            ->setUserId($userId);
    }
    /**
     * Get EmailSentTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSentTo()
    {
        return isset($this->EmailSentTo) ? $this->EmailSentTo : null;
    }
    /**
     * Set EmailSentTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSentTo
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setEmailSentTo($emailSentTo = null)
    {
        // validation for constraint: string
        if (!is_null($emailSentTo) && !is_string($emailSentTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSentTo, true), gettype($emailSentTo)), __LINE__);
        }
        if (is_null($emailSentTo) || (is_array($emailSentTo) && empty($emailSentTo))) {
            unset($this->EmailSentTo);
        } else {
            $this->EmailSentTo = $emailSentTo;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSubject
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSubject, true), gettype($emailSubject)), __LINE__);
        }
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Exception value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getException()
    {
        return isset($this->Exception) ? $this->Exception : null;
    }
    /**
     * Set Exception value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exception
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setException($exception = null)
    {
        // validation for constraint: string
        if (!is_null($exception) && !is_string($exception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exception, true), gettype($exception)), __LINE__);
        }
        if (is_null($exception) || (is_array($exception) && empty($exception))) {
            unset($this->Exception);
        } else {
            $this->Exception = $exception;
        }
        return $this;
    }
    /**
     * Get ExecutionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDate()
    {
        return isset($this->ExecutionDate) ? $this->ExecutionDate : null;
    }
    /**
     * Set ExecutionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDate
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        if (is_null($executionDate) || (is_array($executionDate) && empty($executionDate))) {
            unset($this->ExecutionDate);
        } else {
            $this->ExecutionDate = $executionDate;
        }
        return $this;
    }
    /**
     * Get GeneratedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocument()
    {
        return isset($this->GeneratedDocument) ? $this->GeneratedDocument : null;
    }
    /**
     * Set GeneratedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocument
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setGeneratedDocument($generatedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocument) && !is_string($generatedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocument, true), gettype($generatedDocument)), __LINE__);
        }
        if (is_null($generatedDocument) || (is_array($generatedDocument) && empty($generatedDocument))) {
            unset($this->GeneratedDocument);
        } else {
            $this->GeneratedDocument = $generatedDocument;
        }
        return $this;
    }
    /**
     * Get GeneratedDocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocumentName()
    {
        return isset($this->GeneratedDocumentName) ? $this->GeneratedDocumentName : null;
    }
    /**
     * Set GeneratedDocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocumentName
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setGeneratedDocumentName($generatedDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocumentName) && !is_string($generatedDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocumentName, true), gettype($generatedDocumentName)), __LINE__);
        }
        if (is_null($generatedDocumentName) || (is_array($generatedDocumentName) && empty($generatedDocumentName))) {
            unset($this->GeneratedDocumentName);
        } else {
            $this->GeneratedDocumentName = $generatedDocumentName;
        }
        return $this;
    }
    /**
     * Get GeneratedDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedDocumentType()
    {
        return isset($this->GeneratedDocumentType) ? $this->GeneratedDocumentType : null;
    }
    /**
     * Set GeneratedDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedDocumentType
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setGeneratedDocumentType($generatedDocumentType = null)
    {
        // validation for constraint: string
        if (!is_null($generatedDocumentType) && !is_string($generatedDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedDocumentType, true), gettype($generatedDocumentType)), __LINE__);
        }
        if (is_null($generatedDocumentType) || (is_array($generatedDocumentType) && empty($generatedDocumentType))) {
            unset($this->GeneratedDocumentType);
        } else {
            $this->GeneratedDocumentType = $generatedDocumentType;
        }
        return $this;
    }
    /**
     * Get IsGeneratedDocumentCompressed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGeneratedDocumentCompressed()
    {
        return isset($this->IsGeneratedDocumentCompressed) ? $this->IsGeneratedDocumentCompressed : null;
    }
    /**
     * Set IsGeneratedDocumentCompressed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGeneratedDocumentCompressed
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setIsGeneratedDocumentCompressed($isGeneratedDocumentCompressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGeneratedDocumentCompressed) && !is_bool($isGeneratedDocumentCompressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGeneratedDocumentCompressed, true), gettype($isGeneratedDocumentCompressed)), __LINE__);
        }
        if (is_null($isGeneratedDocumentCompressed) || (is_array($isGeneratedDocumentCompressed) && empty($isGeneratedDocumentCompressed))) {
            unset($this->IsGeneratedDocumentCompressed);
        } else {
            $this->IsGeneratedDocumentCompressed = $isGeneratedDocumentCompressed;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return isset($this->IsSuccess) ? $this->IsSuccess : null;
    }
    /**
     * Set IsSuccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSuccess
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccess, true), gettype($isSuccess)), __LINE__);
        }
        if (is_null($isSuccess) || (is_array($isSuccess) && empty($isSuccess))) {
            unset($this->IsSuccess);
        } else {
            $this->IsSuccess = $isSuccess;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get QueryResultsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQueryResultsCount()
    {
        return isset($this->QueryResultsCount) ? $this->QueryResultsCount : null;
    }
    /**
     * Set QueryResultsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $queryResultsCount
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setQueryResultsCount($queryResultsCount = null)
    {
        // validation for constraint: int
        if (!is_null($queryResultsCount) && !(is_int($queryResultsCount) || ctype_digit($queryResultsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryResultsCount, true), gettype($queryResultsCount)), __LINE__);
        }
        if (is_null($queryResultsCount) || (is_array($queryResultsCount) && empty($queryResultsCount))) {
            unset($this->QueryResultsCount);
        } else {
            $this->QueryResultsCount = $queryResultsCount;
        }
        return $this;
    }
    /**
     * Get ServiceRequestsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getServiceRequestsCount()
    {
        return isset($this->ServiceRequestsCount) ? $this->ServiceRequestsCount : null;
    }
    /**
     * Set ServiceRequestsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $serviceRequestsCount
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setServiceRequestsCount($serviceRequestsCount = null)
    {
        // validation for constraint: int
        if (!is_null($serviceRequestsCount) && !(is_int($serviceRequestsCount) || ctype_digit($serviceRequestsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceRequestsCount, true), gettype($serviceRequestsCount)), __LINE__);
        }
        if (is_null($serviceRequestsCount) || (is_array($serviceRequestsCount) && empty($serviceRequestsCount))) {
            unset($this->ServiceRequestsCount);
        } else {
            $this->ServiceRequestsCount = $serviceRequestsCount;
        }
        return $this;
    }
    /**
     * Get UrlToGeneratedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlToGeneratedDocument()
    {
        return isset($this->UrlToGeneratedDocument) ? $this->UrlToGeneratedDocument : null;
    }
    /**
     * Set UrlToGeneratedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlToGeneratedDocument
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setUrlToGeneratedDocument($urlToGeneratedDocument = null)
    {
        // validation for constraint: string
        if (!is_null($urlToGeneratedDocument) && !is_string($urlToGeneratedDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlToGeneratedDocument, true), gettype($urlToGeneratedDocument)), __LINE__);
        }
        if (is_null($urlToGeneratedDocument) || (is_array($urlToGeneratedDocument) && empty($urlToGeneratedDocument))) {
            unset($this->UrlToGeneratedDocument);
        } else {
            $this->UrlToGeneratedDocument = $urlToGeneratedDocument;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Marketing_ScheduledQueryExecution
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
