<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkTicketsForResale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MarkTicketsForResale-Request
 * @subpackage Structs
 */
class MarkTicketsForResale_Request extends ExtensibleDataContract
{
    /**
     * The IsCancelRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCancelRequest;
    /**
     * The ResaleRequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ResaleRequestDetails
     */
    public $ResaleRequestDetails;
    /**
     * Constructor method for MarkTicketsForResale-Request
     * @uses MarkTicketsForResale_Request::setIsCancelRequest()
     * @uses MarkTicketsForResale_Request::setResaleRequestDetails()
     * @param bool $isCancelRequest
     * @param \patest\StructType\ResaleRequestDetails $resaleRequestDetails
     */
    public function __construct($isCancelRequest = null, \patest\StructType\ResaleRequestDetails $resaleRequestDetails = null)
    {
        $this
            ->setIsCancelRequest($isCancelRequest)
            ->setResaleRequestDetails($resaleRequestDetails);
    }
    /**
     * Get IsCancelRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCancelRequest()
    {
        return isset($this->IsCancelRequest) ? $this->IsCancelRequest : null;
    }
    /**
     * Set IsCancelRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCancelRequest
     * @return \patest\StructType\MarkTicketsForResale_Request
     */
    public function setIsCancelRequest($isCancelRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCancelRequest) && !is_bool($isCancelRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCancelRequest, true), gettype($isCancelRequest)), __LINE__);
        }
        if (is_null($isCancelRequest) || (is_array($isCancelRequest) && empty($isCancelRequest))) {
            unset($this->IsCancelRequest);
        } else {
            $this->IsCancelRequest = $isCancelRequest;
        }
        return $this;
    }
    /**
     * Get ResaleRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ResaleRequestDetails|null
     */
    public function getResaleRequestDetails()
    {
        return isset($this->ResaleRequestDetails) ? $this->ResaleRequestDetails : null;
    }
    /**
     * Set ResaleRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ResaleRequestDetails $resaleRequestDetails
     * @return \patest\StructType\MarkTicketsForResale_Request
     */
    public function setResaleRequestDetails(\patest\StructType\ResaleRequestDetails $resaleRequestDetails = null)
    {
        if (is_null($resaleRequestDetails) || (is_array($resaleRequestDetails) && empty($resaleRequestDetails))) {
            unset($this->ResaleRequestDetails);
        } else {
            $this->ResaleRequestDetails = $resaleRequestDetails;
        }
        return $this;
    }
}
